/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalRelease;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalFixpackRelease {
    private static final String _FIXPACK_VERSION_PROPERTY_NAME = "portal.release.fixpack.version";
    private static final Pattern _fixpackFileNamePattern = Pattern.compile("liferay-fix-pack-(de|dxp|portal)-(?<portalFixpackVersion>\\d+)-(?<portalBuildVersion>\\d+)(-build\\d*)?(-src)?.zip");
    private static final Pattern _fixpackURLPattern = Pattern.compile("https?://.+/(?<fixpackFileName>[^/]+.zip)");
    private final URL _portalFixpackURL;
    private final String _portalFixpackVersion;
    private final PortalRelease _portalRelease;

    public PortalFixpackRelease(String portalFixpackVersion, PortalRelease portalRelease) {
        this._portalFixpackVersion = portalFixpackVersion;
        this._portalRelease = portalRelease;
        try {
            String portalVersion = this._portalRelease.getPortalVersion();
            String portalFixpackType = "dxp";
            if (portalVersion.contains("7.0")) {
                portalFixpackType = "de";
            }
            String portalBaseVersion = portalVersion.replaceAll("(\\d)\\.(\\d)\\.(\\d\\d).*", "$1.$2.$3");
            String portalBaseBuildVersion = portalBaseVersion.replaceAll("\\.", "");
            this._portalFixpackURL = new URL(JenkinsResultsParserUtil.combine("https://files.liferay.com/private/ee/fix-packs/", portalBaseVersion, "/", portalFixpackType, "/liferay-fix-pack-", portalFixpackType, "-", this._portalFixpackVersion, "-", portalBaseBuildVersion, ".zip"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public PortalFixpackRelease(String portalFixpackVersion, String portalVersion) {
        this(portalFixpackVersion, new PortalRelease(portalVersion));
    }

    public PortalFixpackRelease(URL portalFixpackURL) {
        Matcher fixpackURLMatcher = _fixpackURLPattern.matcher(portalFixpackURL.toString());
        if (!fixpackURLMatcher.find()) {
            throw new RuntimeException("Invalid URL " + portalFixpackURL);
        }
        String fixpackFileName = fixpackURLMatcher.group("fixpackFileName");
        Matcher fixpackFileNameMatcher = _fixpackFileNamePattern.matcher(fixpackFileName);
        if (!fixpackFileNameMatcher.find()) {
            throw new RuntimeException("Invalid fixpack file name " + fixpackFileName);
        }
        this._portalFixpackVersion = fixpackFileNameMatcher.group("portalFixpackVersion");
        this._portalRelease = new PortalRelease(this._getPortalVersion(fixpackFileNameMatcher.group("portalBuildVersion"), this._portalFixpackVersion));
        String portalFixpackURLString = portalFixpackURL.toString();
        portalFixpackURLString = portalFixpackURLString.replace("http://mirrors/", "https://");
        portalFixpackURLString = portalFixpackURLString.replace("http://mirrors.lax.liferay.com/", "https://");
        try {
            this._portalFixpackURL = new URL(portalFixpackURLString);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public String getHTMLReport() {
        StringBuilder sb = new StringBuilder();
        String urlString = String.valueOf(this.getPortalFixpackURL());
        sb.append("<ul>");
        sb.append("<li><a href=\"");
        sb.append(urlString);
        sb.append("\">");
        sb.append(urlString.replaceAll(".+/([^/]+)", "$1"));
        sb.append("</a></li>");
        sb.append("</ul>");
        return sb.toString();
    }

    public URL getPortalFixpackURL() {
        return this._portalFixpackURL;
    }

    public String getPortalFixpackVersion() {
        return this._portalFixpackVersion;
    }

    public PortalRelease getPortalRelease() {
        return this._portalRelease;
    }

    private String _getPortalVersion(String portalBuildVersion, String portalFixpackVersion) {
        String basePortalVersion;
        if (portalBuildVersion.startsWith("73")) {
            if (portalFixpackVersion.equals("1") || portalFixpackVersion.equals("2")) {
                return "7.3.10.1";
            }
            if (portalFixpackVersion.equals("3")) {
                return "7.3.10.3";
            }
            return "7.3.10.u" + portalFixpackVersion;
        }
        String basePortalVersionRegex = "(\\d)(\\d)(\\d\\d)";
        StringBuilder sb = new StringBuilder();
        sb.append(portalBuildVersion.replaceAll(basePortalVersionRegex, "$1"));
        sb.append(".");
        sb.append(portalBuildVersion.replaceAll(basePortalVersionRegex, "$2"));
        sb.append(".");
        sb.append(portalBuildVersion.replaceAll(basePortalVersionRegex, "$3"));
        String portalVersion = basePortalVersion = sb.toString();
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            int latestPortalFixVersion = -1;
            for (String propertyName : buildProperties.stringPropertyNames()) {
                int portalFixVersion;
                String propertyNameRegex;
                if (!propertyName.matches(propertyNameRegex = "portal.release.fixpack.version\\[\\d\\.\\d\\.\\d{2}\\.(\\d+)\\]") || (portalFixVersion = Integer.valueOf(propertyName.replaceAll(propertyNameRegex, "$1")).intValue()) <= latestPortalFixVersion) continue;
                latestPortalFixVersion = portalFixVersion;
            }
            if (latestPortalFixVersion == -1) {
                return portalVersion;
            }
            for (int i = 1; i <= latestPortalFixVersion; ++i) {
                String portalVersionCandidate = basePortalVersion + "." + i;
                String portalReleaseFixpackVersion = JenkinsResultsParserUtil.getProperty(buildProperties, _FIXPACK_VERSION_PROPERTY_NAME, portalVersionCandidate);
                if (portalReleaseFixpackVersion == null || portalReleaseFixpackVersion.isEmpty() || Integer.valueOf(portalFixpackVersion) < Integer.valueOf(portalReleaseFixpackVersion)) continue;
                portalVersion = portalVersionCandidate;
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return portalVersion;
    }
}

