/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchBuildData;
import com.liferay.jenkins.results.parser.BatchBuildRunner;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalBatchBuildData;
import com.liferay.jenkins.results.parser.TestBatch;
import com.liferay.jenkins.results.parser.TestBatchFactory;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.File;

public abstract class PortalBatchBuildRunner<T extends PortalBatchBuildData>
extends BatchBuildRunner<T> {
    private Workspace _workspace;

    @Override
    public Workspace getWorkspace() {
        if (this._workspace != null) {
            return this._workspace;
        }
        PortalBatchBuildData portalBatchBuildData = (PortalBatchBuildData)this.getBuildData();
        this._workspace = WorkspaceFactory.newWorkspace(portalBatchBuildData.getPortalGitHubRepositoryName(), portalBatchBuildData.getPortalUpstreamBranchName());
        for (WorkspaceGitRepository workspaceGitRepository : this._workspace.getWorkspaceGitRepositories()) {
            workspaceGitRepository.addPropertyOption(portalBatchBuildData.getBatchName());
            workspaceGitRepository.addPropertyOption(String.valueOf((Object)portalBatchBuildData.getBuildProfile()));
            workspaceGitRepository.addPropertyOption(workspaceGitRepository.getUpstreamBranchName());
            String dockerEnabled = System.getenv("DOCKER_ENABLED");
            if (dockerEnabled != null && dockerEnabled.equals("true")) {
                workspaceGitRepository.addPropertyOption("docker");
            }
            if (JenkinsResultsParserUtil.isWindows()) {
                workspaceGitRepository.addPropertyOption("windows");
                continue;
            }
            workspaceGitRepository.addPropertyOption("unix");
        }
        WorkspaceGitRepository primaryWorkspaceGitRepository = this._workspace.getPrimaryWorkspaceGitRepository();
        primaryWorkspaceGitRepository.setSenderBranchSHA(portalBatchBuildData.getPortalBranchSHA());
        return this._workspace;
    }

    @Override
    public void run() {
        this.updateBuildDescription();
        this.setUpWorkspace();
        this.runTestBatch();
        this.publishArtifacts();
        this.updateBuildDescription();
    }

    protected PortalBatchBuildRunner(T portalBatchBuildData) {
        super(portalBatchBuildData);
    }

    protected void publishArtifacts() {
        PortalBatchBuildData portalBatchBuildData = (PortalBatchBuildData)this.getBuildData();
        File artifactDir = portalBatchBuildData.getArtifactDir();
        if (artifactDir.exists()) {
            this.publishToUserContentDir(artifactDir);
        }
    }

    protected void runTestBatch() {
        TestBatch testBatch = TestBatchFactory.newTestBatch((BatchBuildData)this.getBuildData(), this.getWorkspace());
        testBatch.run();
    }
}

