/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitRepositoryJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import java.util.Set;
import org.json.JSONObject;

public abstract class PortalAcceptanceTestSuiteJob
extends PortalGitRepositoryJob
implements TestSuiteJob {
    private final String _testSuiteName;

    @Override
    public Job.DistType getDistType() {
        JobProperty jobProperty = this.getJobProperty("dist.type");
        String distType = jobProperty.getValue();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(distType)) {
            for (Job.DistType distTypeValue : Job.DistType.values()) {
                if (!distType.equals(distTypeValue.toString())) continue;
                this.recordJobProperty(jobProperty);
                return distTypeValue;
            }
        }
        return Job.DistType.CI;
    }

    @Override
    public Set<String> getDistTypes() {
        Set<String> distTypes = super.getDistTypes();
        if (!this._testSuiteName.equals("relevant")) {
            return distTypes;
        }
        JobProperty jobProperty = this.getJobProperty("test.batch.dist.app.servers[stable]");
        distTypes.addAll(this.getSetFromString(jobProperty.getValue()));
        return distTypes;
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("test_suite_name", (Object)this._testSuiteName);
        return this.jsonObject;
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    protected PortalAcceptanceTestSuiteJob(Job.BuildProfile buildProfile, String jobName, PortalGitWorkingDirectory portalGitWorkingDirectory, String testSuiteName, String upstreamBranchName) {
        super(buildProfile, jobName, portalGitWorkingDirectory, upstreamBranchName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(testSuiteName)) {
            testSuiteName = "default";
        }
        this._testSuiteName = testSuiteName;
    }

    protected PortalAcceptanceTestSuiteJob(JSONObject jsonObject) {
        super(jsonObject);
        this._testSuiteName = jsonObject.getString("test_suite_name");
    }

    @Override
    protected Set<String> getRawBatchNames() {
        Set<String> rawBatchNames = super.getRawBatchNames();
        if (!this.testRelevantChanges()) {
            return rawBatchNames;
        }
        JobProperty jobProperty = this.getJobProperty("test.batch.names[stable]");
        this.recordJobProperty(jobProperty);
        rawBatchNames.addAll(this.getSetFromString(jobProperty.getValue()));
        return rawBatchNames;
    }
}

