/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalAcceptanceTestSuiteJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONObject;

public class PortalAcceptancePullRequestJob
extends PortalAcceptanceTestSuiteJob {
    private Boolean _centralMergePullRequest;

    public boolean isCentralMergePullRequest() {
        File modifiedFile;
        String modifiedFileName;
        if (this._centralMergePullRequest != null) {
            return this._centralMergePullRequest;
        }
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        List<File> currentBranchModifiedFiles = gitWorkingDirectory.getModifiedFilesList();
        if (currentBranchModifiedFiles.size() == 1 && (modifiedFileName = (modifiedFile = currentBranchModifiedFiles.get(0)).getName()).equals("ci-merge")) {
            this._centralMergePullRequest = true;
            return this._centralMergePullRequest;
        }
        this._centralMergePullRequest = false;
        return this._centralMergePullRequest;
    }

    protected PortalAcceptancePullRequestJob(Job.BuildProfile buildProfile, String jobName, PortalGitWorkingDirectory portalGitWorkingDirectory, String testSuiteName, String upstreamBranchName) {
        super(buildProfile, jobName, portalGitWorkingDirectory, testSuiteName, upstreamBranchName);
    }

    protected PortalAcceptancePullRequestJob(JSONObject jsonObject) {
        super(jsonObject);
    }

    @Override
    protected Set<String> getRawBatchNames() {
        Set<String> batchNames = super.getRawBatchNames();
        if (this._isRelevantTestSuite() && this._isPortalWebOnly()) {
            String[] portalWebOnlyBatchNameMarkers = new String[]{"compile-jsp", "functional", "portal-web", "source-format"};
            TreeSet<String> portalWebOnlyBatchNames = new TreeSet<String>();
            block0: for (String batchName : batchNames) {
                for (String portalWebOnlyBatchNameMarker : portalWebOnlyBatchNameMarkers) {
                    if (!batchName.contains(portalWebOnlyBatchNameMarker)) continue;
                    portalWebOnlyBatchNames.add(batchName);
                    continue block0;
                }
            }
            return portalWebOnlyBatchNames;
        }
        return batchNames;
    }

    private boolean _isPortalWebOnly() {
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        File portalWebDirectory = new File(gitWorkingDirectory.getWorkingDirectory(), "portal-web");
        for (File modifiedFile : gitWorkingDirectory.getModifiedFilesList()) {
            if (JenkinsResultsParserUtil.isFileInDirectory(portalWebDirectory, modifiedFile)) continue;
            return false;
        }
        return true;
    }

    private boolean _isRelevantTestSuite() {
        String testSuiteName = this.getTestSuiteName();
        return testSuiteName.equals("relevant");
    }
}

