/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;

public class PortalAWSJob
extends BaseJob
implements PortalTestClassJob {
    private final String _portalUpstreamBranchName;

    @Override
    public Set<String> getDistTypes() {
        return new HashSet<String>();
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("portal_upstream_branch_name", (Object)this._portalUpstreamBranchName);
        return this.jsonObject;
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(this._portalUpstreamBranchName);
    }

    protected PortalAWSJob(Job.BuildProfile buildProfile, String jobName, String portalUpstreamBranchName) {
        super(buildProfile, jobName);
        this._portalUpstreamBranchName = portalUpstreamBranchName;
        this._initialize();
    }

    protected PortalAWSJob(JSONObject jsonObject) {
        super(jsonObject);
        this._portalUpstreamBranchName = jsonObject.getString("portal_upstream_branch_name");
        this._initialize();
    }

    private void _initialize() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        this.jobPropertiesFiles.add(new File(portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
        GitWorkingDirectory jenkinsGitWorkingDirectory = GitWorkingDirectoryFactory.newJenkinsGitWorkingDirectory();
        this.jobPropertiesFiles.add(new File(jenkinsGitWorkingDirectory.getWorkingDirectory(), "commands/build.properties"));
        this.jobPropertiesFiles.add(new File(jenkinsGitWorkingDirectory.getWorkingDirectory(), "commands/dependencies/test-aws-batch.properties"));
    }
}

