/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DefaultTopLevelBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsBranchInformationBuild;
import com.liferay.jenkins.results.parser.PluginsWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PortalBranchInformationBuild;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceBuild;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import java.util.Objects;

public class PluginsTopLevelBuild
extends DefaultTopLevelBuild
implements PluginsBranchInformationBuild,
PortalBranchInformationBuild,
PortalWorkspaceBuild {
    public PluginsTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBaseGitRepositoryName() {
        String repositoryName = "liferay-plugins";
        if (!Objects.equals(this.getBranchName(), "master")) {
            repositoryName = repositoryName + "-ee";
        }
        return repositoryName;
    }

    @Override
    public String getBranchName() {
        return this.getParameterValue("TEST_PLUGINS_BRANCH_NAME");
    }

    public String getPluginName() {
        return this.getParameterValue("TEST_PLUGIN_NAME");
    }

    @Override
    public Build.BranchInformation getPluginsBranchInformation() {
        if (this.fromArchive) {
            return this.getBranchInformation("plugins");
        }
        PortalWorkspace portalWorkspace = this.getPortalWorkspace();
        if (portalWorkspace == null) {
            return null;
        }
        PluginsWorkspaceGitRepository workspaceGitRepository = portalWorkspace.getPluginsWorkspaceGitRepository();
        if (workspaceGitRepository == null) {
            return null;
        }
        return new TopLevelBuild.WorkspaceBranchInformation(workspaceGitRepository);
    }

    @Override
    public Build.BranchInformation getPortalBaseBranchInformation() {
        if (!this.fromArchive) {
            return null;
        }
        Build.BranchInformation portalBranchInformation = this.getPortalBranchInformation();
        String upstreamBranchName = portalBranchInformation.getUpstreamBranchName();
        if (upstreamBranchName.contains("-private")) {
            return this.getBranchInformation("portal.base");
        }
        return null;
    }

    @Override
    public Build.BranchInformation getPortalBranchInformation() {
        if (this.fromArchive) {
            return this.getBranchInformation("portal");
        }
        PortalWorkspace portalWorkspace = this.getPortalWorkspace();
        if (portalWorkspace == null) {
            return null;
        }
        PortalWorkspaceGitRepository workspaceGitRepository = portalWorkspace.getPortalWorkspaceGitRepository();
        if (workspaceGitRepository == null) {
            return null;
        }
        return new TopLevelBuild.WorkspaceBranchInformation(workspaceGitRepository);
    }

    @Override
    public PortalWorkspace getPortalWorkspace() {
        Workspace workspace = this.getWorkspace();
        if (!(workspace instanceof PortalWorkspace)) {
            return null;
        }
        return (PortalWorkspace)workspace;
    }

    @Override
    public String getTestSuiteName() {
        return this.getPluginName();
    }

    @Override
    public Workspace getWorkspace() {
        String pluginsBranchSHA;
        Workspace workspace = WorkspaceFactory.newWorkspace(this.getBaseGitRepositoryName(), this.getBranchName(), this.getJobName());
        if (!(workspace instanceof PortalWorkspace)) {
            return workspace;
        }
        PortalWorkspace portalWorkspace = (PortalWorkspace)workspace;
        portalWorkspace.setBuildProfile(this.getBuildProfile());
        String portalGitHubURL = this._getPortalGitHubURL();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalGitHubURL)) {
            PortalWorkspaceGitRepository portalWorkspaceGitRepository = portalWorkspace.getPortalWorkspaceGitRepository();
            portalWorkspaceGitRepository.setGitHubURL(portalGitHubURL);
        }
        PluginsWorkspaceGitRepository pluginsWorkspaceGitRepository = portalWorkspace.getPluginsWorkspaceGitRepository();
        String pluginsGitHubURL = this._getPluginsGitHubURL();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(pluginsGitHubURL)) {
            pluginsWorkspaceGitRepository.setGitHubURL(pluginsGitHubURL);
        }
        if (JenkinsResultsParserUtil.isSHA(pluginsBranchSHA = this._getPluginsBranchSHA())) {
            pluginsWorkspaceGitRepository.setSenderBranchSHA(pluginsBranchSHA);
        }
        return workspace;
    }

    private String _getPluginsBranchSHA() {
        return this.getParameterValue("TEST_PLUGINS_GIT_ID");
    }

    private String _getPluginsGitHubURL() {
        String pluginsBranchName = this.getParameterValue("TEST_PLUGINS_RELEASE_TAG");
        String pluginsBranchUsername = this.getParameterValue("TEST_PLUGINS_BRANCH_USERNAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(pluginsBranchName) || JenkinsResultsParserUtil.isNullOrEmpty(pluginsBranchUsername)) {
            return null;
        }
        return JenkinsResultsParserUtil.combine("https://github.com/", pluginsBranchUsername, "/", this.getBaseGitRepositoryName(), "/tree/", pluginsBranchName);
    }

    private String _getPortalGitHubURL() {
        String portalBranchName = this.getParameterValue("PORTAL_GITHUB_BRANCH_NAME");
        String portalBranchUsername = this.getParameterValue("PORTAL_GITHUB_BRANCH_USERNAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBranchName) || JenkinsResultsParserUtil.isNullOrEmpty(portalBranchUsername)) {
            return null;
        }
        String portalRepositoryName = "liferay-portal";
        if (!Objects.equals(this.getBranchName(), "master")) {
            portalRepositoryName = portalRepositoryName + "-ee";
        }
        return JenkinsResultsParserUtil.combine("https://github.com/", portalBranchUsername, "/", portalRepositoryName, "/tree/", portalBranchName);
    }
}

