/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.json.JSONObject;

public class PluginsMarketplaceAppJob
extends BaseJob
implements PortalTestClassJob,
TestSuiteJob {
    private final String _appType;
    private PortalGitWorkingDirectory _portalGitWorkingDirectory;
    private final String _portalUpstreamBranchName;

    @Override
    public Set<String> getDistTypes() {
        return Collections.emptySet();
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("app_type", (Object)this._appType);
        this.jsonObject.put("portal_upstream_branch_name", (Object)this._portalUpstreamBranchName);
        return this.jsonObject;
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this._portalGitWorkingDirectory;
    }

    @Override
    public String getTestSuiteName() {
        return this._appType;
    }

    protected PluginsMarketplaceAppJob(Job.BuildProfile buildProfile, String jobName, String portalUpstreamBranchName) {
        super(buildProfile, jobName);
        String appType = System.getenv("TEST_APP_TYPE");
        if (JenkinsResultsParserUtil.isNullOrEmpty(appType)) {
            appType = "community";
        }
        this._portalUpstreamBranchName = portalUpstreamBranchName;
        this._appType = appType;
        this._initialize();
    }

    protected PluginsMarketplaceAppJob(JSONObject jsonObject) {
        super(jsonObject);
        this._appType = jsonObject.getString("app_type");
        this._portalUpstreamBranchName = jsonObject.getString("portal_upstream_branch_name");
        this._initialize();
    }

    private void _initialize() {
        this._portalGitWorkingDirectory = GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(this._portalUpstreamBranchName);
        this.jobPropertiesFiles.add(new File(this._portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
    }
}

