/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PluginsGitRepositoryJob;
import com.liferay.jenkins.results.parser.PluginsGitWorkingDirectory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class PluginsAcceptancePullRequestJob
extends PluginsGitRepositoryJob {
    private final List<File> _pluginsTestBaseDirs = new ArrayList<File>();

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("plugins_test_base_dirs", this._pluginsTestBaseDirs);
        return this.jsonObject;
    }

    @Override
    public List<File> getPluginsTestBaseDirs() {
        return this._pluginsTestBaseDirs;
    }

    protected PluginsAcceptancePullRequestJob(Job.BuildProfile buildProfile, String jobName, String upstreamBranchName) {
        super(buildProfile, jobName, upstreamBranchName);
        PluginsGitWorkingDirectory pluginsGitWorkingDirectory = this.portalGitWorkingDirectory.getPluginsGitWorkingDirectory();
        block0: for (File modifiedFile : pluginsGitWorkingDirectory.getModifiedFilesList()) {
            for (File parentDir = new File(modifiedFile.getPath()); parentDir != null; parentDir = parentDir.getParentFile()) {
                File pluginsTestBaseDir = new File(parentDir, "test/functional");
                if (!pluginsTestBaseDir.exists()) continue;
                if (this._pluginsTestBaseDirs.contains(pluginsTestBaseDir)) continue block0;
                this._pluginsTestBaseDirs.add(pluginsTestBaseDir);
                continue block0;
            }
        }
    }

    protected PluginsAcceptancePullRequestJob(JSONObject jsonObject) {
        super(jsonObject);
        JSONArray pluginsTestBaseDirJSONArray = jsonObject.getJSONArray("plugins_test_base_dirs");
        if (pluginsTestBaseDirJSONArray == null) {
            return;
        }
        for (int i = 0; i < pluginsTestBaseDirJSONArray.length(); ++i) {
            File pluginsTestBaseDir;
            String pluginsTestBaseDirPath = pluginsTestBaseDirJSONArray.getString(i);
            if (JenkinsResultsParserUtil.isNullOrEmpty(pluginsTestBaseDirPath) || this._pluginsTestBaseDirs.contains(pluginsTestBaseDir = new File(pluginsTestBaseDirPath))) continue;
            this._pluginsTestBaseDirs.add(pluginsTestBaseDir);
        }
    }
}

