/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.json.JSONObject;

public class NotificationUtil {
    public static void sendEmail(String body, String senderName, String subject, String recipientEmailAddress) {
        NotificationUtil.sendEmail(JenkinsResultsParserUtil.combine(senderName, "@", JenkinsResultsParserUtil.getHostName(null)), senderName, recipientEmailAddress, subject, body);
    }

    public static void sendEmail(String senderEmailAddress, String senderName, String recipientEmailAddress, String subject, String body) {
        NotificationUtil.sendEmail(senderEmailAddress, senderName, recipientEmailAddress, subject, body, null);
    }

    public static void sendEmail(String senderEmailAddress, String senderName, String recipientEmailAddress, String subject, String body, String attachmentFileName) {
        Properties sessionProperties = System.getProperties();
        sessionProperties.put("mail.smtp.auth", "true");
        sessionProperties.put("mail.smtp.port", (Object)587);
        sessionProperties.put("mail.smtp.starttls.enable", "true");
        sessionProperties.put("mail.transport.protocol", "smtp");
        Session session = Session.getDefaultInstance((Properties)sessionProperties);
        MimeMessage mimeMessage = new MimeMessage(session);
        try {
            mimeMessage.setFrom((Address)new InternetAddress(senderEmailAddress, senderName));
            mimeMessage.setRecipients(Message.RecipientType.TO, recipientEmailAddress);
            mimeMessage.setSubject(subject);
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)body, "text/plain");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            if (attachmentFileName != null && !attachmentFileName.equals("")) {
                MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(attachmentFileName);
                attachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
                File attachmentFile = new File(attachmentFileName);
                attachmentBodyPart.setFileName(attachmentFile.getName());
                multipart.addBodyPart((BodyPart)attachmentBodyPart);
            }
            mimeMessage.setContent((Multipart)multipart);
            mimeMessage.saveChanges();
            Transport transport = session.getTransport();
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            transport.connect(buildProperties.getProperty("email.smtp.server"), buildProperties.getProperty("email.smtp.username"), buildProperties.getProperty("email.smtp.password"));
            transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
            System.out.println("Email sent to: " + recipientEmailAddress);
            transport.close();
        }
        catch (IOException | MessagingException exception) {
            System.out.println("Unable to send email.");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void sendSlackNotification(String body, String channelName, String subject) {
        NotificationUtil.sendSlackNotification(body, channelName, ":liferay-ci:", subject, "Liferay CI");
    }

    public static void sendSlackNotification(String body, String channelName, String iconEmoji, String subject, String username) {
        String text = body;
        if (subject == null) {
            subject = "";
        } else if (!(subject = subject.trim()).isEmpty()) {
            subject = JenkinsResultsParserUtil.combine("*", subject, "*\n\n");
            text = JenkinsResultsParserUtil.combine(subject, "> ", body.replaceAll("\n", "\n> "));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("channel", (Object)channelName);
        jsonObject.put("icon_emoji", (Object)iconEmoji);
        jsonObject.put("text", (Object)text);
        jsonObject.put("username", (Object)username);
        try {
            Properties properties = JenkinsResultsParserUtil.getBuildProperties(true);
            JenkinsResultsParserUtil.toString(properties.getProperty("slack.webhook.url"), jsonObject.toString());
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    static {
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(Message.class.getClassLoader());
    }
}

