/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoadBalancerUtil {
    private static final int _RETRIES_SIZE_MAX = 3;
    private static final Map<String, List<JenkinsMaster>> _jenkinsMasters = new HashMap<String, List<JenkinsMaster>>();
    private static final Map<String, Long> _nextUpdateTimestampMap = new HashMap<String, Long>();
    private static long _updateInterval = 10000L;
    private static final Pattern _urlPattern = Pattern.compile("http://(?<masterPrefix>.+-\\d?).liferay.com");

    public static List<JenkinsMaster> getAvailableJenkinsMasters(String masterPrefix, String blacklistString, int minimumRAM, int maximumSlavesPerHost, Properties properties) {
        return LoadBalancerUtil.getAvailableJenkinsMasters(masterPrefix, blacklistString, minimumRAM, maximumSlavesPerHost, properties, true);
    }

    public static List<JenkinsMaster> getAvailableJenkinsMasters(String masterPrefix, String blacklistString, int minimumRAM, int maximumSlavesPerHost, Properties properties, boolean verbose) {
        List<JenkinsMaster> allJenkinsMasters = null;
        if (!_jenkinsMasters.containsKey(masterPrefix)) {
            allJenkinsMasters = JenkinsResultsParserUtil.getJenkinsMasters(properties, JenkinsMaster.getSlaveRAMMinimumDefault(), JenkinsMaster.getSlavesPerHostDefault(), masterPrefix);
            _jenkinsMasters.put(masterPrefix, allJenkinsMasters);
        } else {
            allJenkinsMasters = _jenkinsMasters.get(masterPrefix);
        }
        List<String> blacklist = LoadBalancerUtil._getBlacklist(properties, verbose);
        if (blacklistString != null && !blacklistString.isEmpty()) {
            blacklistString = blacklistString.toLowerCase();
            for (String blacklistItem : blacklistString.split("\\s*,\\s*")) {
                if (blacklist.contains(blacklistItem)) continue;
                blacklist.add(blacklistItem);
            }
        }
        ArrayList<JenkinsMaster> availableJenkinsMasters = new ArrayList<JenkinsMaster>(allJenkinsMasters.size());
        for (JenkinsMaster jenkinsMaster : allJenkinsMasters) {
            if (blacklist.contains(jenkinsMaster.getName()) || jenkinsMaster.getSlaveRAM() < minimumRAM || jenkinsMaster.getSlavesPerHost() > maximumSlavesPerHost) continue;
            availableJenkinsMasters.add(jenkinsMaster);
        }
        return availableJenkinsMasters;
    }

    public static String getMostAvailableMasterURL(boolean verbose, String ... overridePropertiesArray) throws Exception {
        return LoadBalancerUtil.getMostAvailableMasterURL(null, overridePropertiesArray, verbose);
    }

    public static String getMostAvailableMasterURL(Properties properties) {
        return LoadBalancerUtil.getMostAvailableMasterURL(properties, true);
    }

    public static String getMostAvailableMasterURL(Properties properties, boolean verbose) {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        int retries = 0;
        while (true) {
            try {
                String baseInvocationURL = properties.getProperty("base.invocation.url");
                String masterPrefix = LoadBalancerUtil.getMasterPrefix(baseInvocationURL);
                if (masterPrefix.equals(baseInvocationURL)) {
                    String string = baseInvocationURL;
                    return string;
                }
                String blacklistString = properties.getProperty("blacklist");
                Integer minimumRAM = JenkinsMaster.getSlaveRAMMinimumDefault();
                String minimumRAMString = properties.getProperty("minimum.ram");
                if (minimumRAMString != null && minimumRAMString.matches("\\d+")) {
                    minimumRAM = Integer.valueOf(minimumRAMString);
                }
                Integer maximumSlavesPerHost = JenkinsMaster.getSlavesPerHostDefault();
                String maximumSlavesPerHostString = properties.getProperty("maximum.slaves.per.host");
                if (maximumSlavesPerHostString != null && maximumSlavesPerHostString.matches("\\d+")) {
                    maximumSlavesPerHost = (int)maximumSlavesPerHost;
                }
                List<JenkinsMaster> jenkinsMasters = LoadBalancerUtil.getAvailableJenkinsMasters(masterPrefix, blacklistString, minimumRAM, maximumSlavesPerHost, properties, verbose);
                long nextUpdateTimestamp = LoadBalancerUtil._getNextUpdateTimestamp(masterPrefix);
                if (nextUpdateTimestamp < JenkinsResultsParserUtil.getCurrentTimeMillis()) {
                    LoadBalancerUtil._updateJenkinsMasters(jenkinsMasters);
                    LoadBalancerUtil._setNextUpdateTimestamp(masterPrefix, JenkinsResultsParserUtil.getCurrentTimeMillis() + _updateInterval);
                }
                Collections.sort(jenkinsMasters);
                JenkinsMaster mostAvailableJenkinsMaster = jenkinsMasters.get(0);
                if (verbose) {
                    StringBuilder sb = new StringBuilder();
                    for (JenkinsMaster jenkinsMaster : jenkinsMasters) {
                        sb.append(jenkinsMaster.getName());
                        sb.append(" : ");
                        sb.append(jenkinsMaster.getAvailableSlavesCount());
                        sb.append(" : ");
                        sb.append(jenkinsMaster.getAverageQueueLength());
                        sb.append("\n");
                    }
                    System.out.println(sb.toString());
                    sb = new StringBuilder();
                    sb.append("\nMost available master ");
                    sb.append(mostAvailableJenkinsMaster.getName());
                    sb.append(" has ");
                    sb.append(mostAvailableJenkinsMaster.getAvailableSlavesCount());
                    sb.append(" available slaves.");
                    System.out.println(sb.toString());
                }
                int invokedBatchSize = 0;
                try {
                    invokedBatchSize = Integer.parseInt(properties.getProperty("invoked.job.batch.size"));
                }
                catch (Exception exception) {
                    invokedBatchSize = 1;
                }
                mostAvailableJenkinsMaster.addRecentBatch(invokedBatchSize);
                String string = "http://" + mostAvailableJenkinsMaster.getName();
                return string;
            }
            catch (Exception exception) {
                if (retries < 3) {
                    ++retries;
                    continue;
                }
                throw exception;
            }
            finally {
                if (!verbose) continue;
                String durationString = JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start);
                System.out.println("Got most available master URL in " + durationString);
                continue;
            }
            break;
        }
    }

    public static String getMostAvailableMasterURL(String ... overridePropertiesArray) throws Exception {
        return LoadBalancerUtil.getMostAvailableMasterURL(true, overridePropertiesArray);
    }

    public static String getMostAvailableMasterURL(String propertiesURL, String[] overridePropertiesArray) throws Exception {
        return LoadBalancerUtil.getMostAvailableMasterURL(propertiesURL, overridePropertiesArray, true);
    }

    public static String getMostAvailableMasterURL(String propertiesURL, String[] overridePropertiesArray, boolean verbose) throws Exception {
        Properties properties = new Properties();
        if (propertiesURL == null) {
            properties = JenkinsResultsParserUtil.getBuildProperties(false);
        } else {
            properties = new Properties();
            String propertiesString = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(propertiesURL), false, true);
            properties.load(new StringReader(propertiesString));
        }
        if (overridePropertiesArray != null && overridePropertiesArray.length > 0 && overridePropertiesArray.length % 2 == 0) {
            for (int i = 0; i < overridePropertiesArray.length; i += 2) {
                String overridePropertyValue = overridePropertiesArray[i + 1];
                if (overridePropertyValue == null) continue;
                String overridePropertyName = overridePropertiesArray[i];
                properties.setProperty(overridePropertyName, overridePropertyValue);
            }
        }
        return LoadBalancerUtil.getMostAvailableMasterURL(properties, verbose);
    }

    public static void setUpdateInterval(long interval) {
        _updateInterval = interval;
    }

    protected static String getMasterPrefix(String baseInvocationURL) {
        Matcher matcher = _urlPattern.matcher(baseInvocationURL);
        if (!matcher.find()) {
            return baseInvocationURL;
        }
        return matcher.group("masterPrefix");
    }

    private static List<String> _getBlacklist(Properties properties, boolean verbose) {
        String blacklistString = properties.getProperty("jenkins.load.balancer.blacklist", "");
        if (verbose) {
            System.out.println("Blacklist: " + blacklistString);
        }
        ArrayList<String> blacklist = new ArrayList<String>();
        for (String blacklistItem : blacklistString.split(",")) {
            blacklist.add(blacklistItem.trim());
        }
        return blacklist;
    }

    private static long _getNextUpdateTimestamp(String masterPrefix) {
        if (!_nextUpdateTimestampMap.containsKey(masterPrefix)) {
            return 0L;
        }
        return _nextUpdateTimestampMap.get(masterPrefix);
    }

    private static void _setNextUpdateTimestamp(String masterPrefix, long nextUpdateTimestamp) {
        _nextUpdateTimestampMap.put(masterPrefix, nextUpdateTimestamp);
    }

    private static void _updateJenkinsMasters(List<JenkinsMaster> jenkinsMasters) {
        ExecutorService executorService = Executors.newFixedThreadPool(jenkinsMasters.size());
        for (final JenkinsMaster jenkinsMaster : jenkinsMasters) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    jenkinsMaster.update();
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        ArrayList<JenkinsMaster> unavailableJenkinsMasters = new ArrayList<JenkinsMaster>(jenkinsMasters.size());
        for (JenkinsMaster jenkinsMaster : jenkinsMasters) {
            if (jenkinsMaster.isAvailable()) continue;
            unavailableJenkinsMasters.add(jenkinsMaster);
        }
        jenkinsMasters.removeAll(unavailableJenkinsMasters);
        if (jenkinsMasters.isEmpty()) {
            throw new RuntimeException("Unable to communicate with any Jenkins masters");
        }
    }
}

