/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LegacyDataArchiveGroup;
import com.liferay.jenkins.results.parser.LegacyDataArchivePortalVersion;
import com.liferay.jenkins.results.parser.LocalGitBranch;
import com.liferay.jenkins.results.parser.RemoteGitBranch;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class LegacyDataArchiveHelper {
    private final Properties _buildProperties;
    private LocalGitBranch _dataArchiveLocalGitBranch;
    private final File _generatedArchiveDirectory;
    private final List<LegacyDataArchivePortalVersion> _legacyDataArchivePortalVersions;
    private final GitWorkingDirectory _legacyGitWorkingDirectory;
    private final List<String> _portalVersions;

    public LegacyDataArchiveHelper(File generatedArchiveDirectory, GitWorkingDirectory legacyGitWorkingDirectory) {
        this._generatedArchiveDirectory = generatedArchiveDirectory;
        this._legacyGitWorkingDirectory = legacyGitWorkingDirectory;
        this._buildProperties = this._getBuildProperties();
        this._portalVersions = this._getPortalVersions();
        this._legacyDataArchivePortalVersions = this._getLegacyDataArchivePortalVersions();
    }

    public LocalGitBranch createDataArchiveLocalGitBranch() throws IOException {
        String dataArchiveBranchName = JenkinsResultsParserUtil.combine("data-archive-", String.valueOf(JenkinsResultsParserUtil.getCurrentTimeMillis()));
        this._dataArchiveLocalGitBranch = this._legacyGitWorkingDirectory.getLocalGitBranch(dataArchiveBranchName);
        if (this._dataArchiveLocalGitBranch != null) {
            this._legacyGitWorkingDirectory.deleteLocalGitBranch(this._dataArchiveLocalGitBranch);
        }
        this._dataArchiveLocalGitBranch = this._legacyGitWorkingDirectory.createLocalGitBranch(dataArchiveBranchName);
        this._legacyGitWorkingDirectory.checkoutLocalGitBranch(this._dataArchiveLocalGitBranch);
        for (LegacyDataArchivePortalVersion legacyDataArchivePortalVersion : this._legacyDataArchivePortalVersions) {
            List<LegacyDataArchiveGroup> legacyDataArchiveGroups = legacyDataArchivePortalVersion.getLegacyDataArchiveGroups();
            for (LegacyDataArchiveGroup legacyDataArchiveGroup : legacyDataArchiveGroups) {
                legacyDataArchiveGroup.commitLegacyDataArchives();
            }
        }
        RemoteGitBranch remoteGitBranch = this._legacyGitWorkingDirectory.pushToRemoteGitRepository(true, this._dataArchiveLocalGitBranch, dataArchiveBranchName, this._legacyGitWorkingDirectory.getUpstreamGitRemote());
        if (remoteGitBranch == null) {
            throw new RuntimeException("Unable to push data archive branch to upstream");
        }
        return this._dataArchiveLocalGitBranch;
    }

    public Properties getBuildProperties() {
        return this._buildProperties;
    }

    public LocalGitBranch getDataArchiveBranch() {
        return this._dataArchiveLocalGitBranch;
    }

    public File getGeneratedArchiveDirectory() {
        return this._generatedArchiveDirectory;
    }

    public GitWorkingDirectory getLegacyGitWorkingDirectory() {
        return this._legacyGitWorkingDirectory;
    }

    public List<String> getPortalVersions() {
        return this._portalVersions;
    }

    private Properties _getBuildProperties() {
        Properties buildProperties = new Properties();
        File legacyDataWorkingDirectory = this._legacyGitWorkingDirectory.getWorkingDirectory();
        File buildPropertiesFile = new File(legacyDataWorkingDirectory, "build.properties");
        try (FileInputStream fileInputStream = new FileInputStream(buildPropertiesFile);){
            buildProperties.load(fileInputStream);
        }
        catch (IOException ioException) {
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to load ", buildPropertiesFile.getPath()), ioException);
        }
        return buildProperties;
    }

    private List<LegacyDataArchivePortalVersion> _getLegacyDataArchivePortalVersions() {
        ArrayList<LegacyDataArchivePortalVersion> legacyDataArchivePortalVersions = new ArrayList<LegacyDataArchivePortalVersion>();
        for (String portalVersion : this._portalVersions) {
            legacyDataArchivePortalVersions.add(new LegacyDataArchivePortalVersion(this, portalVersion));
        }
        return legacyDataArchivePortalVersions;
    }

    private List<String> _getPortalVersions() {
        String legacyDataArchivePortalVersionsString = this._buildProperties.getProperty("legacy.data.archive.portal.versions");
        List<String> portalVersions = Arrays.asList(legacyDataArchivePortalVersionsString.split(","));
        Collections.sort(portalVersions);
        return portalVersions;
    }
}

