/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BuildReportFactory;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuildReport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class JobReport {
    private static final Map<String, JobReport> _jobReports = new HashMap<String, JobReport>();
    private static final Pattern _jobURLPattern = Pattern.compile("https?://(?<masterHostname>test-\\d+-\\d+)(\\.liferay\\.com)?/job/(?<jobName>[^/]+)/?");
    private JenkinsMaster _jenkinsMaster;
    private final URL _jobURL;
    private List<TopLevelBuildReport> _topLevelBuildReports;

    public static JobReport getInstance(String jenkinsJobURLString) {
        try {
            return JobReport.getInstance(new URL(jenkinsJobURLString));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public static JobReport getInstance(URL jenkinsJobURL) {
        String key = JenkinsResultsParserUtil.getRemoteURL(jenkinsJobURL.toString());
        if (!_jobReports.containsKey(key)) {
            _jobReports.put(key, new JobReport(jenkinsJobURL));
        }
        return _jobReports.get(key);
    }

    public JenkinsMaster getJenkinsMaster() {
        if (this._jenkinsMaster != null) {
            return this._jenkinsMaster;
        }
        Matcher matcher = _jobURLPattern.matcher(String.valueOf(this.getJobURL()));
        if (!matcher.find()) {
            throw new RuntimeException("Invalid Job URL");
        }
        this._jenkinsMaster = JenkinsMaster.getInstance(matcher.group("masterHostname"));
        return this._jenkinsMaster;
    }

    public String getJobName() {
        Matcher matcher = _jobURLPattern.matcher(String.valueOf(this.getJobURL()));
        if (!matcher.find()) {
            throw new RuntimeException("Invalid Job URL");
        }
        return matcher.group("jobName");
    }

    public URL getJobURL() {
        return this._jobURL;
    }

    public List<TopLevelBuildReport> getTopLevelBuildReports(int maxBuildCount) {
        if (this._topLevelBuildReports != null) {
            return this._topLevelBuildReports;
        }
        this._topLevelBuildReports = new ArrayList<TopLevelBuildReport>();
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(String.valueOf(this.getJobURL()), "/api/json?tree=", "builds[actions[parameters[name,value]],*]"));
            if (jsonObject == null) {
                return this._topLevelBuildReports;
            }
            JSONArray buildsJSONArray = jsonObject.optJSONArray("builds");
            if (buildsJSONArray == JSONObject.NULL) {
                return this._topLevelBuildReports;
            }
            for (int i = 0; i < buildsJSONArray.length() && this._topLevelBuildReports.size() < maxBuildCount; ++i) {
                JSONObject buildJSONObject = buildsJSONArray.getJSONObject(i);
                if (buildJSONObject == JSONObject.NULL) continue;
                this._topLevelBuildReports.add(BuildReportFactory.newTopLevelBuildReport(buildJSONObject, this));
            }
            return this._topLevelBuildReports;
        }
        catch (IOException ioException) {
            return this._topLevelBuildReports;
        }
    }

    private JobReport(URL jobURL) {
        Matcher matcher = _jobURLPattern.matcher(String.valueOf(jobURL));
        if (!matcher.find()) {
            throw new RuntimeException("Invalid Job URL");
        }
        try {
            this._jobURL = new URL(JenkinsResultsParserUtil.combine("https://", matcher.group("masterHostname"), ".liferay.com/job/", matcher.group("jobName")));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }
}

