/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public interface Job {
    public Long getAverageBatchDuration(String var1);

    public Long getAverageBatchOverheadDuration(String var1);

    public Long getAverageTestDuration(String var1, String var2);

    public Long getAverageTestOverheadDuration(String var1, String var2);

    public int getAxisCount();

    public AxisTestClassGroup getAxisTestClassGroup(String var1);

    public List<AxisTestClassGroup> getAxisTestClassGroups();

    public Set<String> getBatchNames();

    public List<BatchTestClassGroup> getBatchTestClassGroups();

    public List<Build> getBuildHistory(JenkinsMaster var1);

    public BuildProfile getBuildProfile();

    public String getCompanyDefaultLocale();

    public List<AxisTestClassGroup> getDependentAxisTestClassGroups();

    public Set<String> getDependentBatchNames();

    public List<BatchTestClassGroup> getDependentBatchTestClassGroups();

    public Set<String> getDependentSegmentNames();

    public List<SegmentTestClassGroup> getDependentSegmentTestClassGroups();

    public List<String> getDistNodes();

    public DistType getDistType();

    public Set<String> getDistTypes();

    public Set<String> getDistTypesExcludingTomcat();

    public String getJobName();

    public List<File> getJobPropertiesFiles();

    public List<String> getJobPropertyOptions();

    public String getJobURL(JenkinsMaster var1);

    public JSONObject getJSONObject();

    public Set<String> getSegmentNames();

    public List<SegmentTestClassGroup> getSegmentTestClassGroups();

    public String getTestPropertiesContent();

    public boolean isDownstreamEnabled();

    public boolean isSegmentEnabled();

    public boolean isValidationRequired();

    public boolean testReleaseBundle();

    public boolean testRelevantChanges();

    public static enum DistType {
        CI("ci"),
        RELEASE("release");

        private final String _string;

        public String toString() {
            return this._string;
        }

        private DistType(String string2) {
            this._string = string2;
        }
    }

    public static enum BuildProfile {
        DXP("DXP", "dxp"),
        PORTAL("Portal", "portal");

        private static Map<String, BuildProfile> _buildProfiles;
        private final String _displayString;
        private final String _string;

        public static BuildProfile getByString(String string) {
            return _buildProfiles.get(string);
        }

        public String toDisplayString() {
            return this._displayString;
        }

        public String toString() {
            return this._string;
        }

        private BuildProfile(String displayString, String string2) {
            this._displayString = displayString;
            this._string = string2;
        }

        static {
            _buildProfiles = new HashMap<String, BuildProfile>();
            for (BuildProfile buildProfile : BuildProfile.values()) {
                _buildProfiles.put(buildProfile.toString(), buildProfile);
            }
        }
    }
}

