/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsNode;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class JenkinsMaster
implements JenkinsNode<JenkinsMaster> {
    public static final Integer SLAVE_RAM_DEFAULT = 12;
    public static final Integer SLAVES_PER_HOST_DEFAULT = 2;
    protected static long maxRecentBatchAge = 120000L;
    private static final long _AVAILABLE_TIMEOUT = 300000L;
    private static final Map<String, JenkinsMaster> _jenkinsMasters = Collections.synchronizedMap(new HashMap());
    private static final List<String> _jenkinsMastersBlacklist = new ArrayList<String>();
    private boolean _available;
    private long _availableTimestamp = -1L;
    private final Map<Long, Integer> _batchSizes = new TreeMap<Long, Integer>();
    private boolean _blacklisted;
    private final List<String> _buildURLs = new CopyOnWriteArrayList<String>();
    private final Map<String, JenkinsSlave> _jenkinsSlavesMap = Collections.synchronizedMap(new HashMap());
    private final String _masterName;
    private final String _masterURL;
    private int _queueCount;
    private final Map<String, JSONObject> _queuedBuildURLs = Collections.synchronizedMap(new HashMap());
    private int _reportedAvailableSlavesCount;
    private final Integer _slaveRAM;
    private final Integer _slavesPerHost;

    public static synchronized JenkinsMaster getInstance(String masterName) {
        if (!_jenkinsMasters.containsKey(masterName)) {
            _jenkinsMasters.put(masterName, new JenkinsMaster(masterName));
        }
        return _jenkinsMasters.get(masterName);
    }

    public static Integer getSlaveRAMMinimumDefault() {
        try {
            String propertyValue = JenkinsResultsParserUtil.getBuildProperty("slave.ram.minimum.default");
            if (propertyValue == null) {
                return SLAVE_RAM_DEFAULT;
            }
            return Integer.valueOf(propertyValue);
        }
        catch (Exception exception) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to get property '");
            sb.append("slave.ram.minimum.default");
            sb.append("', defaulting to '");
            sb.append(SLAVE_RAM_DEFAULT);
            sb.append("'");
            System.out.println(sb.toString());
            exception.printStackTrace();
            return SLAVE_RAM_DEFAULT;
        }
    }

    public static Integer getSlavesPerHostDefault() {
        try {
            String propertyValue = JenkinsResultsParserUtil.getBuildProperty("slaves.per.host.default");
            if (propertyValue == null) {
                return SLAVES_PER_HOST_DEFAULT;
            }
            return Integer.valueOf(propertyValue);
        }
        catch (Exception exception) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to get property '");
            sb.append("slaves.per.host.default");
            sb.append("', defaulting to '");
            sb.append(SLAVES_PER_HOST_DEFAULT);
            sb.append("'");
            System.out.println(sb.toString());
            exception.printStackTrace();
            return SLAVES_PER_HOST_DEFAULT;
        }
    }

    public synchronized void addRecentBatch(int batchSize) {
        this._batchSizes.put(JenkinsResultsParserUtil.getCurrentTimeMillis() + maxRecentBatchAge, batchSize);
        this.getAvailableSlavesCount();
    }

    @Override
    public int compareTo(JenkinsMaster jenkinsMaster) {
        int result;
        Integer value = null;
        Integer availableSlavesCount = this.getAvailableSlavesCount();
        Integer otherAvailableSlavesCount = jenkinsMaster.getAvailableSlavesCount();
        if (availableSlavesCount > 0 || otherAvailableSlavesCount > 0) {
            value = availableSlavesCount.compareTo(otherAvailableSlavesCount);
        }
        if (value == null || value == 0) {
            Float averageQueueLength = Float.valueOf(this.getAverageQueueLength());
            Float otherAverageQueueLength = Float.valueOf(jenkinsMaster.getAverageQueueLength());
            value = -1 * averageQueueLength.compareTo(otherAverageQueueLength);
        }
        if (value != 0) {
            return -value.intValue();
        }
        Random random = new Random();
        while ((result = random.nextInt(3) - 1) == 0) {
        }
        return result;
    }

    public int getAvailableSlavesCount() {
        return this.getIdleJenkinsSlavesCount() - this._queueCount - this._getRecentBatchSizesTotal();
    }

    public float getAverageQueueLength() {
        return ((float)this._queueCount + (float)this._getRecentBatchSizesTotal()) / (float)this.getOnlineJenkinsSlavesCount();
    }

    public List<String> getBuildURLs() {
        return new ArrayList<String>(this._buildURLs);
    }

    public int getIdleJenkinsSlavesCount() {
        int idleSlavesCount = 0;
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (jenkinsSlave.isOffline() || !jenkinsSlave.isIdle()) continue;
            ++idleSlavesCount;
        }
        return idleSlavesCount;
    }

    @Override
    public JenkinsMaster getJenkinsMaster() {
        return this;
    }

    public JenkinsSlave getJenkinsSlave(String jenkinsSlaveName) {
        if (this._jenkinsSlavesMap.isEmpty()) {
            this.update();
        }
        return this._jenkinsSlavesMap.get(jenkinsSlaveName);
    }

    public List<String> getJenkinsSlaveNames() {
        List<JenkinsSlave> jenkinsSlaves = this.getJenkinsSlaves();
        ArrayList<String> jenkinsSlaveNames = new ArrayList<String>(jenkinsSlaves.size());
        for (JenkinsSlave jenkinsSlave : jenkinsSlaves) {
            jenkinsSlaveNames.add(jenkinsSlave.getName());
        }
        return jenkinsSlaveNames;
    }

    public List<JenkinsSlave> getJenkinsSlaves() {
        if (this._jenkinsSlavesMap.isEmpty()) {
            this.update();
        }
        return new ArrayList<JenkinsSlave>(this._jenkinsSlavesMap.values());
    }

    @Override
    public String getName() {
        return this._masterName;
    }

    public int getOfflineJenkinsSlavesCount() {
        int offlineJenkinsSlavesCount = 0;
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (!jenkinsSlave.isOffline()) continue;
            ++offlineJenkinsSlavesCount;
        }
        return offlineJenkinsSlavesCount;
    }

    public List<JenkinsSlave> getOnlineJenkinsSlaves() {
        ArrayList<JenkinsSlave> onlineJenkinsSlaves = new ArrayList<JenkinsSlave>();
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (jenkinsSlave.isOffline()) continue;
            onlineJenkinsSlaves.add(jenkinsSlave);
        }
        return onlineJenkinsSlaves;
    }

    public int getOnlineJenkinsSlavesCount() {
        int onlineJenkinsSlavesCount = 0;
        for (JenkinsSlave jenkinsSlave : this._jenkinsSlavesMap.values()) {
            if (jenkinsSlave.isOffline()) continue;
            ++onlineJenkinsSlavesCount;
        }
        return onlineJenkinsSlavesCount;
    }

    public Map<String, JSONObject> getQueuedBuildURLs() {
        return new HashMap<String, JSONObject>(this._queuedBuildURLs);
    }

    public Integer getSlaveRAM() {
        return this._slaveRAM;
    }

    public Integer getSlavesPerHost() {
        return this._slavesPerHost;
    }

    public String getURL() {
        return this._masterURL;
    }

    public boolean isAvailable() {
        if (this._availableTimestamp == -1L || System.currentTimeMillis() - this._availableTimestamp > 300000L) {
            try {
                if (!this.isBlackListed()) {
                    JenkinsResultsParserUtil.toString("http://" + this.getName(), false, 0, 0, 0);
                    this._available = true;
                }
            }
            catch (IOException ioException) {
                System.out.println(this.getName() + " is unreachable.");
                this._available = false;
            }
            finally {
                this._availableTimestamp = System.currentTimeMillis();
            }
        }
        return this._available;
    }

    public boolean isBlackListed() {
        if (_jenkinsMastersBlacklist.contains(this.getName())) {
            this._blacklisted = true;
        }
        return this._blacklisted;
    }

    public boolean isBuildInProgress(String jobName, Map<String, String> buildParameters) {
        try {
            JSONObject jobJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(this.getURL(), "/job/", jobName, "/api/json?", "tree=builds[actions[parameters[name,value]],result,url]"));
            JSONArray buildsJSONArray = jobJSONObject.optJSONArray("builds");
            for (int i = 0; i < buildsJSONArray.length(); ++i) {
                JSONArray actionsJSONArray;
                JSONObject buildJSONObject = buildsJSONArray.optJSONObject(i);
                if (buildJSONObject == JSONObject.NULL || !JenkinsResultsParserUtil.isNullOrEmpty(buildJSONObject.optString("result")) || (actionsJSONArray = buildJSONObject.optJSONArray("actions")) == JSONObject.NULL) continue;
                for (int j = 0; j < actionsJSONArray.length(); ++j) {
                    JSONArray parametersJSONArray;
                    JSONObject actionJSONObject = actionsJSONArray.optJSONObject(j);
                    if (actionJSONObject == JSONObject.NULL || !Objects.equals(actionJSONObject.optString("_class"), "hudson.model.ParametersAction") || (parametersJSONArray = actionJSONObject.optJSONArray("parameters")) == JSONObject.NULL) continue;
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    for (int k = 0; k < parametersJSONArray.length(); ++k) {
                        JSONObject parameterJSONObject = parametersJSONArray.optJSONObject(k);
                        if (parameterJSONObject == JSONObject.NULL) continue;
                        parameters.put(parameterJSONObject.getString("name"), parameterJSONObject.getString("value"));
                    }
                    boolean matchingBuildParameters = true;
                    for (Map.Entry<String, String> buildParameter : buildParameters.entrySet()) {
                        String parameterValue = (String)parameters.get(buildParameter.getKey());
                        if (Objects.equals(buildParameter.getValue(), parameterValue)) continue;
                        matchingBuildParameters = false;
                        break;
                    }
                    if (!matchingBuildParameters) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public boolean isBuildQueued(String jobName, Map<String, String> buildParameters) {
        try {
            JSONObject queueJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(this.getURL(), "/queue/api/json?", "tree=items[actions[parameters[name,value]],task[url]]"));
            JSONArray itemsJSONArray = queueJSONObject.optJSONArray("items");
            for (int i = 0; i < itemsJSONArray.length(); ++i) {
                JSONArray actionsJSONArray;
                JSONObject taskJSONObject;
                String taskURL;
                JSONObject itemJSONObject = itemsJSONArray.optJSONObject(i);
                if (itemJSONObject == JSONObject.NULL || !(taskURL = (taskJSONObject = itemJSONObject.optJSONObject("task")).optString("url", "")).contains("/" + jobName + "/") || (actionsJSONArray = itemJSONObject.optJSONArray("actions")) == JSONObject.NULL) continue;
                for (int j = 0; j < actionsJSONArray.length(); ++j) {
                    JSONArray parametersJSONArray;
                    JSONObject actionJSONObject = actionsJSONArray.optJSONObject(j);
                    if (actionJSONObject == JSONObject.NULL || !Objects.equals(actionJSONObject.optString("_class"), "hudson.model.ParametersAction") || (parametersJSONArray = actionJSONObject.optJSONArray("parameters")) == JSONObject.NULL) continue;
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    for (int k = 0; k < parametersJSONArray.length(); ++k) {
                        JSONObject parameterJSONObject = parametersJSONArray.optJSONObject(k);
                        if (parameterJSONObject == JSONObject.NULL) continue;
                        parameters.put(parameterJSONObject.getString("name"), parameterJSONObject.getString("value"));
                    }
                    boolean matchingBuildParameters = true;
                    for (Map.Entry<String, String> buildParameter : buildParameters.entrySet()) {
                        String parameterValue = (String)parameters.get(buildParameter.getKey());
                        if (Objects.equals(buildParameter.getValue(), parameterValue)) continue;
                        matchingBuildParameters = false;
                        break;
                    }
                    if (!matchingBuildParameters) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public String toString() {
        return JenkinsResultsParserUtil.combine("{availableSlavesCount=", String.valueOf(this.getAvailableSlavesCount()), ", masterURL=", this._masterURL, ", recentBatchSizesTotal=", String.valueOf(this._getRecentBatchSizesTotal()), ", reportedAvailableSlavesCount=", String.valueOf(this._reportedAvailableSlavesCount), "}");
    }

    public synchronized void update() {
        this.update(true);
    }

    public synchronized void update(boolean minimal) {
        if (!this.isAvailable()) {
            this._batchSizes.clear();
            this._buildURLs.clear();
            this._jenkinsSlavesMap.clear();
            this._queueCount = 0;
            this._queuedBuildURLs.clear();
            this._reportedAvailableSlavesCount = 0;
            return;
        }
        JSONObject computerAPIJSONObject = null;
        JSONObject queueAPIJSONObject = null;
        try {
            computerAPIJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(this._masterURL, "/computer/api/json?tree=computer[displayName,", "executors[currentExecutable[url]],idle,offline]")), false, 5000);
            String queueAPIQuery = "tree=items[task[name,url],url,why]";
            if (!minimal) {
                queueAPIQuery = "tree=items[actions[parameters[name,value]],inQueueSince,task[name,url],url,why]";
            }
            queueAPIJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(this._masterURL, "/queue/api/json?" + queueAPIQuery)), false, 5000);
        }
        catch (Exception exception) {
            this._batchSizes.clear();
            this._buildURLs.clear();
            this._jenkinsSlavesMap.clear();
            this._queueCount = 0;
            this._queuedBuildURLs.clear();
            this._reportedAvailableSlavesCount = 0;
            System.out.println("Unable to read " + this._masterURL);
            return;
        }
        ArrayList<String> buildURLs = new ArrayList<String>();
        JSONArray computerJSONArray = computerAPIJSONObject.getJSONArray("computer");
        for (int i = 0; i < computerJSONArray.length(); ++i) {
            JSONObject computerJSONObject = computerJSONArray.getJSONObject(i);
            String jenkinsSlaveName = computerJSONObject.getString("displayName");
            if (jenkinsSlaveName.equals("master")) continue;
            JenkinsSlave jenkinsSlave = this._jenkinsSlavesMap.get(jenkinsSlaveName);
            if (jenkinsSlave != null) {
                jenkinsSlave.update(computerJSONObject);
            } else {
                jenkinsSlave = new JenkinsSlave(this, computerJSONObject);
                this._jenkinsSlavesMap.put(jenkinsSlave.getName(), jenkinsSlave);
            }
            String computerClassName = computerJSONObject.getString("_class");
            if (!computerClassName.contains("hudson.slaves.SlaveComputer")) continue;
            JSONArray executorsJSONArray = computerJSONObject.getJSONArray("executors");
            for (int j = 0; j < executorsJSONArray.length(); ++j) {
                JSONObject currentExecutableJSONObject;
                JSONObject executorJSONObject = executorsJSONArray.getJSONObject(j);
                if (!executorJSONObject.has("currentExecutable") || executorJSONObject.get("currentExecutable") == JSONObject.NULL || !(currentExecutableJSONObject = executorJSONObject.getJSONObject("currentExecutable")).has("url")) continue;
                buildURLs.add(currentExecutableJSONObject.getString("url"));
            }
        }
        this._buildURLs.clear();
        this._buildURLs.addAll(buildURLs);
        this._queueCount = 0;
        if (!queueAPIJSONObject.has("items")) {
            return;
        }
        HashMap<String, JSONObject> queuedBuildURLs = new HashMap<String, JSONObject>();
        JSONArray itemsJSONArray = queueAPIJSONObject.getJSONArray("items");
        for (int i = 0; i < itemsJSONArray.length(); ++i) {
            String taskName;
            JSONObject itemJSONObject = itemsJSONArray.getJSONObject(i);
            JSONObject taskJSONObject = null;
            if (itemJSONObject.has("task")) {
                taskJSONObject = itemJSONObject.getJSONObject("task");
            }
            if (taskJSONObject != null && (taskName = taskJSONObject.getString("name")).equals("verification-node")) continue;
            if (itemJSONObject.has("why")) {
                String why = itemJSONObject.optString("why");
                if (why.startsWith("There are no nodes") || why.contains("already in progress") || why.endsWith("is offline")) continue;
                if (itemJSONObject.has("url")) {
                    queuedBuildURLs.put(this.getURL() + "/" + itemJSONObject.getString("url"), itemJSONObject);
                }
            }
            ++this._queueCount;
        }
        this._queuedBuildURLs.clear();
        this._queuedBuildURLs.putAll(queuedBuildURLs);
    }

    private JenkinsMaster(String masterName) {
        this._masterName = masterName.contains(".") ? masterName.substring(0, masterName.indexOf(".")) : masterName;
        try {
            Properties properties = JenkinsResultsParserUtil.getBuildProperties();
            this._masterURL = properties.getProperty(JenkinsResultsParserUtil.combine("jenkins.local.url[", this._masterName, "]"));
            Integer slaveRAM = JenkinsMaster.getSlaveRAMMinimumDefault();
            String slaveRAMString = JenkinsResultsParserUtil.getProperty(properties, JenkinsResultsParserUtil.combine("master.property(", this._masterName, "/slave.ram)"));
            if (slaveRAMString != null && slaveRAMString.matches("\\d+")) {
                slaveRAM = Integer.valueOf(slaveRAMString);
            }
            this._slaveRAM = slaveRAM;
            Integer slavesPerHost = JenkinsMaster.getSlavesPerHostDefault();
            String slavesPerHostString = JenkinsResultsParserUtil.getProperty(properties, JenkinsResultsParserUtil.combine("master.property(", this._masterName, "/slaves.per.host)"));
            if (slavesPerHostString != null && slavesPerHostString.matches("\\d+")) {
                slavesPerHost = Integer.valueOf(slavesPerHostString);
            }
            this._slavesPerHost = slavesPerHost;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to determine URL for master " + this._masterName, exception);
        }
    }

    private synchronized int _getRecentBatchSizesTotal() {
        long currentTimestamp = JenkinsResultsParserUtil.getCurrentTimeMillis();
        int recentBatchSizesTotal = 0;
        ArrayList<Long> expiredTimestamps = new ArrayList<Long>(this._batchSizes.size());
        for (Map.Entry<Long, Integer> entry : this._batchSizes.entrySet()) {
            Long expirationTimestamp = entry.getKey();
            if (expirationTimestamp < currentTimestamp) {
                expiredTimestamps.add(expirationTimestamp);
                continue;
            }
            recentBatchSizesTotal += entry.getValue().intValue();
        }
        for (Long expiredTimestamp : expiredTimestamps) {
            this._batchSizes.remove(expiredTimestamp);
        }
        return recentBatchSizesTotal;
    }

    static {
        try {
            String jenkinsMastersBlacklist = JenkinsResultsParserUtil.getBuildProperty("jenkins.load.balancer.blacklist");
            Collections.addAll(_jenkinsMastersBlacklist, jenkinsMastersBlacklist.split(","));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

