/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.CISystemStatusReportUtil;
import com.liferay.jenkins.results.parser.JenkinsAPIUtil;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.PullRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JenkinsCohort {
    private static final Pattern _buildNumberPattern = Pattern.compile(".*\\/([0-9]+)");
    private static final Pattern _jobNamePattern = Pattern.compile("https?:.*job\\/(.*?)\\/");
    private final Map<String, JenkinsCohortJob> _jenkinsCohortJobsMap = new HashMap<String, JenkinsCohortJob>();
    private final Map<String, JenkinsMaster> _jenkinsMastersMap = new HashMap<String, JenkinsMaster>();
    private final String _name;

    public JenkinsCohort(String name) {
        this._name = name;
        this.update();
    }

    public int getIdleJenkinsSlaveCount() {
        int idleJenkinsSlaveCount = 0;
        for (JenkinsMaster jenkinsMaster : this._jenkinsMastersMap.values()) {
            idleJenkinsSlaveCount += jenkinsMaster.getIdleJenkinsSlavesCount();
        }
        return idleJenkinsSlaveCount;
    }

    public String getName() {
        return this._name;
    }

    public int getOfflineJenkinsSlaveCount() {
        int offlineJenkinsSlaveCount = 0;
        for (JenkinsMaster jenkinsMaster : this._jenkinsMastersMap.values()) {
            offlineJenkinsSlaveCount += jenkinsMaster.getOfflineJenkinsSlavesCount();
        }
        return offlineJenkinsSlaveCount;
    }

    public int getOnlineJenkinsSlaveCount() {
        int onlineJenkinsSlaveCount = 0;
        for (JenkinsMaster jenkinsMaster : this._jenkinsMastersMap.values()) {
            onlineJenkinsSlaveCount += jenkinsMaster.getOnlineJenkinsSlavesCount();
        }
        return onlineJenkinsSlaveCount;
    }

    public int getQueuedBuildCount() {
        int queuedBuildCount = 0;
        for (JenkinsCohortJob jenkinsCohortJob : this._jenkinsCohortJobsMap.values()) {
            queuedBuildCount += jenkinsCohortJob.getQueuedBuildCount();
        }
        return queuedBuildCount;
    }

    public int getRunningBuildCount() {
        int runningBuildCount = 0;
        for (JenkinsCohortJob jenkinsCohortJob : this._jenkinsCohortJobsMap.values()) {
            runningBuildCount += jenkinsCohortJob.getRunningBuildCount();
        }
        return runningBuildCount;
    }

    public void update() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get Jenkins properties", ioException);
        }
        if (this._jenkinsMastersMap.isEmpty()) {
            List<JenkinsMaster> jenkinsMasters = JenkinsResultsParserUtil.getJenkinsMasters(buildProperties, JenkinsMaster.getSlaveRAMMinimumDefault(), JenkinsMaster.getSlavesPerHostDefault(), this.getName());
            for (JenkinsMaster jenkinsMaster : jenkinsMasters) {
                this._jenkinsMastersMap.put(jenkinsMaster.getName(), jenkinsMaster);
            }
        }
        ArrayList callables = new ArrayList();
        final List<String> buildURLs = Collections.synchronizedList(new ArrayList());
        final Map queuedBuildURLs = Collections.synchronizedMap(new HashMap());
        for (final JenkinsMaster jenkinsMaster : this._jenkinsMastersMap.values()) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() {
                    jenkinsMaster.update(false);
                    buildURLs.addAll(jenkinsMaster.getBuildURLs());
                    queuedBuildURLs.putAll(jenkinsMaster.getQueuedBuildURLs());
                    return null;
                }
            };
            callables.add(callable);
        }
        ThreadPoolExecutor threadPoolExecutor = JenkinsResultsParserUtil.getNewThreadPoolExecutor(this._jenkinsMastersMap.size(), true);
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, threadPoolExecutor);
        parallelExecutor.execute();
        for (String string : buildURLs) {
            this._loadBuildURL(string);
        }
        for (Map.Entry entry : queuedBuildURLs.entrySet()) {
            this._loadQueuedBuildURL(entry);
        }
    }

    public void writeDataJavaScriptFile(String filePath) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("var jenkinsDataGeneratedDate = new Date(");
        sb.append(JenkinsResultsParserUtil.getCurrentTimeMillis());
        sb.append(");\nvar nodeData = ");
        JSONArray nodeDataTableJSONArray = new JSONArray();
        nodeDataTableJSONArray.put(Arrays.asList("Occupied Nodes", "Online Nodes", "Queued Builds", "Offline Nodes", "Idle Nodes"));
        nodeDataTableJSONArray.put(Arrays.asList(this.getRunningBuildCount(), this.getOnlineJenkinsSlaveCount(), this.getQueuedBuildCount(), this.getOfflineJenkinsSlaveCount(), this.getIdleJenkinsSlaveCount()));
        sb.append(nodeDataTableJSONArray.toString());
        sb.append(";\nvar buildLoadData = ");
        JSONArray buildLoadDataTableJSONArray = new JSONArray();
        buildLoadDataTableJSONArray.put(Arrays.asList("Name", "Total Builds", "Current Builds", "Queued Builds", "Top Level Builds"));
        for (JenkinsCohortJob jenkinsCohortJob : this._jenkinsCohortJobsMap.values()) {
            buildLoadDataTableJSONArray.put(Arrays.asList(jenkinsCohortJob.getJobName(), this._createJSONArray(jenkinsCohortJob.getTotalBuildCount(), this._formatBuildCountText(jenkinsCohortJob.getTotalBuildCount(), jenkinsCohortJob.getTotalBuildPercentage())), this._createJSONArray(jenkinsCohortJob.getRunningBuildCount(), this._formatBuildCountText(jenkinsCohortJob.getRunningBuildCount(), jenkinsCohortJob.getRunningBuildPercentage())), this._createJSONArray(jenkinsCohortJob.getQueuedBuildCount(), this._formatBuildCountText(jenkinsCohortJob.getQueuedBuildCount(), jenkinsCohortJob.getQueuedBuildPercentage())), jenkinsCohortJob.getTopLevelBuildCount()));
        }
        sb.append(buildLoadDataTableJSONArray.toString());
        sb.append(";\nvar pullRequestData = ");
        JSONArray pullRequestDataTableJSONArray = new JSONArray();
        pullRequestDataTableJSONArray.put(Arrays.asList("Pull Request URL", "Sender Username", "Branch Name", "Test Suite", "Status", "Queued Duration", "Duration"));
        for (JenkinsCohortJob jenkinsCohortJob : this._jenkinsCohortJobsMap.values()) {
            String jobName = jenkinsCohortJob.getJobName();
            if (!jobName.contains("test-portal-acceptance-pullrequest")) continue;
            for (String buildURL : jenkinsCohortJob.getTopLevelBuildURLs()) {
                JSONObject jsonObject = JenkinsAPIUtil.getAPIJSONObject(buildURL);
                long queuedDuration = 0L;
                JSONArray actionsJSONArray = jsonObject.getJSONArray("actions");
                for (int i = 0; i < actionsJSONArray.length(); ++i) {
                    String clazz;
                    JSONObject actionJSONObject;
                    Object actions = actionsJSONArray.get(i);
                    if (actions == JSONObject.NULL || !(actionJSONObject = actionsJSONArray.getJSONObject(i)).has("_class") || !(clazz = actionJSONObject.getString("_class")).equals("jenkins.metrics.impl.TimeInQueueAction")) continue;
                    queuedDuration = actionJSONObject.getLong("buildableDurationMillis");
                    break;
                }
                long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - jsonObject.getLong("timestamp");
                pullRequestDataTableJSONArray.put(this._createpullRequestDataTableRow(buildURL, JenkinsAPIUtil.getBuildParameters(jsonObject), queuedDuration, duration));
            }
            Map<String, JSONObject> queuedTopLevelBuildsJsonMap = jenkinsCohortJob.getQueuedTopLevelBuildsJsonMap();
            for (JSONObject jsonObject : queuedTopLevelBuildsJsonMap.values()) {
                try {
                    Map<String, String> buildParameters = JenkinsAPIUtil.getBuildParameters(jsonObject);
                    JSONObject taskJSONObject = jsonObject.getJSONObject("task");
                    String jobURL = taskJSONObject.getString("url");
                    long queueDuration = JenkinsResultsParserUtil.getCurrentTimeMillis() - jsonObject.optLong("inQueueSince");
                    pullRequestDataTableJSONArray.put(this._createpullRequestDataTableRow(jobURL, buildParameters, queueDuration, 0L));
                }
                catch (JSONException jsonException) {
                    System.out.println(jsonObject.toString());
                    throw new RuntimeException(jsonException);
                }
            }
        }
        sb.append(pullRequestDataTableJSONArray.toString());
        sb.append(";");
        JenkinsResultsParserUtil.write(filePath, sb.toString());
    }

    private JSONArray _createJSONArray(Object ... items) {
        JSONArray jsonArray = new JSONArray();
        for (Object item : items) {
            jsonArray.put(item);
        }
        return jsonArray;
    }

    private List<Object> _createpullRequestDataTableRow(String buildURL, Map<String, String> buildParameters, long queueDuration, long duration) {
        String githubReceiverUsername = buildParameters.get("GITHUB_RECEIVER_USERNAME");
        String repositoryName = "liferay-portal";
        String githubUpstreamBranchName = buildParameters.get("GITHUB_UPSTREAM_BRANCH_NAME");
        if (githubUpstreamBranchName != null && !githubUpstreamBranchName.equals("master")) {
            repositoryName = repositoryName + "-ee";
        }
        String githubPullRequestNumber = buildParameters.get("GITHUB_PULL_REQUEST_NUMBER");
        String githubSenderUsername = buildParameters.get("GITHUB_SENDER_USERNAME");
        String ciTestSuite = buildParameters.get("CI_TEST_SUITE");
        Matcher matcher = _buildNumberPattern.matcher(buildURL);
        String status = "Queued";
        if (matcher.find()) {
            status = "Running";
        }
        return Arrays.asList(this._createJSONArray(JenkinsResultsParserUtil.combine(repositoryName, "/", githubReceiverUsername, "#", githubPullRequestNumber), PullRequest.getURL(githubReceiverUsername, repositoryName, githubPullRequestNumber)), githubSenderUsername, githubUpstreamBranchName, ciTestSuite, this._createJSONArray(status, buildURL), this._createJSONArray(queueDuration, JenkinsResultsParserUtil.toDurationString(queueDuration)), this._createJSONArray(duration, JenkinsResultsParserUtil.toDurationString(duration)));
    }

    private String _formatBuildCountText(int buildCount, String buildPercentage) {
        return buildCount + " (" + buildPercentage + ")";
    }

    private void _loadBuildURL(String buildURL) {
        Matcher jobNameMatcher = _jobNamePattern.matcher(buildURL);
        jobNameMatcher.find();
        String jobName = jobNameMatcher.group(1);
        String downstreamJobName = null;
        if (jobName.contains("-batch")) {
            downstreamJobName = jobName;
            jobName = jobName.replace("-batch", "");
        }
        if (jobName.contains("-downstream")) {
            downstreamJobName = jobName;
            jobName = jobName.replace("-downstream", "");
        }
        if (!this._jenkinsCohortJobsMap.containsKey(jobName)) {
            this._jenkinsCohortJobsMap.put(jobName, new JenkinsCohortJob(jobName));
        }
        JenkinsCohortJob jenkinsCohortJob = this._jenkinsCohortJobsMap.get(jobName);
        if (downstreamJobName == null) {
            jenkinsCohortJob.addTopLevelBuildURL(buildURL);
        } else {
            jenkinsCohortJob.addOtherBuildURL(buildURL);
        }
    }

    private void _loadQueuedBuildURL(Map.Entry<String, JSONObject> queuedBuildURL) {
        JSONObject taskJSONObject;
        JSONObject jsonObject = queuedBuildURL.getValue();
        if (jsonObject.has("task") && (taskJSONObject = jsonObject.getJSONObject("task")).has("url")) {
            Matcher jobNameMatcher = _jobNamePattern.matcher(taskJSONObject.getString("url"));
            jobNameMatcher.find();
            String jobName = jobNameMatcher.group(1);
            String downstreamJobName = null;
            if (jobName.contains("-batch")) {
                downstreamJobName = jobName;
                jobName = jobName.replace("-batch", "");
            }
            if (jobName.contains("-downstream")) {
                downstreamJobName = jobName;
                jobName = jobName.replace("-downstream", "");
            }
            if (!this._jenkinsCohortJobsMap.containsKey(jobName)) {
                this._jenkinsCohortJobsMap.put(jobName, new JenkinsCohortJob(jobName));
            }
            JenkinsCohortJob jenkinsCohortJob = this._jenkinsCohortJobsMap.get(jobName);
            if (downstreamJobName == null) {
                jenkinsCohortJob.addQueuedTopLevelBuildJsonMapEntry(queuedBuildURL);
            } else {
                jenkinsCohortJob.addQueuedOtherBuildJsonMapEntry(queuedBuildURL);
            }
        }
    }

    private class JenkinsCohortJob {
        private final String _jenkinsCohortJobName;
        private List<String> _otherBuildURLs = new ArrayList<String>();
        private Map<String, JSONObject> _queuedOtherBuildsJsonMap = new HashMap<String, JSONObject>();
        private Map<String, JSONObject> _queuedTopLevelBuildsJsonMap = new HashMap<String, JSONObject>();
        private List<String> _topLevelBuildURLs = new ArrayList<String>();

        public JenkinsCohortJob(String jenkinsCohortJobName) {
            this._jenkinsCohortJobName = jenkinsCohortJobName;
        }

        public void addOtherBuildURL(String buildURL) {
            this._otherBuildURLs.add(buildURL);
        }

        public void addQueuedOtherBuildJsonMapEntry(Map.Entry<String, JSONObject> queuedBuildsJsonMapEntry) {
            this._queuedOtherBuildsJsonMap.put(queuedBuildsJsonMapEntry.getKey(), queuedBuildsJsonMapEntry.getValue());
        }

        public void addQueuedTopLevelBuildJsonMapEntry(Map.Entry<String, JSONObject> queuedTopLevelBuildMapEntry) {
            this._queuedTopLevelBuildsJsonMap.put(queuedTopLevelBuildMapEntry.getKey(), queuedTopLevelBuildMapEntry.getValue());
        }

        public void addTopLevelBuildURL(String topLevelBuildURL) {
            this._topLevelBuildURLs.add(topLevelBuildURL);
        }

        public String getJobName() {
            return this._jenkinsCohortJobName;
        }

        public int getQueuedBuildCount() {
            return this._queuedTopLevelBuildsJsonMap.size() + this._queuedOtherBuildsJsonMap.size();
        }

        public String getQueuedBuildPercentage() {
            return CISystemStatusReportUtil.getPercentage(this.getQueuedBuildCount(), JenkinsCohort.this.getQueuedBuildCount());
        }

        public Map<String, JSONObject> getQueuedTopLevelBuildsJsonMap() {
            return this._queuedTopLevelBuildsJsonMap;
        }

        public int getRunningBuildCount() {
            return this._topLevelBuildURLs.size() + this._otherBuildURLs.size();
        }

        public String getRunningBuildPercentage() {
            return CISystemStatusReportUtil.getPercentage(this.getRunningBuildCount(), JenkinsCohort.this.getRunningBuildCount());
        }

        public int getTopLevelBuildCount() {
            return this._topLevelBuildURLs.size() + this._queuedTopLevelBuildsJsonMap.size();
        }

        public List<String> getTopLevelBuildURLs() {
            return this._topLevelBuildURLs;
        }

        public int getTotalBuildCount() {
            return this.getQueuedBuildCount() + this.getRunningBuildCount();
        }

        public String getTotalBuildPercentage() {
            return CISystemStatusReportUtil.getPercentage(this.getTotalBuildCount(), JenkinsCohort.this.getRunningBuildCount() + JenkinsCohort.this.getQueuedBuildCount());
        }
    }
}

