/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.QAWebsitesGitWorkingDirectory;
import com.liferay.jenkins.results.parser.SubrepositoryGitWorkingDirectory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GitWorkingDirectoryFactory {
    private static final Map<String, GitWorkingDirectory> _gitWorkingDirectories = new HashMap<String, GitWorkingDirectory>();

    public static GitWorkingDirectory newGitWorkingDirectory(String upstreamBranchName, File gitRepositoryDir, String gitRepositoryName) {
        if (gitRepositoryDir == null && gitRepositoryName == null) {
            throw new IllegalArgumentException("Git repository directory and Git repository name are null");
        }
        String gitRepositoryDirName = gitRepositoryName;
        if (gitRepositoryDir == null) {
            if (gitRepositoryName.equals("liferay-portal") && !upstreamBranchName.equals("master")) {
                gitRepositoryName = gitRepositoryName + "-ee";
                gitRepositoryDirName = "liferay-portal-" + upstreamBranchName;
            }
            if (gitRepositoryName.startsWith("com-liferay-") && !gitRepositoryName.endsWith("-private")) {
                gitRepositoryDirName = gitRepositoryName + "-private";
            }
            gitRepositoryDir = new File(JenkinsResultsParserUtil.getBaseGitRepositoryDir(), gitRepositoryDirName);
        }
        if (gitRepositoryName == null) {
            gitRepositoryName = gitRepositoryDir.getName();
        }
        if (!gitRepositoryDir.exists()) {
            throw new RuntimeException("Directory path not found " + gitRepositoryDir);
        }
        try {
            String gitRepositoryDirPath = JenkinsResultsParserUtil.getCanonicalPath(gitRepositoryDir);
            String key = JenkinsResultsParserUtil.combine(gitRepositoryDirPath, "-", upstreamBranchName);
            if (_gitWorkingDirectories.containsKey(key)) {
                return _gitWorkingDirectories.get(key);
            }
            GitWorkingDirectory gitWorkingDirectory = null;
            gitWorkingDirectory = gitRepositoryName.startsWith("com-liferay-") || gitRepositoryDirPath.matches(".*/com-liferay-[^/]*") ? new SubrepositoryGitWorkingDirectory(upstreamBranchName, gitRepositoryDirPath, gitRepositoryName) : (gitRepositoryName.startsWith("liferay-plugins") || gitRepositoryDirPath.matches(".*/liferay-plugins[^/]*") ? new PluginsGitWorkingDirectory(upstreamBranchName, gitRepositoryDirPath, gitRepositoryName) : (gitRepositoryName.startsWith("liferay-portal") || gitRepositoryDirPath.matches(".*/liferay-portal[^/]*") ? new PortalGitWorkingDirectory(upstreamBranchName, gitRepositoryDirPath, gitRepositoryName) : (gitRepositoryName.equals("liferay-qa-websites-ee") || gitRepositoryDirPath.matches(".*/liferay-qa-websites-ee") ? new QAWebsitesGitWorkingDirectory(upstreamBranchName, gitRepositoryDirPath, gitRepositoryName) : new GitWorkingDirectory(upstreamBranchName, gitRepositoryDirPath, gitRepositoryName))));
            _gitWorkingDirectories.put(key, gitWorkingDirectory);
            return gitWorkingDirectory;
        }
        catch (IOException ioException) {
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to create Git working directory for directory ", gitRepositoryDir.getPath()), ioException);
        }
    }

    public static GitWorkingDirectory newGitWorkingDirectory(String upstreamBranchName, String gitepositoryDirPath) {
        return GitWorkingDirectoryFactory.newGitWorkingDirectory(upstreamBranchName, new File(gitepositoryDirPath), null);
    }

    public static GitWorkingDirectory newGitWorkingDirectory(String upstreamBranchName, String gitRepositoryDirPath, String gitRepositoryName) {
        if (gitRepositoryDirPath == null) {
            return GitWorkingDirectoryFactory.newGitWorkingDirectory(upstreamBranchName, (File)null, gitRepositoryName);
        }
        return GitWorkingDirectoryFactory.newGitWorkingDirectory(upstreamBranchName, new File(gitRepositoryDirPath), gitRepositoryName);
    }

    public static GitWorkingDirectory newJenkinsGitWorkingDirectory() {
        return GitWorkingDirectoryFactory.newGitWorkingDirectory("master", new File(JenkinsResultsParserUtil.getBaseGitRepositoryDir(), "liferay-jenkins-ee"), "liferay-jenkins-ee");
    }

    public static PortalGitWorkingDirectory newPortalGitWorkingDirectory(String upstreamBranchName) {
        return (PortalGitWorkingDirectory)GitWorkingDirectoryFactory.newGitWorkingDirectory(upstreamBranchName, (File)null, "liferay-portal");
    }

    public static SubrepositoryGitWorkingDirectory newSubrepositoryGitWorkingDirectory(String upstreamBranchName, String gitRepositoryName) {
        return (SubrepositoryGitWorkingDirectory)GitWorkingDirectoryFactory.newGitWorkingDirectory(upstreamBranchName, (File)null, gitRepositoryName);
    }
}

