/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.LocalGitBranch;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public abstract class GitRepositoryJob
extends BaseJob {
    protected File gitRepositoryDir;
    protected GitWorkingDirectory gitWorkingDirectory;
    private static final Pattern _jobNamePattern = Pattern.compile("[^\\(]+\\((?<upstreamBranchName>[^\\)]+)\\)");
    private final String _upstreamBranchName;

    public String getBranchName() {
        return this.getUpstreamBranchName();
    }

    public GitWorkingDirectory getGitWorkingDirectory() {
        if (this.gitWorkingDirectory != null) {
            return this.gitWorkingDirectory;
        }
        this.checkGitRepositoryDir();
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this.getBranchName(), JenkinsResultsParserUtil.getCanonicalPath(this.gitRepositoryDir));
        return this.gitWorkingDirectory;
    }

    @Override
    public List<String> getJobPropertyOptions() {
        List<String> jobPropertyOptions = super.getJobPropertyOptions();
        jobPropertyOptions.add(this.getBranchName());
        jobPropertyOptions.removeAll(Collections.singleton(null));
        return jobPropertyOptions;
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("branch", (Object)this._getBranchJSONObject());
        this.jsonObject.put("git_repository_dir", (Object)this.gitRepositoryDir);
        this.jsonObject.put("upstream_branch_name", (Object)this._upstreamBranchName);
        return this.jsonObject;
    }

    public String getRepositoryName() {
        String gitRepositoryDirPath = JenkinsResultsParserUtil.getCanonicalPath(this.gitRepositoryDir);
        return JenkinsResultsParserUtil.getGitRepositoryName(gitRepositoryDirPath.replaceAll(".*/([^/]+)", "$1"));
    }

    public String getUpstreamBranchName() {
        return this._upstreamBranchName;
    }

    public void setGitRepositoryDir(File gitRepositoryDir) {
        this.gitRepositoryDir = gitRepositoryDir;
    }

    protected GitRepositoryJob(Job.BuildProfile buildProfile, String jobName) {
        this(buildProfile, jobName, null);
    }

    protected GitRepositoryJob(Job.BuildProfile buildProfile, String jobName, String upstreamBranchName) {
        super(buildProfile, jobName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(upstreamBranchName)) {
            upstreamBranchName = "master";
            Matcher matcher = _jobNamePattern.matcher(this.getJobName());
            if (matcher.find()) {
                upstreamBranchName = matcher.group("upstreamBranchName");
            }
        }
        this._upstreamBranchName = upstreamBranchName;
    }

    protected GitRepositoryJob(JSONObject jsonObject) {
        super(jsonObject);
        this.gitRepositoryDir = new File(jsonObject.getString("git_repository_dir"));
        this._upstreamBranchName = jsonObject.getString("upstream_branch_name");
    }

    protected void checkGitRepositoryDir() {
        if (this.gitRepositoryDir == null) {
            throw new IllegalStateException("Repository directory is not set");
        }
        if (!this.gitRepositoryDir.exists()) {
            throw new IllegalStateException(this.gitRepositoryDir.getPath() + " does not exist");
        }
    }

    private JSONObject _getBranchJSONObject() {
        if (this.jsonObject != null && this.jsonObject.has("branch")) {
            return this.jsonObject.getJSONObject("branch");
        }
        JSONObject branchJSONObject = new JSONObject();
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        LocalGitBranch currentLocalGitBranch = gitWorkingDirectory.getCurrentLocalGitBranch();
        branchJSONObject.put("current_branch_name", (Object)currentLocalGitBranch.getName());
        branchJSONObject.put("current_branch_sha", (Object)currentLocalGitBranch.getSHA());
        LocalGitBranch upstreamLocalGitBranch = gitWorkingDirectory.getUpstreamLocalGitBranch();
        branchJSONObject.put("upstream_branch_name", (Object)upstreamLocalGitBranch.getName());
        branchJSONObject.put("upstream_branch_sha", (Object)upstreamLocalGitBranch.getSHA());
        branchJSONObject.put("merge_branch_sha", (Object)gitWorkingDirectory.getMergeBaseCommitSHA(currentLocalGitBranch, upstreamLocalGitBranch));
        File workingDirectory = gitWorkingDirectory.getWorkingDirectory();
        ArrayList<String> modifiedFiles = new ArrayList<String>();
        for (File modifiedFile : gitWorkingDirectory.getModifiedFilesList()) {
            modifiedFiles.add(JenkinsResultsParserUtil.getPathRelativeTo(modifiedFile, workingDirectory));
        }
        branchJSONObject.put("modified_files", modifiedFiles);
        if (gitWorkingDirectory instanceof PortalGitWorkingDirectory) {
            PortalGitWorkingDirectory portalGitWorkingDirectory = (PortalGitWorkingDirectory)gitWorkingDirectory;
            ArrayList<String> modifiedModuleDirs = new ArrayList<String>();
            try {
                for (File modifiedModuleDir : portalGitWorkingDirectory.getModifiedModuleDirsList()) {
                    modifiedModuleDirs.add(JenkinsResultsParserUtil.getPathRelativeTo(modifiedModuleDir, workingDirectory));
                }
                branchJSONObject.put("modified_modules", modifiedModuleDirs);
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        return branchJSONObject;
    }
}

