/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseDownstreamBuildReport;
import com.liferay.jenkins.results.parser.StopWatchRecord;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TopLevelBuildReport;
import org.json.JSONObject;

public class FunctionalDownstreamBuildReport
extends BaseDownstreamBuildReport {
    @Override
    public long getTestExecutionDuration() {
        long testExecutionDuration = this._getStopWatchRecordTestExecutionDuration();
        if (testExecutionDuration <= 0L) {
            return super.getTestExecutionDuration();
        }
        if ((testExecutionDuration -= this._getStopWatchRecordAppServerDuration()) <= 0L) {
            return super.getTestExecutionDuration();
        }
        return testExecutionDuration;
    }

    protected FunctionalDownstreamBuildReport(String batchName, JSONObject buildReportJSONObject, TopLevelBuildReport topLevelBuildReport) {
        super(batchName, buildReportJSONObject, topLevelBuildReport);
    }

    private long _getStopWatchRecordAppServerDuration() {
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup == null) {
            return 0L;
        }
        long appServerDuration = 0L;
        for (int i = 0; i < 5; ++i) {
            StopWatchRecord stopAppServerStopWatchRecord;
            StopWatchRecord startAppServerStopWatchRecord = stopWatchRecordsGroup.get("start.app.server." + i);
            if (startAppServerStopWatchRecord != null) {
                appServerDuration += startAppServerStopWatchRecord.getDuration().longValue();
            }
            if ((stopAppServerStopWatchRecord = stopWatchRecordsGroup.get("stop.app.server." + i)) == null) continue;
            appServerDuration += stopAppServerStopWatchRecord.getDuration().longValue();
        }
        return appServerDuration;
    }

    private long _getStopWatchRecordTestExecutionDuration() {
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup == null) {
            return 0L;
        }
        StopWatchRecord stopWatchRecord = stopWatchRecordsGroup.get("test.execution.duration");
        if (stopWatchRecord == null) {
            return 0L;
        }
        return stopWatchRecord.getDuration();
    }
}

