/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseTopLevelBuildReport;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class FileTopLevelBuildReport
extends BaseTopLevelBuildReport {
    private static final Pattern _jenkinsConsoleFilePattern = Pattern.compile(JenkinsResultsParserUtil.combine("/mnt/mfs-hdd1-10.0.10/jenkins/testray-results/production/logs/", "(?<startYearMonth>\\d{4}-\\d{2})/", "(?<masterHostname>test-\\d+-\\d+)/(?<jobName>[^/]+)/", "(?<buildNumber>\\d+)/jenkins-console.txt.gz"));
    private final File _jenkinsConsoleFile;
    private File _jenkinsConsoleLocalFile;

    public static FileTopLevelBuildReport getInstance(File jenkinsConsoleFile) {
        if (jenkinsConsoleFile == null || !jenkinsConsoleFile.exists()) {
            return null;
        }
        return new FileTopLevelBuildReport(jenkinsConsoleFile);
    }

    @Override
    public JSONObject getBuildReportJSONObject() {
        if (this.buildReportJSONObject != null) {
            return this.buildReportJSONObject;
        }
        File parentFile = this._jenkinsConsoleFile.getParentFile();
        this.buildReportJSONObject = this._getJSONObjectFromFile(new File(parentFile, "build-report.json.gz"));
        if (this.buildReportJSONObject == null) {
            this.buildReportJSONObject = this.getBuildReportJSONObject(this._getJSONObjectFromFile(new File(parentFile, "build-result.json.gz")));
        }
        return this.buildReportJSONObject;
    }

    protected FileTopLevelBuildReport(File jenkinsConsoleFile) {
        super(FileTopLevelBuildReport._getBuildURL(jenkinsConsoleFile));
        if (!jenkinsConsoleFile.exists()) {
            throw new RuntimeException("Invalid file " + jenkinsConsoleFile);
        }
        this._jenkinsConsoleFile = jenkinsConsoleFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File getJenkinsConsoleLocalFile() {
        if (this._jenkinsConsoleLocalFile != null) {
            return this._jenkinsConsoleLocalFile;
        }
        if (this._jenkinsConsoleFile == null || !this._jenkinsConsoleFile.exists()) {
            return null;
        }
        String timeStamp = JenkinsResultsParserUtil.getDistinctTimeStamp();
        File jenkinsConsoleLocalFile = new File(System.getenv("WORKSPACE"), timeStamp);
        File jenkinsConsoleLocalGzipFile = new File(System.getenv("WORKSPACE"), timeStamp + ".gz");
        try {
            JenkinsResultsParserUtil.copy(this._jenkinsConsoleFile, jenkinsConsoleLocalGzipFile);
            JenkinsResultsParserUtil.unGzip(jenkinsConsoleLocalGzipFile, jenkinsConsoleLocalFile);
            File file = this._jenkinsConsoleLocalFile = jenkinsConsoleLocalFile;
            return file;
        }
        catch (Exception exception) {
            File file = null;
            return file;
        }
        finally {
            if (jenkinsConsoleLocalGzipFile.exists()) {
                JenkinsResultsParserUtil.delete(jenkinsConsoleLocalGzipFile);
            }
        }
    }

    @Override
    protected String getStartYearMonth() {
        Matcher matcher = _jenkinsConsoleFilePattern.matcher(JenkinsResultsParserUtil.getCanonicalPath(this._jenkinsConsoleFile));
        if (!matcher.find()) {
            throw new RuntimeException("Invalid file " + this._jenkinsConsoleFile);
        }
        return matcher.group("startYearMonth");
    }

    private static URL _getBuildURL(File jenkinsConsoleFile) {
        if (!jenkinsConsoleFile.exists()) {
            throw new RuntimeException("Invalid file " + jenkinsConsoleFile);
        }
        Matcher matcher = _jenkinsConsoleFilePattern.matcher(JenkinsResultsParserUtil.getCanonicalPath(jenkinsConsoleFile));
        if (!matcher.find()) {
            throw new RuntimeException("Invalid file " + jenkinsConsoleFile);
        }
        try {
            return new URL(JenkinsResultsParserUtil.combine("https://", matcher.group("masterHostname"), ".liferay.com/job/", matcher.group("jobName"), "/", matcher.group("buildNumber")));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private JSONObject _getJSONObjectFromFile(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            String fileContent = JenkinsResultsParserUtil.read(file);
            if (JenkinsResultsParserUtil.isNullOrEmpty(fileContent)) {
                return null;
            }
            return new JSONObject(fileContent);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

