/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.StopWatchRecord;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.failure.message.generator.CIFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.CompileFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GenericFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GradleTaskFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.IntegrationTestTimeoutFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.LocalGitMirrorFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.ModulesCompilationFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PMDFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PluginFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.PluginGitIDFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.SemanticVersioningFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.ServiceBuilderFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.SourceFormatFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.StartupFailureMessageGenerator;
import com.liferay.jenkins.results.parser.test.clazz.FunctionalTestClass;
import com.liferay.jenkins.results.parser.test.clazz.JUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class DownstreamBuild
extends BaseBuild {
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new ModulesCompilationFailureMessageGenerator(), new CompileFailureMessageGenerator(), new IntegrationTestTimeoutFailureMessageGenerator(), new LocalGitMirrorFailureMessageGenerator(), new PMDFailureMessageGenerator(), new PluginFailureMessageGenerator(), new PluginGitIDFailureMessageGenerator(), new SemanticVersioningFailureMessageGenerator(), new ServiceBuilderFailureMessageGenerator(), new SourceFormatFailureMessageGenerator(), new StartupFailureMessageGenerator(), new GradleTaskFailureMessageGenerator(), new CIFailureMessageGenerator(), new GenericFailureMessageGenerator()};

    @Override
    public void addTimelineData(BaseBuild.TimelineData timelineData) {
        timelineData.addTimelineData(this);
    }

    @Override
    public void findDownstreamBuilds() {
    }

    @Override
    public URL getArtifactsBaseURL() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        StringBuilder sb = new StringBuilder();
        sb.append(topLevelBuild.getArtifactsBaseURL());
        sb.append("/");
        sb.append(this.getJobVariant());
        sb.append("/");
        sb.append(this.getAxisVariable());
        try {
            return new URL(sb.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public long getAverageDuration() {
        AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
        return axisTestClassGroup.getAverageDuration();
    }

    public long getAverageOverheadDuration() {
        AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
        BatchTestClassGroup batchTestClassGroup = axisTestClassGroup.getBatchTestClassGroup();
        return batchTestClassGroup.getAverageOverheadDuration();
    }

    public String getAxisName() {
        return JenkinsResultsParserUtil.combine(this.getJobVariant(), "/", this.getAxisVariable());
    }

    public AxisTestClassGroup getAxisTestClassGroup() {
        Job job = this.getJob();
        return job.getAxisTestClassGroup(this.getAxisName());
    }

    public String getAxisVariable() {
        return this.getParameterValue("AXIS_VARIABLE");
    }

    @Override
    public String getBaseGitRepositoryName() {
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this.gitRepositoryName)) {
            return this.gitRepositoryName;
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        this.gitRepositoryName = topLevelBuild.getParameterValue("REPOSITORY_NAME");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(this.gitRepositoryName)) {
            return this.gitRepositoryName;
        }
        String branchName = this.getBranchName();
        this.gitRepositoryName = "liferay-portal-ee";
        if (branchName.equals("master")) {
            this.gitRepositoryName = "liferay-portal";
        }
        return this.gitRepositoryName;
    }

    public String getBatchName() {
        String jobVariant = this.getJobVariant();
        return jobVariant.replaceAll("([^/]+)/.*", "$1");
    }

    @Override
    public String getDisplayName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJobVariant());
        sb.append("/");
        sb.append(this.getAxisVariable());
        return sb.toString();
    }

    @Override
    public Element getGitHubMessageElement() {
        Element failureMessageElement;
        String status = this.getStatus();
        if (!status.equals("completed") && this.getParentBuild() != null) {
            return null;
        }
        String result = this.getResult();
        if (result.equals("SUCCESS")) {
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "/consoleText", null, this.getDisplayName()));
        if (result.equals("ABORTED")) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build was aborted"));
        }
        if (result.equals("FAILURE") && (failureMessageElement = this.getFailureMessageElement()) != null) {
            messageElement.add(failureMessageElement);
        }
        if (result.equals("MISSING")) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build is missing"));
        }
        if (result.equals("UNSTABLE")) {
            List<Element> failureElements = this.getTestResultGitHubElements(this.getUniqueFailureTestResults());
            List<Element> upstreamJobFailureElements = this.getTestResultGitHubElements(this.getUpstreamJobFailureTestResults());
            if (!upstreamJobFailureElements.isEmpty()) {
                this.upstreamJobFailureMessageElement = messageElement.createCopy();
                Dom4JUtil.getOrderedListElement(upstreamJobFailureElements, this.upstreamJobFailureMessageElement, 3);
            }
            Dom4JUtil.getOrderedListElement(failureElements, messageElement, 3);
            if (failureElements.isEmpty()) {
                return null;
            }
        }
        return messageElement;
    }

    public long getOverheadDuration() {
        long overheadDuration = this.getDuration() - this.getTestExecutionDuration();
        if (overheadDuration <= 0L) {
            return 0L;
        }
        return overheadDuration;
    }

    public long getTestExecutionDuration() {
        long duration;
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup != null && (duration = this.getStopWatchRecordDuration("test.execution.duration")) > 0L) {
            return duration;
        }
        long testExecutionDuration = 0L;
        for (TestResult testResult : this.getTestResults(null)) {
            long testDuration = testResult.getDuration();
            if (testDuration < 0L) continue;
            testExecutionDuration += testDuration;
        }
        return testExecutionDuration;
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(testStatus)) {
            return this.getTestResults();
        }
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (TestResult testResult : this.getTestResults()) {
            if (!testStatus.equals(testResult.getStatus())) continue;
            testResults.add(testResult);
        }
        return testResults;
    }

    @Override
    public List<TestResult> getUniqueFailureTestResults() {
        ArrayList<TestResult> uniqueFailureTestResults = new ArrayList<TestResult>();
        for (TestResult testResult : this.getTestResults(null)) {
            if (!testResult.isFailing() || !testResult.isUniqueFailure()) continue;
            uniqueFailureTestResults.add(testResult);
        }
        return uniqueFailureTestResults;
    }

    @Override
    public List<TestResult> getUpstreamJobFailureTestResults() {
        ArrayList<TestResult> upstreamFailureTestResults = new ArrayList<TestResult>();
        for (TestResult testResult : this.getTestResults(null)) {
            if (!testResult.isFailing() || testResult.isUniqueFailure()) continue;
            upstreamFailureTestResults.add(testResult);
        }
        return upstreamFailureTestResults;
    }

    public List<String> getWarningMessages() {
        ArrayList<String> warningMessages = new ArrayList<String>();
        URL poshiWarningsURL = null;
        try {
            poshiWarningsURL = new URL(this.getArtifactsBaseURL() + "/poshi-warnings.xml.gz");
        }
        catch (IOException ioException) {
            return warningMessages;
        }
        StringBuilder sb = new StringBuilder();
        try (InputStream inputStream = poshiWarningsURL.openStream();
             GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);){
            int i = 0;
            while ((i = gzipInputStream.read()) > 0) {
                sb.append((char)i);
            }
        }
        catch (IOException ioException) {
            return warningMessages;
        }
        try {
            Document document = Dom4JUtil.parse(sb.toString());
            Element rootElement = document.getRootElement();
            for (Element valueElement : rootElement.elements("value")) {
                String liferayErrorText = "LIFERAY_ERROR: ";
                String valueElementText = StringEscapeUtils.escapeHtml((String)valueElement.getText());
                if (valueElementText.startsWith(liferayErrorText)) {
                    valueElementText = valueElementText.substring(liferayErrorText.length());
                }
                warningMessages.add(valueElementText);
            }
        }
        catch (DocumentException documentException) {
            warningMessages.add("Unable to parse Poshi warnings");
        }
        return warningMessages;
    }

    protected DownstreamBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        return null;
    }

    @Override
    protected List<Element> getJenkinsReportBuildDurationsElements() {
        ArrayList<Element> jenkinsReportTableRowElements = new ArrayList<Element>();
        Element buildDurationsHeaderElement = Dom4JUtil.getNewElement("tr");
        ArrayList<String> childStopWatchRows = new ArrayList<String>();
        childStopWatchRows.add("build-duration-names");
        childStopWatchRows.add("build-duration-values");
        childStopWatchRows.add("build-test-duration-values");
        buildDurationsHeaderElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRows));
        buildDurationsHeaderElement.addAttribute("id", this.hashCode() + "-build-durations-header");
        buildDurationsHeaderElement.addAttribute("style", "display: none");
        Element buildDurationsElement = Dom4JUtil.getNewElement("td", buildDurationsHeaderElement, this.getExpanderAnchorElement("build-durations-header", String.valueOf(this.hashCode())), Dom4JUtil.getNewElement("u", null, "Build Durations"));
        buildDurationsElement.addAttribute("style", JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf(this.getDepth() * 35), "px"));
        jenkinsReportTableRowElements.add(buildDurationsHeaderElement);
        Element durationNamesElement = Dom4JUtil.getNewElement("tr");
        durationNamesElement.addAttribute("id", this.hashCode() + "-build-duration-names");
        durationNamesElement.addAttribute("style", "display: none;");
        Element durationNamesDataElement = Dom4JUtil.getNewElement("th", durationNamesElement, "Name");
        String style = JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf((this.getDepth() + 1) * 35), "px");
        durationNamesDataElement.addAttribute("style", style);
        boolean overheadIncluded = false;
        String batchName = this.getBatchName();
        if (batchName.startsWith("function") || batchName.startsWith("integration") || batchName.startsWith("modules-integration") || batchName.startsWith("modules-unit") || batchName.startsWith("unit")) {
            overheadIncluded = true;
        }
        Dom4JUtil.getNewElement("th", durationNamesElement, "Duration");
        Dom4JUtil.getNewElement("th", durationNamesElement, "Duration (est)");
        Dom4JUtil.getNewElement("th", durationNamesElement, "Duration (+/-)");
        if (overheadIncluded) {
            Dom4JUtil.getNewElement("th", durationNamesElement, "Overhead");
            Dom4JUtil.getNewElement("th", durationNamesElement, "Overhead (est)");
            Dom4JUtil.getNewElement("th", durationNamesElement, "Overhead (+/-)");
        }
        jenkinsReportTableRowElements.add(durationNamesElement);
        Element durationValuesElement = Dom4JUtil.getNewElement("tr");
        durationValuesElement.addAttribute("id", this.hashCode() + "-build-duration-values");
        durationValuesElement.addAttribute("style", "display: none;");
        Element durationValuesDataElement = Dom4JUtil.getNewElement("td", durationValuesElement, "Full Build");
        durationValuesDataElement.addAttribute("style", style);
        long duration = this.getDuration();
        long averageDuration = this.getAverageDuration();
        Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(duration));
        Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(averageDuration));
        Dom4JUtil.getNewElement("td", durationValuesElement, this.getDiffDurationString(duration - averageDuration));
        if (overheadIncluded) {
            long overheadDuration = this.getOverheadDuration();
            long averageOverheadDuration = this.getAverageOverheadDuration();
            Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(overheadDuration));
            Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(averageOverheadDuration));
            Dom4JUtil.getNewElement("td", durationValuesElement, this.getDiffDurationString(overheadDuration - averageOverheadDuration));
        }
        jenkinsReportTableRowElements.add(durationValuesElement);
        if (!overheadIncluded) {
            return jenkinsReportTableRowElements;
        }
        Element testDurationsValuesElement = Dom4JUtil.getNewElement("tr");
        testDurationsValuesElement.addAttribute("id", this.hashCode() + "-build-test-duration-values");
        testDurationsValuesElement.addAttribute("style", "display: none;");
        Element testDurationValuesDataElement = Dom4JUtil.getNewElement("td", testDurationsValuesElement, "Total Test Durations");
        testDurationValuesDataElement.addAttribute("style", style);
        long totalBuildTestDurations = 0L;
        long totalBuildTestOverheadDurations = 0L;
        for (TestResult testResult : this.getTestResults()) {
            totalBuildTestDurations += testResult.getDuration();
            totalBuildTestOverheadDurations += testResult.getOverheadDuration();
        }
        AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
        long averageBuildTestDurations = 0L;
        long averageBuildTestOverheadDurations = 0L;
        for (TestClass testClass : axisTestClassGroup.getTestClasses()) {
            averageBuildTestDurations += testClass.getAverageDuration();
            averageBuildTestOverheadDurations += testClass.getAverageOverheadDuration();
        }
        Dom4JUtil.getNewElement("td", testDurationsValuesElement, JenkinsResultsParserUtil.toDurationString(totalBuildTestDurations));
        Dom4JUtil.getNewElement("td", testDurationsValuesElement, JenkinsResultsParserUtil.toDurationString(averageBuildTestDurations));
        Dom4JUtil.getNewElement("td", testDurationsValuesElement, this.getDiffDurationString(totalBuildTestDurations - averageBuildTestDurations));
        Dom4JUtil.getNewElement("td", testDurationsValuesElement, JenkinsResultsParserUtil.toDurationString(totalBuildTestOverheadDurations));
        Dom4JUtil.getNewElement("td", testDurationsValuesElement, JenkinsResultsParserUtil.toDurationString(averageBuildTestOverheadDurations));
        Dom4JUtil.getNewElement("td", testDurationsValuesElement, this.getDiffDurationString(totalBuildTestOverheadDurations - averageBuildTestOverheadDurations));
        jenkinsReportTableRowElements.add(testDurationsValuesElement);
        return jenkinsReportTableRowElements;
    }

    @Override
    protected List<Element> getJenkinsReportTestDurationsElements() {
        String batchName = this.getBatchName();
        if (!(batchName.startsWith("function") || batchName.startsWith("integration") || batchName.startsWith("modules-integration") || batchName.startsWith("modules-unit") || batchName.startsWith("unit"))) {
            return new ArrayList<Element>();
        }
        ArrayList<Element> jenkinsReportTableRowElements = new ArrayList<Element>();
        Element testDurationsHeaderElement = Dom4JUtil.getNewElement("tr");
        testDurationsHeaderElement.addAttribute("id", this.hashCode() + "-test-durations-header");
        testDurationsHeaderElement.addAttribute("style", "display: none");
        ArrayList<String> childStopWatchRows = new ArrayList<String>();
        childStopWatchRows.add("test-duration-names");
        Element testDurationsElement = Dom4JUtil.getNewElement("td", testDurationsHeaderElement, this.getExpanderAnchorElement("test-durations-header", String.valueOf(this.hashCode())), Dom4JUtil.getNewElement("u", null, "Test Durations"));
        testDurationsElement.addAttribute("style", JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf(this.getDepth() * 35), "px"));
        jenkinsReportTableRowElements.add(testDurationsHeaderElement);
        Element durationNamesElement = Dom4JUtil.getNewElement("tr");
        durationNamesElement.addAttribute("id", this.hashCode() + "-test-duration-names");
        durationNamesElement.addAttribute("style", "display: none;");
        Element durationNamesDataElement = Dom4JUtil.getNewElement("th", durationNamesElement, "Name");
        String style = JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf((this.getDepth() + 1) * 35), "px");
        durationNamesDataElement.addAttribute("style", style);
        Dom4JUtil.getNewElement("th", durationNamesElement, "Duration");
        Dom4JUtil.getNewElement("th", durationNamesElement, "Duration (est)");
        Dom4JUtil.getNewElement("th", durationNamesElement, "Duration (+/-)");
        Dom4JUtil.getNewElement("th", durationNamesElement, "Overhead");
        Dom4JUtil.getNewElement("th", durationNamesElement, "Overhead (est)");
        Dom4JUtil.getNewElement("th", durationNamesElement, "Overhead (+/-)");
        jenkinsReportTableRowElements.add(durationNamesElement);
        AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
        List<TestClass> testClasses = axisTestClassGroup.getTestClasses();
        for (int i = 0; i < testClasses.size(); ++i) {
            long overheadDuration;
            long duration;
            String testClassName;
            TestClass testClass;
            block6: {
                TestClassResult testClassResult;
                block5: {
                    testClass = testClasses.get(i);
                    testClassResult = null;
                    testClassName = null;
                    duration = 0L;
                    overheadDuration = 0L;
                    if (!(testClass instanceof JUnitTestClass)) break block5;
                    JUnitTestClass jUnitTestClass = (JUnitTestClass)testClass;
                    testClassName = jUnitTestClass.getTestClassName();
                    testClassResult = this.getTestClassResult(testClassName);
                    if (testClassResult == null) break block6;
                    duration = testClassResult.getDuration();
                    overheadDuration = testClassResult.getOverheadDuration();
                    break block6;
                }
                if (testClass instanceof FunctionalTestClass) {
                    FunctionalTestClass functionalTestClass = (FunctionalTestClass)testClass;
                    testClassName = functionalTestClass.getTestClassMethodName();
                    testClassResult = this.getTestClassResult("com.liferay.poshi.runner.PoshiRunner");
                    if (testClassResult != null) {
                        for (TestResult testResult : testClassResult.getTestResults()) {
                            String testMethodName = "test[" + testClassName + "]";
                            if (!Objects.equals(testMethodName, testResult.getTestName())) continue;
                            duration = testResult.getDuration();
                            overheadDuration = testResult.getOverheadDuration();
                            break;
                        }
                    }
                }
            }
            Element durationValuesElement = Dom4JUtil.getNewElement("tr");
            childStopWatchRows.add("test-duration-values-" + i);
            durationValuesElement.addAttribute("id", this.hashCode() + "-test-duration-values-" + i);
            durationValuesElement.addAttribute("style", "display: none;");
            Element durationValuesDataElement = Dom4JUtil.getNewElement("td", durationValuesElement, testClassName);
            durationValuesDataElement.addAttribute("style", style);
            long averageDuration = testClass.getAverageDuration();
            Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(duration));
            Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(averageDuration));
            Dom4JUtil.getNewElement("td", durationValuesElement, this.getDiffDurationString(duration - averageDuration));
            long averageOverheadDuration = testClass.getAverageOverheadDuration();
            Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(overheadDuration));
            Dom4JUtil.getNewElement("td", durationValuesElement, JenkinsResultsParserUtil.toDurationString(averageOverheadDuration));
            Dom4JUtil.getNewElement("td", durationValuesElement, this.getDiffDurationString(overheadDuration - averageOverheadDuration));
            jenkinsReportTableRowElements.add(durationValuesElement);
        }
        testDurationsHeaderElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRows));
        return jenkinsReportTableRowElements;
    }

    protected long getStopWatchRecordDuration(String stopWatchRecordName) {
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup == null) {
            return 0L;
        }
        StopWatchRecord stopWatchRecord = stopWatchRecordsGroup.get(stopWatchRecordName);
        if (stopWatchRecord == null) {
            return 0L;
        }
        Long duration = stopWatchRecord.getDuration();
        if (duration == null) {
            return 0L;
        }
        return duration;
    }

    protected List<Element> getTestResultGitHubElements(List<TestResult> testResults) {
        ArrayList<Element> testResultGitHubElements = new ArrayList<Element>();
        for (TestResult testResult : testResults) {
            testResultGitHubElements.add(testResult.getGitHubElement());
        }
        return testResultGitHubElements;
    }
}

