/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BaseTopLevelBuildReport;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultTopLevelBuildReport
extends BaseTopLevelBuildReport {
    private final File _jenkinsConsoleLocalFile;
    private final TopLevelBuild _topLevelBuild;

    @Override
    public JSONObject getBuildReportJSONObject() {
        if (this.buildReportJSONObject != null) {
            return this.buildReportJSONObject;
        }
        this.buildReportJSONObject = new JSONObject();
        this.buildReportJSONObject.put("buildParameters", this._topLevelBuild.getParameters());
        this.buildReportJSONObject.put("buildURL", (Object)this._topLevelBuild.getBuildURL());
        this.buildReportJSONObject.put("duration", this._topLevelBuild.getDuration());
        this.buildReportJSONObject.put("result", (Object)this._topLevelBuild.getResult());
        this.buildReportJSONObject.put("startTime", (Object)this._topLevelBuild.getStartTime());
        StopWatchRecordsGroup stopWatchRecordsGroup = this._topLevelBuild.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup != null) {
            this.buildReportJSONObject.put("stopWatchRecords", (Object)stopWatchRecordsGroup.getJSONArray());
        }
        HashMap downstreamBuildMap = new HashMap();
        for (Build build : this._topLevelBuild.getDownstreamBuilds(null)) {
            String batchName = "default";
            ArrayList<JSONObject> downstreamBuildJSONObjects = new ArrayList<JSONObject>();
            if (build instanceof BatchBuild) {
                BatchBuild batchBuild = (BatchBuild)build;
                batchName = batchBuild.getBatchName();
                for (AxisBuild axisBuild : batchBuild.getDownstreamAxisBuilds()) {
                    downstreamBuildJSONObjects.add(this._getDownstreamBuildJSONObject(axisBuild));
                }
            } else {
                if (build instanceof AxisBuild) {
                    AxisBuild axisBuild = (AxisBuild)build;
                    batchName = axisBuild.getBatchName();
                } else if (build instanceof DownstreamBuild) {
                    DownstreamBuild downstreamBuild = (DownstreamBuild)build;
                    batchName = downstreamBuild.getBatchName();
                }
                downstreamBuildJSONObjects.add(this._getDownstreamBuildJSONObject(build));
            }
            downstreamBuildJSONObjects.addAll(downstreamBuildMap.getOrDefault(batchName, new ArrayList()));
            downstreamBuildMap.put(batchName, downstreamBuildJSONObjects);
        }
        JSONArray batchesJSONArray = new JSONArray();
        for (Map.Entry downstreamBuildEntry : downstreamBuildMap.entrySet()) {
            JSONObject batchJSONObject = new JSONObject();
            batchJSONObject.put("batchName", downstreamBuildEntry.getKey());
            batchJSONObject.put("builds", (Collection)downstreamBuildEntry.getValue());
            batchesJSONArray.put((Object)batchJSONObject);
        }
        this.buildReportJSONObject.put("batches", (Object)batchesJSONArray);
        this.buildReportJSONObject.put("testSuiteName", (Object)this._topLevelBuild.getTestSuiteName());
        return this.buildReportJSONObject;
    }

    protected DefaultTopLevelBuildReport(TopLevelBuild topLevelBuild) {
        super(topLevelBuild);
        this._topLevelBuild = topLevelBuild;
        this._jenkinsConsoleLocalFile = new File(System.getenv("WORKSPACE"), JenkinsResultsParserUtil.getDistinctTimeStamp());
        try {
            JenkinsResultsParserUtil.write(this._jenkinsConsoleLocalFile, topLevelBuild.getConsoleText());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    protected JSONObject getBuildJSONObject() {
        return this._topLevelBuild.getBuildJSONObject();
    }

    @Override
    protected File getJenkinsConsoleLocalFile() {
        return this._jenkinsConsoleLocalFile;
    }

    private JSONObject _getDownstreamBuildJSONObject(Build build) {
        JSONObject downstreamBuildJSONObject = new JSONObject();
        if (build instanceof AxisBuild) {
            AxisBuild axisBuild = (AxisBuild)build;
            downstreamBuildJSONObject.put("axisName", (Object)axisBuild.getAxisName());
        } else if (build instanceof DownstreamBuild) {
            DownstreamBuild downstreamBuild = (DownstreamBuild)build;
            downstreamBuildJSONObject.put("axisName", (Object)downstreamBuild.getAxisName());
        }
        downstreamBuildJSONObject.put("buildURL", (Object)build.getBuildURL());
        downstreamBuildJSONObject.put("duration", build.getDuration());
        downstreamBuildJSONObject.put("result", (Object)build.getResult());
        downstreamBuildJSONObject.put("startTime", (Object)build.getStartTime());
        StopWatchRecordsGroup stopWatchRecordsGroup = build.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup != null) {
            downstreamBuildJSONObject.put("stopWatchRecords", (Object)stopWatchRecordsGroup.getJSONArray());
        }
        JSONArray testResultsJSONArray = new JSONArray();
        for (TestResult testResult : build.getTestResults(null)) {
            testResultsJSONArray.put((Object)this._getTestResultJSONObject(testResult));
        }
        downstreamBuildJSONObject.put("testResults", (Object)testResultsJSONArray);
        return downstreamBuildJSONObject;
    }

    private JSONObject _getTestResultJSONObject(TestResult testResult) {
        JSONObject testResultJSONObject = new JSONObject();
        testResultJSONObject.put("duration", testResult.getDuration());
        String errorDetails = testResult.getErrorDetails();
        if (errorDetails != null) {
            if (errorDetails.contains("\n")) {
                int index = errorDetails.indexOf("\n");
                errorDetails = errorDetails.substring(0, index);
            }
            if (errorDetails.length() > 200) {
                errorDetails = errorDetails.substring(0, 200);
            }
            testResultJSONObject.put("errorDetails", (Object)errorDetails);
        }
        testResultJSONObject.put("name", (Object)testResult.getDisplayName());
        testResultJSONObject.put("status", (Object)testResult.getStatus());
        return testResultJSONObject;
    }
}

