/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.io.File;
import java.util.Properties;
import org.json.JSONObject;

public class DefaultPortalJob
extends BaseJob
implements PortalTestClassJob,
TestSuiteJob {
    private PortalGitWorkingDirectory _portalGitWorkingDirectory;
    private final String _testSuiteName;

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("test_suite_name", (Object)this._testSuiteName);
        return this.jsonObject;
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        GitWorkingDirectory gitWorkingDirectory;
        if (this._portalGitWorkingDirectory != null) {
            return this._portalGitWorkingDirectory;
        }
        File portalRepositoryDir = new File(".");
        File portalTestPropertiesFile = new File(portalRepositoryDir, "test.properties");
        Properties portalTestProperties = JenkinsResultsParserUtil.getProperties(portalTestPropertiesFile);
        String portalUpstreamBranchName = portalTestProperties.getProperty("liferay.portal.branch", "master");
        String portalRepositoryName = "liferay-portal";
        if (!portalUpstreamBranchName.equals("master")) {
            portalRepositoryName = portalRepositoryName + "-ee";
        }
        if (!((gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(portalUpstreamBranchName, portalRepositoryDir, portalRepositoryName)) instanceof PortalGitWorkingDirectory)) {
            throw new RuntimeException("Invalid portal Git working directory");
        }
        this._portalGitWorkingDirectory = (PortalGitWorkingDirectory)gitWorkingDirectory;
        return this._portalGitWorkingDirectory;
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    protected DefaultPortalJob(Job.BuildProfile buildProfile, String jobName, String testSuiteName) {
        super(buildProfile, jobName);
        this._testSuiteName = testSuiteName;
        this._initialize();
    }

    protected DefaultPortalJob(JSONObject jsonObject) {
        super(jsonObject);
        this._testSuiteName = jsonObject.getString("test_suite_name");
        this._initialize();
    }

    private void _initialize() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        File portalWorkingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
        this.jobPropertiesFiles.add(new File(portalWorkingDirectory, "build.properties"));
        this.jobPropertiesFiles.add(new File(portalWorkingDirectory, "test.properties"));
    }
}

