/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.CucumberFeatureResult;
import com.liferay.jenkins.results.parser.CucumberScenarioResult;
import com.liferay.jenkins.results.parser.CucumberTestResult;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TestResultFactory;
import java.util.ArrayList;
import java.util.List;

public class CucumberTestClassResult
implements TestClassResult {
    private final Build _build;
    private final CucumberFeatureResult _cucumberFeatureResult;
    private final CucumberScenarioResult _cucumberScenarioResult;
    private final List<TestResult> _testResults = new ArrayList<TestResult>();

    @Override
    public Build getBuild() {
        return this._build;
    }

    @Override
    public String getClassName() {
        return this._cucumberFeatureResult.getName();
    }

    public CucumberFeatureResult getCucumberFeatureResult() {
        return this._cucumberFeatureResult;
    }

    public CucumberScenarioResult getCucumberScenarioResult() {
        return this._cucumberScenarioResult;
    }

    public String getCucumberTestName() {
        return JenkinsResultsParserUtil.combine(this._cucumberFeatureResult.getName(), " > ", this._cucumberScenarioResult.getScenarioName());
    }

    public CucumberTestResult getCucumberTestResult(String testName) {
        for (TestResult testResult : this.getTestResults()) {
            if (!testName.equals(testResult.getTestName())) continue;
            return (CucumberTestResult)testResult;
        }
        return null;
    }

    @Override
    public long getDuration() {
        return this._cucumberScenarioResult.getDuration();
    }

    @Override
    public long getOverheadDuration() {
        return 0L;
    }

    @Override
    public String getPackageName() {
        return null;
    }

    @Override
    public String getSimpleClassName() {
        return this._cucumberFeatureResult.getName();
    }

    @Override
    public String getStatus() {
        return this._cucumberScenarioResult.getStatus();
    }

    @Override
    public TestResult getTestResult(String testName) {
        for (TestResult testResult : this.getTestResults()) {
            if (!testName.equals(testResult.getTestName())) continue;
            return testResult;
        }
        return null;
    }

    @Override
    public List<TestResult> getTestResults() {
        return this._testResults;
    }

    @Override
    public boolean isFailing() {
        for (TestResult testResult : this.getTestResults()) {
            if (!testResult.isFailing()) continue;
            return true;
        }
        return false;
    }

    protected CucumberTestClassResult(Build build, CucumberScenarioResult cucumberScenarioResult) {
        this._build = build;
        if (cucumberScenarioResult == null) {
            throw new IllegalArgumentException("Scenario result is null");
        }
        this._cucumberScenarioResult = cucumberScenarioResult;
        this._cucumberFeatureResult = cucumberScenarioResult.getCucumberFeatureResult();
        this._testResults.add(TestResultFactory.newCucumberTestResultTestResult(build, cucumberScenarioResult));
    }
}

