/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.BaseLocalGitRepository;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.GitCommitFactory;
import com.liferay.jenkins.results.parser.GitHubDevSyncUtil;
import com.liferay.jenkins.results.parser.GitRemote;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitBranch;
import com.liferay.jenkins.results.parser.LocalGitCommit;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestFactory;
import com.liferay.jenkins.results.parser.RemoteGitBranch;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseWorkspaceGitRepository
extends BaseLocalGitRepository
implements WorkspaceGitRepository {
    private static final String[] _REQUIRED_KEYS = new String[]{"base_branch_head_sha", "base_branch_sha", "base_branch_username", "git_hub_url", "sender_branch_head_sha", "sender_branch_name", "sender_branch_sha", "sender_branch_username"};
    private String _branchName;
    private List<LocalGitCommit> _historicalLocalGitCommits;
    private LocalGitBranch _localGitBranch;
    private final Set<String> _propertyOptions = new HashSet<String>();
    private boolean _rebase;
    private RemoteGitRef _senderRemoteGitRef;
    private boolean _setUp;
    private RemoteGitRef _upstreamRemoteGitRef;

    @Override
    public void addPropertyOption(String propertyOption) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(propertyOption)) {
            return;
        }
        this._propertyOptions.add(propertyOption);
    }

    @Override
    public String getBaseBranchSHA() {
        return this.getString("base_branch_sha");
    }

    @Override
    public String getBranchName() {
        if (this._branchName != null) {
            return this._branchName;
        }
        this._branchName = JenkinsResultsParserUtil.combine(this.getUpstreamBranchName(), "-temp-", String.valueOf(JenkinsResultsParserUtil.getCurrentTimeMillis()));
        return this._branchName;
    }

    @Override
    public String getFileContent(String filePath) {
        File file = new File(this.getDirectory(), filePath);
        if (!file.exists()) {
            return null;
        }
        try {
            String fileContent = JenkinsResultsParserUtil.read(file);
            return fileContent.trim();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getGitHubDevBranchName() {
        String baseBranchSHA = this._getBaseBranchHeadSHA();
        String senderBranchSHA = this._getSenderBranchHeadSHA();
        if (this._isPullRequest()) {
            baseBranchSHA = this.getBaseBranchSHA();
            senderBranchSHA = this.getSenderBranchSHA();
        }
        return GitHubDevSyncUtil.getCacheBranchName(this._getBaseBranchUsername(), this.getSenderBranchUsername(), senderBranchSHA, baseBranchSHA);
    }

    @Override
    public String getGitHubURL() {
        return this.getString("git_hub_url");
    }

    @Override
    public List<LocalGitCommit> getHistoricalLocalGitCommits() {
        if (this._historicalLocalGitCommits != null) {
            return this._historicalLocalGitCommits;
        }
        if (!this.has("commits")) {
            return new ArrayList<LocalGitCommit>();
        }
        this._historicalLocalGitCommits = new ArrayList<LocalGitCommit>();
        JSONArray commitsJSONArray = this.getJSONArray("commits");
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        for (int i = 0; i < commitsJSONArray.length(); ++i) {
            JSONObject commitJSONObject = commitsJSONArray.getJSONObject(i);
            this._historicalLocalGitCommits.add(GitCommitFactory.newLocalGitCommit(commitJSONObject.getString("emailAddress"), gitWorkingDirectory, commitJSONObject.getString("message"), commitJSONObject.getString("sha"), commitJSONObject.getLong("commitTime")));
        }
        return this._historicalLocalGitCommits;
    }

    @Override
    public String getSenderBranchName() {
        return this.getString("sender_branch_name");
    }

    @Override
    public String getSenderBranchSHA() {
        return this.getString("sender_branch_sha");
    }

    @Override
    public String getSenderBranchUsername() {
        return this.getString("sender_branch_username");
    }

    @Override
    public List<List<LocalGitCommit>> partitionLocalGitCommits(List<LocalGitCommit> localGitCommits, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Invalid count " + count);
        }
        if (localGitCommits == null || localGitCommits.isEmpty()) {
            return Collections.emptyList();
        }
        int localGitCommitsSize = localGitCommits.size();
        if (count > localGitCommitsSize) {
            ArrayList<List<LocalGitCommit>> partitionedLocalGitCommits = new ArrayList<List<LocalGitCommit>>(localGitCommitsSize);
            for (LocalGitCommit localGitCommit : localGitCommits) {
                partitionedLocalGitCommits.add(Lists.newArrayList((Object[])new LocalGitCommit[]{localGitCommit}));
            }
            return partitionedLocalGitCommits;
        }
        ArrayList<List<LocalGitCommit>> partitionedLocalGitCommits = new ArrayList<List<LocalGitCommit>>(count);
        LocalGitCommit lastLocalGitCommit = localGitCommits.remove(localGitCommits.size() - 1);
        if (!localGitCommits.isEmpty()) {
            partitionedLocalGitCommits.addAll(JenkinsResultsParserUtil.partitionByCount(localGitCommits, count - 1));
        }
        partitionedLocalGitCommits.add(Lists.newArrayList((Object[])new LocalGitCommit[]{lastLocalGitCommit}));
        return partitionedLocalGitCommits;
    }

    @Override
    public void setBaseBranchSHA(String branchSHA) {
        if (!JenkinsResultsParserUtil.isSHA(branchSHA)) {
            throw new RuntimeException("Invalid base branch SHA " + branchSHA);
        }
        this.put("base_branch_sha", branchSHA);
    }

    @Override
    public void setGitHubURL(String gitHubURL) {
        if (gitHubURL == null) {
            throw new RuntimeException("GitHub URL is null");
        }
        if (gitHubURL.equals(this.optString("git_hub_url")) && !this._rebase) {
            return;
        }
        this._localGitBranch = null;
        this._setGitHubURL(gitHubURL);
        if (PullRequest.isValidGitHubPullRequestURL(gitHubURL)) {
            PullRequest pullRequest = PullRequestFactory.newPullRequest(gitHubURL);
            this._upstreamRemoteGitRef = pullRequest.getUpstreamRemoteGitBranch();
            this._setBaseBranchHeadSHA(this._upstreamRemoteGitRef.getSHA());
            this.setBaseBranchSHA(this._upstreamRemoteGitRef.getSHA());
            this._setBaseBranchUsername(this._upstreamRemoteGitRef.getUsername());
            this._senderRemoteGitRef = pullRequest.getSenderRemoteGitBranch();
            this._setSenderBranchHeadSHA(this._senderRemoteGitRef.getSHA());
            this._setSenderBranchName(this._senderRemoteGitRef.getName());
            this.setSenderBranchSHA(this._senderRemoteGitRef.getSHA());
            this._setSenderBranchUsername(this._senderRemoteGitRef.getUsername());
        } else if (GitUtil.isValidGitHubRefURL(gitHubURL)) {
            this._upstreamRemoteGitRef = this._getUpstreamRemoteGitRef();
            this._setBaseBranchHeadSHA(this._upstreamRemoteGitRef.getSHA());
            this.setBaseBranchSHA(this._upstreamRemoteGitRef.getSHA());
            this._setBaseBranchUsername(this._upstreamRemoteGitRef.getUsername());
            this._senderRemoteGitRef = GitUtil.getRemoteGitRef(gitHubURL);
            this._setSenderBranchHeadSHA(this._senderRemoteGitRef.getSHA());
            this._setSenderBranchName(this._senderRemoteGitRef.getName());
            this.setSenderBranchSHA(this._senderRemoteGitRef.getSHA());
            this._setSenderBranchUsername(this._senderRemoteGitRef.getUsername());
            if (this._rebase) {
                this._setBaseBranchHeadSHA(this._upstreamRemoteGitRef.getSHA());
                this.setBaseBranchSHA(this._upstreamRemoteGitRef.getSHA());
                this._setBaseBranchUsername(this._upstreamRemoteGitRef.getUsername());
            }
        } else {
            throw new RuntimeException("Invalid GitHub URL " + gitHubURL);
        }
        this.validateKeys(_REQUIRED_KEYS);
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
        buildDatabase.putWorkspaceGitRepository(this.getDirectoryName(), this);
    }

    @Override
    public void setRebase(boolean rebase) {
        this._rebase = rebase;
    }

    @Override
    public void setSenderBranchSHA(String branchSHA) {
        if (!JenkinsResultsParserUtil.isSHA(branchSHA)) {
            throw new RuntimeException("Invalid sender branch SHA " + branchSHA);
        }
        this.put("sender_branch_sha", branchSHA);
        if (!this._isPullRequest()) {
            this.setBaseBranchSHA(branchSHA);
        }
    }

    @Override
    public synchronized void setUp() {
        if (this._setUp) {
            return;
        }
        System.out.println(this.toString());
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        if (this._rebase) {
            gitWorkingDirectory.createLocalGitBranch(this.getUpstreamBranchName(), true, this.getBaseBranchSHA());
        }
        LocalGitBranch localGitBranch = this.getLocalGitBranch();
        gitWorkingDirectory.checkoutLocalGitBranch(localGitBranch);
        LocalGitBranch baseLocalGitBranch = gitWorkingDirectory.createLocalGitBranch(this.getUpstreamBranchName(), true, this.getBaseBranchSHA());
        if (this._rebase) {
            gitWorkingDirectory.rebase(true, baseLocalGitBranch, localGitBranch);
        }
        gitWorkingDirectory.reset("--hard " + localGitBranch.getSHA());
        gitWorkingDirectory.clean();
        gitWorkingDirectory.displayLog();
        this._setUp = true;
    }

    @Override
    public void storeCommitHistory(List<String> commitSHAs) {
        List<LocalGitCommit> historicalLocalGitCommits = this.getHistoricalLocalGitCommits();
        ArrayList<String> requiredCommitSHAs = new ArrayList<String>();
        requiredCommitSHAs.addAll(commitSHAs);
        JSONArray commitsJSONArray = new JSONArray();
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        for (int index = 0; index < COMMITS_HISTORY_SIZE_MAX; index += COMMITS_HISTORY_GROUP_SIZE.intValue()) {
            int currentGroupSize = COMMITS_HISTORY_GROUP_SIZE;
            if (index > COMMITS_HISTORY_SIZE_MAX - COMMITS_HISTORY_GROUP_SIZE) {
                currentGroupSize = COMMITS_HISTORY_SIZE_MAX % COMMITS_HISTORY_GROUP_SIZE;
            }
            List<LocalGitCommit> localGitCommits = gitWorkingDirectory.log(index, currentGroupSize);
            for (LocalGitCommit localGitCommit : localGitCommits) {
                historicalLocalGitCommits.add(localGitCommit);
                commitsJSONArray.put((Object)localGitCommit.toJSONObject());
                String sha = localGitCommit.getSHA();
                if (requiredCommitSHAs.contains(sha)) {
                    requiredCommitSHAs.remove(sha);
                }
                if (!requiredCommitSHAs.isEmpty()) continue;
                break;
            }
            if (requiredCommitSHAs.isEmpty()) break;
        }
        if (!requiredCommitSHAs.isEmpty()) {
            throw new RuntimeException("Unable to find the following SHAs: " + requiredCommitSHAs);
        }
        this.put("commits", commitsJSONArray);
    }

    @Override
    public void synchronizeToGitHubDev() {
        GitHubDevSyncUtil.synchronizeToGitHubDev(this.getLocalGitBranch(), this);
    }

    @Override
    public void tearDown() {
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        LocalGitBranch upstreamLocalGitBranch = gitWorkingDirectory.getUpstreamLocalGitBranch();
        System.out.println(upstreamLocalGitBranch);
        gitWorkingDirectory.checkoutLocalGitBranch(upstreamLocalGitBranch);
        gitWorkingDirectory.reset("--hard " + upstreamLocalGitBranch.getSHA());
        gitWorkingDirectory.clean();
        gitWorkingDirectory.cleanTempBranches();
        gitWorkingDirectory.displayLog();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDirectory());
        sb.append(" - ");
        sb.append(this.getGitHubURL());
        sb.append(" - ");
        sb.append(this.getSenderBranchName());
        sb.append(" (");
        sb.append(this.getSenderBranchSHA(), 0, 7);
        sb.append(")");
        if (this._isPullRequest()) {
            sb.append(" - ");
            sb.append(this.getUpstreamBranchName());
            sb.append(" (");
            sb.append(this.getBaseBranchSHA(), 0, 7);
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public void writePropertiesFiles() {
    }

    protected BaseWorkspaceGitRepository(JSONObject jsonObject) {
        super(jsonObject);
        this.validateKeys(_REQUIRED_KEYS);
    }

    protected BaseWorkspaceGitRepository(PullRequest pullRequest, String upstreamBranchName) {
        super(pullRequest.getGitHubRemoteGitRepositoryName(), upstreamBranchName);
        this.setGitHubURL(pullRequest.getHtmlURL());
        this.validateKeys(_REQUIRED_KEYS);
    }

    protected BaseWorkspaceGitRepository(RemoteGitRef remoteGitRef, String upstreamBranchName) {
        super(remoteGitRef.getRepositoryName(), upstreamBranchName);
        this.setGitHubURL(remoteGitRef.getHtmlURL());
        this.validateKeys(_REQUIRED_KEYS);
    }

    protected synchronized LocalGitBranch getLocalGitBranch() {
        if (this._localGitBranch != null) {
            return this._localGitBranch;
        }
        this._localGitBranch = this._isPullRequest() ? this._createPullRequestLocalGitBranch() : this._createRemoteGitRefLocalGitBranch();
        return this._localGitBranch;
    }

    protected Properties getProperties(String propertyType) {
        Properties buildProperties = new Properties();
        Map<String, String> envMap = System.getenv();
        for (Map.Entry<String, String> envEntry : envMap.entrySet()) {
            buildProperties.setProperty("env." + envEntry.getKey(), envEntry.getValue());
        }
        buildProperties.putAll(System.getenv());
        try {
            buildProperties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getBuildProperties());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        Properties properties = new Properties();
        for (String buildPropertyName : buildProperties.stringPropertyNames()) {
            List<String> buildPropertyOptions;
            if (!buildPropertyName.startsWith(propertyType) || (buildPropertyOptions = JenkinsResultsParserUtil.getPropertyOptions(buildPropertyName)).isEmpty()) continue;
            String propertyName = buildPropertyOptions.get(0);
            ArrayList<String> propertyOptions = new ArrayList<String>(this.getPropertyOptions());
            propertyOptions.removeAll(Collections.singleton(null));
            String propertyValue = JenkinsResultsParserUtil.getProperty(buildProperties, propertyType + "[" + propertyName + "]", propertyOptions.toArray(new String[0]));
            if (propertyValue == null) continue;
            if (JenkinsResultsParserUtil.isWindows() && propertyValue.startsWith("/") && !propertyValue.startsWith("/c/")) {
                propertyValue = "C:" + propertyValue;
            }
            properties.put(propertyName, propertyValue);
        }
        return properties;
    }

    protected Set<String> getPropertyOptions() {
        return this._propertyOptions;
    }

    private LocalGitBranch _createPullRequestLocalGitBranch() {
        String baseBranchSHA;
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        List<GitRemote> gitHubDevGitRemotes = GitHubDevSyncUtil.getGitHubDevGitRemotes(gitWorkingDirectory);
        for (int i = 0; i < 3 && !gitHubDevGitRemotes.isEmpty(); ++i) {
            GitRemote randomGitRemote = JenkinsResultsParserUtil.getRandomListItem(gitHubDevGitRemotes);
            gitHubDevGitRemotes.remove(randomGitRemote);
            RemoteGitBranch remoteGitBranch = gitWorkingDirectory.getRemoteGitBranch(this.getGitHubDevBranchName(), randomGitRemote);
            if (remoteGitBranch == null) continue;
            String remoteGitBranchSHA = remoteGitBranch.getSHA();
            try {
                gitWorkingDirectory.fetch(remoteGitBranch);
            }
            catch (Exception exception) {
                continue;
            }
            if (!gitWorkingDirectory.localSHAExists(remoteGitBranchSHA)) continue;
            return gitWorkingDirectory.createLocalGitBranch(this.getBranchName(), true, remoteGitBranchSHA);
        }
        String senderBranchSHA = this.getSenderBranchSHA();
        if (!gitWorkingDirectory.localSHAExists(senderBranchSHA)) {
            gitWorkingDirectory.fetch(this._getSenderRemoteGitRef());
        }
        if (!gitWorkingDirectory.localSHAExists(baseBranchSHA = this.getBaseBranchSHA())) {
            gitWorkingDirectory.fetch(this._getUpstreamRemoteGitRef());
        }
        gitWorkingDirectory.createLocalGitBranch(this.getUpstreamBranchName(), true, baseBranchSHA);
        return gitWorkingDirectory.getRebasedLocalGitBranch(this.getBranchName(), this.getSenderBranchName(), JenkinsResultsParserUtil.combine("git@github.com:", this.getSenderBranchUsername(), "/", this.getName()), senderBranchSHA, this.getUpstreamBranchName(), baseBranchSHA);
    }

    private LocalGitBranch _createRemoteGitRefLocalGitBranch() {
        String senderBranchHeadSHA = this._getSenderBranchHeadSHA();
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        if (!gitWorkingDirectory.localSHAExists(senderBranchHeadSHA)) {
            List<GitRemote> gitHubDevGitRemotes = GitHubDevSyncUtil.getGitHubDevGitRemotes(gitWorkingDirectory);
            for (int i = 0; i < 3 && !gitHubDevGitRemotes.isEmpty(); ++i) {
                GitRemote randomGitRemote = JenkinsResultsParserUtil.getRandomListItem(gitHubDevGitRemotes);
                gitHubDevGitRemotes.remove(randomGitRemote);
                RemoteGitBranch remoteGitBranch = gitWorkingDirectory.getRemoteGitBranch(this.getGitHubDevBranchName(), randomGitRemote);
                if (remoteGitBranch == null) continue;
                try {
                    gitWorkingDirectory.fetch(remoteGitBranch);
                }
                catch (Exception exception) {
                    continue;
                }
                if (gitWorkingDirectory.localSHAExists(senderBranchHeadSHA)) break;
            }
            if (!gitWorkingDirectory.localSHAExists(senderBranchHeadSHA)) {
                gitWorkingDirectory.fetch(this._getSenderRemoteGitRef());
            }
        }
        return gitWorkingDirectory.createLocalGitBranch(this.getBranchName(), true, this.getSenderBranchSHA());
    }

    private String _getBaseBranchHeadSHA() {
        return this.getString("base_branch_head_sha");
    }

    private String _getBaseBranchUsername() {
        return this.getString("base_branch_username");
    }

    private String _getSenderBranchHeadSHA() {
        return this.getString("sender_branch_head_sha");
    }

    private RemoteGitRef _getSenderRemoteGitRef() {
        if (this._senderRemoteGitRef != null) {
            return this._senderRemoteGitRef;
        }
        this._senderRemoteGitRef = GitUtil.getRemoteGitRef(JenkinsResultsParserUtil.combine("https://github.com/", this.getSenderBranchUsername(), "/", this.getName(), "/tree/", this.getSenderBranchName()));
        return this._senderRemoteGitRef;
    }

    private RemoteGitRef _getUpstreamRemoteGitRef() {
        if (this._upstreamRemoteGitRef != null) {
            return this._upstreamRemoteGitRef;
        }
        this._upstreamRemoteGitRef = GitUtil.getRemoteGitRef(JenkinsResultsParserUtil.combine("https://github.com/liferay/", this.getName(), "/tree/", this.getUpstreamBranchName()));
        return this._upstreamRemoteGitRef;
    }

    private boolean _isPullRequest() {
        return PullRequest.isValidGitHubPullRequestURL(this.getGitHubURL());
    }

    private void _setBaseBranchHeadSHA(String branchSHA) {
        if (!JenkinsResultsParserUtil.isSHA(branchSHA)) {
            throw new RuntimeException("Invalid base branch head SHA " + branchSHA);
        }
        this.put("base_branch_head_sha", branchSHA);
    }

    private void _setBaseBranchUsername(String username) {
        this.put("base_branch_username", username);
    }

    private void _setGitHubURL(String gitHubURL) {
        if (gitHubURL == null) {
            throw new RuntimeException("GitHub URL is null");
        }
        this.put("git_hub_url", gitHubURL);
    }

    private void _setSenderBranchHeadSHA(String branchSHA) {
        if (!JenkinsResultsParserUtil.isSHA(branchSHA)) {
            throw new RuntimeException("Invalid sender branch head SHA " + branchSHA);
        }
        this.put("sender_branch_head_sha", branchSHA);
    }

    private void _setSenderBranchName(String branchName) {
        this.put("sender_branch_name", branchName);
    }

    private void _setSenderBranchUsername(String username) {
        this.put("sender_branch_username", username);
    }
}

