/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepositoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import org.json.JSONObject;

public abstract class BaseWorkspace
implements Workspace {
    protected static final ThreadPoolExecutor threadPoolExecutor = JenkinsResultsParserUtil.getNewThreadPoolExecutor(16, true);
    protected final JSONObject jsonObject;
    private static final String[] _REQUIRED_KEYS = new String[]{"primary_repository_dir_name", "primary_repository_name", "primary_upstream_branch_name", "workspace_repository_dir_names"};
    private ParallelExecutor<Object> _parallelExecutor;
    private final WorkspaceGitRepository _primaryWorkspaceGitRepository;
    private Map<String, WorkspaceGitRepository> _workspaceGitRepositories;

    @Override
    public JSONObject getJSONObject() {
        return this.jsonObject;
    }

    @Override
    public WorkspaceGitRepository getPrimaryWorkspaceGitRepository() {
        return this._primaryWorkspaceGitRepository;
    }

    @Override
    public List<WorkspaceGitRepository> getWorkspaceGitRepositories() {
        if (this._workspaceGitRepositories != null) {
            return new ArrayList<WorkspaceGitRepository>(this._workspaceGitRepositories.values());
        }
        this._workspaceGitRepositories = new HashMap<String, WorkspaceGitRepository>();
        String workspaceRepositoryDirNames = this.jsonObject.getString("workspace_repository_dir_names");
        if (JenkinsResultsParserUtil.isNullOrEmpty(workspaceRepositoryDirNames)) {
            return new ArrayList<WorkspaceGitRepository>(this._workspaceGitRepositories.values());
        }
        ArrayList callables = new ArrayList();
        for (final String workspaceRepositoryDirName : workspaceRepositoryDirNames.split(",")) {
            Callable<WorkspaceGitRepository> callable = new Callable<WorkspaceGitRepository>(){

                @Override
                public WorkspaceGitRepository call() {
                    return GitRepositoryFactory.getWorkspaceGitRepository(workspaceRepositoryDirName.trim());
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, threadPoolExecutor);
        List workspaceGitRepositories = parallelExecutor.execute();
        for (WorkspaceGitRepository workspaceGitRepository : workspaceGitRepositories) {
            this._workspaceGitRepositories.put(workspaceGitRepository.getDirectoryName(), workspaceGitRepository);
        }
        return new ArrayList<WorkspaceGitRepository>(this._workspaceGitRepositories.values());
    }

    @Override
    public WorkspaceGitRepository getWorkspaceGitRepository(String repositoryDirName) {
        if (this._workspaceGitRepositories == null) {
            this.getWorkspaceGitRepositories();
        }
        return this._workspaceGitRepositories.get(repositoryDirName);
    }

    @Override
    public void setUp() {
        ArrayList callables = new ArrayList();
        for (final WorkspaceGitRepository workspaceGitRepository : this.getWorkspaceGitRepositories()) {
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() {
                    workspaceGitRepository.setUp();
                    return null;
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, threadPoolExecutor);
        parallelExecutor.execute();
        this.writePropertiesFiles();
    }

    @Override
    public synchronized void startSynchronizeToGitHubDev() {
        if (this._parallelExecutor != null) {
            return;
        }
        ArrayList callables = new ArrayList();
        for (final WorkspaceGitRepository workspaceGitRepository : this.getWorkspaceGitRepositories()) {
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() {
                    workspaceGitRepository.synchronizeToGitHubDev();
                    return null;
                }
            };
            callables.add(callable);
        }
        this._parallelExecutor = new ParallelExecutor(callables, threadPoolExecutor);
        this._parallelExecutor.start();
    }

    @Override
    public synchronized void synchronizeToGitHubDev() {
        this.startSynchronizeToGitHubDev();
        this.waitForSynchronizeToGitHubDev();
    }

    @Override
    public void tearDown() {
        ArrayList callables = new ArrayList();
        for (final WorkspaceGitRepository workspaceGitRepository : this.getWorkspaceGitRepositories()) {
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() {
                    try {
                        workspaceGitRepository.tearDown();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return null;
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, threadPoolExecutor);
        parallelExecutor.execute();
    }

    @Override
    public void waitForSynchronizeToGitHubDev() {
        if (this._parallelExecutor == null) {
            throw new RuntimeException("Synchronize to GitHub dev did not start");
        }
        this._parallelExecutor.waitFor();
    }

    @Override
    public void writePropertiesFiles() {
        for (WorkspaceGitRepository workspaceGitRepository : this.getWorkspaceGitRepositories()) {
            workspaceGitRepository.writePropertiesFiles();
        }
    }

    protected BaseWorkspace(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
        this._validateKeys();
        this._primaryWorkspaceGitRepository = GitRepositoryFactory.getWorkspaceGitRepository(this.jsonObject.getString("primary_repository_name"), this.jsonObject.getString("primary_upstream_branch_name"));
    }

    protected BaseWorkspace(String primaryRepositoryName, String upstreamBranchName) {
        this(primaryRepositoryName, upstreamBranchName, null);
    }

    protected BaseWorkspace(String primaryRepositoryName, String upstreamBranchName, String jobName) {
        this._primaryWorkspaceGitRepository = GitRepositoryFactory.getWorkspaceGitRepository(primaryRepositoryName, upstreamBranchName);
        this.jsonObject = new JSONObject();
        this.jsonObject.put("primary_repository_dir_name", (Object)this._primaryWorkspaceGitRepository.getDirectoryName());
        this.jsonObject.put("primary_repository_name", (Object)this._primaryWorkspaceGitRepository.getName());
        this.jsonObject.put("primary_upstream_branch_name", (Object)this._primaryWorkspaceGitRepository.getUpstreamBranchName());
        try {
            this.jsonObject.put("workspace_repository_dir_names", (Object)JenkinsResultsParserUtil.removeDuplicates(",", JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "workspace.repository.dir.names", this._primaryWorkspaceGitRepository.getName(), this._primaryWorkspaceGitRepository.getUpstreamBranchName(), jobName)));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        this._validateKeys();
    }

    private void _validateKeys() {
        for (String requiredKey : _REQUIRED_KEYS) {
            if (this.jsonObject.has(requiredKey)) continue;
            throw new RuntimeException("Missing " + requiredKey);
        }
    }
}

