/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TestResultFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseTestClassResult
implements TestClassResult {
    private final Build _build;
    private final long _duration;
    private Status _status;
    private final JSONObject _suiteJSONObject;
    private final Map<String, TestResult> _testResults = new TreeMap<String, TestResult>();

    @Override
    public Build getBuild() {
        return this._build;
    }

    @Override
    public String getClassName() {
        List<TestResult> testResults = this.getTestResults();
        if (testResults.isEmpty()) {
            return this._suiteJSONObject.getString("name");
        }
        TestResult testResult = testResults.get(0);
        return testResult.getClassName();
    }

    @Override
    public long getDuration() {
        return this._duration;
    }

    @Override
    public long getOverheadDuration() {
        Build build = this.getBuild();
        if (!(build instanceof DownstreamBuild)) {
            return 0L;
        }
        DownstreamBuild downstreamBuild = (DownstreamBuild)build;
        long overheadDuration = downstreamBuild.getTestExecutionDuration();
        if (overheadDuration <= 0L) {
            return 0L;
        }
        long totalDuration = 0L;
        List<TestClassResult> testClassResults = build.getTestClassResults();
        for (TestClassResult testClassResult : testClassResults) {
            long duration = testClassResult.getDuration();
            if (duration < 0L) continue;
            totalDuration += duration;
        }
        if ((overheadDuration -= totalDuration) <= 0L) {
            return 0L;
        }
        return overheadDuration / (long)testClassResults.size();
    }

    @Override
    public String getPackageName() {
        String className = this.getClassName();
        int x = className.lastIndexOf(".");
        if (x < 0) {
            return "(root)";
        }
        return className.substring(0, x);
    }

    @Override
    public String getSimpleClassName() {
        String className = this.getClassName();
        int x = className.lastIndexOf(".");
        return className.substring(x + 1);
    }

    @Override
    public String getStatus() {
        if (this._status != null) {
            return this._status.toString();
        }
        this._status = Status.PASSED;
        for (TestResult testResult : this.getTestResults()) {
            Status status = Status.valueOf(testResult.getStatus());
            if (this._status.getPriority() <= status.getPriority()) continue;
            this._status = status;
        }
        return this._status.toString();
    }

    @Override
    public TestResult getTestResult(String testName) {
        return this._testResults.get(testName);
    }

    @Override
    public List<TestResult> getTestResults() {
        return new ArrayList<TestResult>(this._testResults.values());
    }

    @Override
    public boolean isFailing() {
        Status status = Status.valueOf(this.getStatus());
        return status != Status.FIXED && status != Status.PASSED && status != Status.SKIPPED;
    }

    protected BaseTestClassResult(Build build, JSONObject suiteJSONObject) {
        if (suiteJSONObject == null) {
            throw new RuntimeException("Please set suiteJSONObject");
        }
        this._build = build;
        this._suiteJSONObject = suiteJSONObject;
        this._duration = (long)(suiteJSONObject.getDouble("duration") * 1000.0);
        if (!suiteJSONObject.has("cases")) {
            return;
        }
        JSONArray casesJSONArray = suiteJSONObject.getJSONArray("cases");
        for (int i = 0; i < casesJSONArray.length(); ++i) {
            JSONObject caseJSONObject = casesJSONArray.getJSONObject(i);
            TestResult testResult = TestResultFactory.newTestResult(build, caseJSONObject);
            this._testResults.put(testResult.getTestName(), testResult);
        }
    }

    private static enum Status {
        ABORTED(1),
        FAILED(2),
        FIXED(6),
        PASSED(7),
        REGRESSION(3),
        SKIPPED(5),
        UNSTABLE(4);

        private final Integer _priority;

        public Integer getPriority() {
            return this._priority;
        }

        private Status(Integer priority) {
            this._priority = priority;
        }
    }
}

