/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;

public abstract class BasePortalReleaseJob
extends BaseJob
implements PortalTestClassJob,
TestSuiteJob {
    private PortalGitWorkingDirectory _portalGitWorkingDirectory;
    private final String _testSuiteName;
    private final String _upstreamBranchName;

    @Override
    public Set<String> getDistTypes() {
        return Collections.emptySet();
    }

    @Override
    public List<String> getJobPropertyOptions() {
        List<String> jobPropertyOptions = super.getJobPropertyOptions();
        jobPropertyOptions.add(this._upstreamBranchName);
        jobPropertyOptions.removeAll(Collections.singleton(null));
        return jobPropertyOptions;
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("test_suite_name", (Object)this._testSuiteName);
        this.jsonObject.put("upstream_branch_name", (Object)this._upstreamBranchName);
        return this.jsonObject;
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this._portalGitWorkingDirectory;
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    protected BasePortalReleaseJob(Job.BuildProfile buildProfile, String jobName, PortalGitWorkingDirectory portalGitWorkingDirectory, String testSuiteName, String upstreamBranchName) {
        super(buildProfile, jobName);
        this._testSuiteName = testSuiteName;
        this._upstreamBranchName = upstreamBranchName;
        this._initialize(portalGitWorkingDirectory);
    }

    protected BasePortalReleaseJob(JSONObject jsonObject) {
        super(jsonObject);
        this._testSuiteName = jsonObject.getString("test_suite_name");
        this._upstreamBranchName = jsonObject.getString("upstream_branch_name");
        this._initialize(null);
    }

    @Override
    protected Set<String> getRawBatchNames() {
        JobProperty jobProperty = this.getJobProperty("test.batch.names", false);
        this.recordJobProperty(jobProperty);
        return this.getSetFromString(jobProperty.getValue());
    }

    @Override
    protected Set<String> getRawDependentBatchNames() {
        JobProperty jobProperty = this.getJobProperty("test.batch.names.smoke", false);
        this.recordJobProperty(jobProperty);
        return this.getSetFromString(jobProperty.getValue());
    }

    private void _initialize(PortalGitWorkingDirectory portalGitWorkingDirectory) {
        this._portalGitWorkingDirectory = portalGitWorkingDirectory != null ? portalGitWorkingDirectory : GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(this._upstreamBranchName);
        this.jobPropertiesFiles.add(new File(this._portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
    }
}

