/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseGitRepository;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitCommit;
import com.liferay.jenkins.results.parser.LocalGitRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONObject;

public abstract class BaseLocalGitRepository
extends BaseGitRepository
implements LocalGitRepository {
    private static final String[] _KEYS_REQUIRED = new String[]{"directory", "directory_name", "upstream_branch_name"};
    private GitWorkingDirectory _gitWorkingDirectory;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseLocalGitRepository)) {
            return false;
        }
        BaseLocalGitRepository baseLocalGitRepository = (BaseLocalGitRepository)object;
        return Objects.equals(this.getDirectory(), baseLocalGitRepository.getDirectory()) && Objects.equals(this.getGitWorkingDirectory(), baseLocalGitRepository.getGitWorkingDirectory()) && JenkinsResultsParserUtil.isJSONObjectEqual(this.getJSONObject(), baseLocalGitRepository.getJSONObject()) && Objects.equals(this.getName(), baseLocalGitRepository.getName()) && Objects.equals(this.getUpstreamBranchName(), baseLocalGitRepository.getUpstreamBranchName());
    }

    @Override
    public File getDirectory() {
        String directoryPath = this.getString("directory");
        if (JenkinsResultsParserUtil.isWindows() && directoryPath.startsWith("/")) {
            directoryPath = "C:" + directoryPath;
        }
        return new File(directoryPath);
    }

    @Override
    public String getDirectoryName() {
        return this.getString("directory_name");
    }

    @Override
    public GitWorkingDirectory getGitWorkingDirectory() {
        if (this._gitWorkingDirectory != null) {
            return this._gitWorkingDirectory;
        }
        this._gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this.getUpstreamBranchName(), this.getDirectory(), this.getName());
        return this._gitWorkingDirectory;
    }

    @Override
    public List<LocalGitCommit> getRangeLocalGitCommits(String earliestSHA, String latestSHA) {
        ArrayList<LocalGitCommit> rangeLocalGitCommits = new ArrayList<LocalGitCommit>();
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        for (int index = 0; index < COMMITS_HISTORY_SIZE_MAX; index += COMMITS_HISTORY_GROUP_SIZE.intValue()) {
            int currentGroupSize = COMMITS_HISTORY_GROUP_SIZE;
            if (index > COMMITS_HISTORY_SIZE_MAX - COMMITS_HISTORY_GROUP_SIZE) {
                currentGroupSize = COMMITS_HISTORY_SIZE_MAX % COMMITS_HISTORY_GROUP_SIZE;
            }
            List<LocalGitCommit> localGitCommits = gitWorkingDirectory.log(index, currentGroupSize, latestSHA);
            for (LocalGitCommit localGitCommit : localGitCommits) {
                rangeLocalGitCommits.add(localGitCommit);
                if (!earliestSHA.equals(localGitCommit.getSHA())) continue;
                return rangeLocalGitCommits;
            }
        }
        return rangeLocalGitCommits;
    }

    @Override
    public String getUpstreamBranchName() {
        return this.getString("upstream_branch_name");
    }

    public int hashCode() {
        String hash = JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(this.getDirectory()), this.getName(), this.getUpstreamBranchName());
        return hash.hashCode();
    }

    protected BaseLocalGitRepository(JSONObject jsonObject) {
        super(jsonObject);
        this.validateKeys(_KEYS_REQUIRED);
    }

    protected BaseLocalGitRepository(String name, String upstreamBranchName) {
        super(name);
        if (JenkinsResultsParserUtil.isNullOrEmpty(upstreamBranchName)) {
            throw new IllegalArgumentException("Upstream branch name is null");
        }
        this._setDirectoryName(upstreamBranchName);
        this._setUpstreamBranchName(upstreamBranchName);
        File directory = new File(JenkinsResultsParserUtil.getBaseGitRepositoryDir(), this.getDirectoryName());
        if (!directory.exists()) {
            throw new IllegalArgumentException("Unable to find " + directory);
        }
        this._setDirectory(directory);
        this.validateKeys(_KEYS_REQUIRED);
    }

    private void _setDirectory(File directory) {
        this.put("directory", JenkinsResultsParserUtil.getCanonicalPath(directory));
    }

    private void _setDirectoryName(String upstreamBranchName) {
        String gitDirectoryName = JenkinsResultsParserUtil.getGitDirectoryName(this.getName(), upstreamBranchName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitDirectoryName)) {
            gitDirectoryName = this.getName();
        }
        this.put("directory_name", gitDirectoryName);
    }

    private void _setUpstreamBranchName(String upstreamBranchName) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(upstreamBranchName)) {
            throw new IllegalArgumentException("Upstream branch name is null");
        }
        this.put("upstream_branch_name", upstreamBranchName);
    }
}

