/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRef;

public abstract class BaseGitRef
implements GitRef {
    private final String _name;
    private final String _sha;

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getSHA() {
        return this._sha;
    }

    protected BaseGitRef(String name, String sha) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name is null");
        }
        if (sha == null || sha.isEmpty()) {
            throw new IllegalArgumentException("SHA is null");
        }
        if (!sha.matches("[0-9a-f]{7,40}")) {
            throw new IllegalArgumentException("SHA is invalid");
        }
        this._name = name;
        this._sha = sha;
    }
}

