/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildReport;
import com.liferay.jenkins.results.parser.DownstreamBuildReport;
import com.liferay.jenkins.results.parser.StopWatchRecord;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TestClassReport;
import com.liferay.jenkins.results.parser.TestReport;
import com.liferay.jenkins.results.parser.TestReportFactory;
import com.liferay.jenkins.results.parser.TopLevelBuildReport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseDownstreamBuildReport
extends BaseBuildReport
implements DownstreamBuildReport {
    private static final Pattern _jUnitTestNamePattern = Pattern.compile("(?<testClassName>.*Test)\\.(?<testName>test.*)");
    private final String _batchName;
    private Map<String, TestClassReport> _testClassReportsMap;
    private final TopLevelBuildReport _topLevelBuildReport;

    @Override
    public String getAxisName() {
        JSONObject buildReportJSONObject = this.getBuildReportJSONObject();
        return buildReportJSONObject.optString("axisName", null);
    }

    @Override
    public String getBatchName() {
        return this._batchName;
    }

    @Override
    public long getOverheadDuration() {
        long overheadDuration = this.getDuration() - this.getTestExecutionDuration();
        if (overheadDuration <= 0L) {
            return 0L;
        }
        return overheadDuration;
    }

    @Override
    public List<TestClassReport> getTestClassReports() {
        if (this._testClassReportsMap != null) {
            return new ArrayList<TestClassReport>(this._testClassReportsMap.values());
        }
        this._testClassReportsMap = new TreeMap<String, TestClassReport>();
        String batchName = this.getBatchName();
        for (TestReport testReport : this.getTestReports()) {
            TestClassReport testClassReport;
            Matcher matcher;
            String testClassName = testReport.getTestName();
            if ((batchName.startsWith("integration") || batchName.startsWith("modules-integration") || batchName.startsWith("modules-unit") || batchName.startsWith("unit")) && (matcher = _jUnitTestNamePattern.matcher(testClassName)).find()) {
                testClassName = matcher.group("testClassName");
            }
            if ((testClassReport = this._testClassReportsMap.get(testClassName)) == null) {
                testClassReport = TestReportFactory.newTestClassReport(this, testClassName);
                this._testClassReportsMap.put(testClassName, testClassReport);
            }
            testClassReport.addTestReport(testReport);
        }
        return new ArrayList<TestClassReport>(this._testClassReportsMap.values());
    }

    @Override
    public long getTestExecutionDuration() {
        long duration;
        StopWatchRecord stopWatchRecord;
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup != null && (stopWatchRecord = stopWatchRecordsGroup.get("test.execution.duration")) != null && (duration = stopWatchRecord.getDuration().longValue()) > 0L) {
            return duration;
        }
        long testExecutionDuration = 0L;
        for (TestReport testReport : this.getTestReports()) {
            long testDuration = testReport.getDuration();
            if (testDuration < 0L) continue;
            testExecutionDuration += testDuration;
        }
        return testExecutionDuration;
    }

    @Override
    public List<TestReport> getTestReports() {
        ArrayList<TestReport> testReports = new ArrayList<TestReport>();
        JSONObject buildReportJSONObject = this.getBuildReportJSONObject();
        JSONArray testResultsJSONArray = buildReportJSONObject.optJSONArray("testResults");
        if (testResultsJSONArray == null) {
            return testReports;
        }
        for (int i = 0; i < testResultsJSONArray.length(); ++i) {
            testReports.add(TestReportFactory.newTestReport(this, testResultsJSONArray.getJSONObject(i)));
        }
        return testReports;
    }

    @Override
    public TopLevelBuildReport getTopLevelBuildReport() {
        return this._topLevelBuildReport;
    }

    protected BaseDownstreamBuildReport(String batchName, JSONObject buildReportJSONObject, TopLevelBuildReport topLevelBuildReport) {
        super(buildReportJSONObject);
        this._batchName = batchName;
        this._topLevelBuildReport = topLevelBuildReport;
    }
}

