/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.JenkinsAPIUtil;
import com.liferay.jenkins.results.parser.JenkinsConsoleTextLoader;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.MultiPattern;
import com.liferay.jenkins.results.parser.NotificationUtil;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.ReinvokeRule;
import com.liferay.jenkins.results.parser.RemoteGitRef;
import com.liferay.jenkins.results.parser.Retryable;
import com.liferay.jenkins.results.parser.SlaveOfflineRule;
import com.liferay.jenkins.results.parser.StopWatchRecord;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestClassResultFactory;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TestResultFactory;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.URLCompareUtil;
import com.liferay.jenkins.results.parser.UpstreamFailureUtil;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceBuild;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GenericFailureMessageGenerator;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseBuild
implements Build {
    protected static final int PIXELS_WIDTH_INDENT = 35;
    protected static final int REINVOCATIONS_SIZE_MAX = 1;
    protected static final String URL_BASE_FAILURES_JOB_UPSTREAM = "https://test-1-0.liferay.com/userContent/testResults/";
    protected static final String URL_BASE_TEMP_MAP = "http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/";
    protected static final Pattern invocationURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+).*/", "buildWithParameters\\?(?<queryString>.*)"));
    protected static final Pattern jobNamePattern = Pattern.compile("(?<baseJob>[^\\(]+)\\((?<branchName>[^\\)]+)\\)");
    protected static final Pattern stopWatchPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\s*\\[stopwatch\\]\\s*\\[(?<name>[^:]+): ", "((?<minutes>\\d+):)?((?<seconds>\\d+))?\\.", "(?<milliseconds>\\d+) sec\\]"));
    protected static final Pattern stopWatchStartTimestampPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\s*\\[echo\\] (?<name>.*)\\.start\\.timestamp: ", "(?<timestamp>.*)$"));
    protected static final SimpleDateFormat stopWatchTimestampSimpleDateFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss:SSS z");
    protected List<Integer> badBuildNumbers = new ArrayList<Integer>();
    protected String branchName;
    protected int consoleReadCursor;
    protected List<Build> downstreamBuilds = new ArrayList<Build>();
    protected boolean fromArchive;
    protected boolean fromCompletedBuild;
    protected String gitRepositoryName;
    protected Long invokedTime;
    protected String jobName;
    protected List<ReinvokeRule> reinvokeRules = ReinvokeRule.getReinvokeRules();
    protected String result;
    protected List<SlaveOfflineRule> slaveOfflineRules = SlaveOfflineRule.getSlaveOfflineRules();
    protected Long startTime;
    protected Map<String, Long> statusDurations = new HashMap<String, Long>();
    protected long statusModifiedTime;
    protected Element upstreamJobFailureMessageElement;
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new GenericFailureMessageGenerator()};
    private static final String _NAME_JENKINS_REPORT_TIME_ZONE;
    private static final int _PIXELS_WIDTH_EXPANDER = 20;
    private static final String[] _TOKENS_HIGH_PRIORITY_CONTENT;
    private static final MultiPattern _buildURLMultiPattern;
    private static final Pattern _testrayAttachmentURLPattern;
    private static final Pattern _testrayS3ObjectURLPattern;
    private String _archiveName = "archive";
    private File _archiveRootDir = new File(JenkinsResultsParserUtil.urlDependenciesFile.substring("file:".length()));
    private final Map<String, Build.BranchInformation> _branchInformationMap = new HashMap<String, Build.BranchInformation>();
    private String _buildDescription;
    private Boolean _buildDurationsEnabled;
    private int _buildNumber = -1;
    private JenkinsConsoleTextLoader _jenkinsConsoleTextLoader;
    private JenkinsMaster _jenkinsMaster;
    private JenkinsSlave _jenkinsSlave;
    private Job _job;
    private Map<String, String> _parameters = new HashMap<String, String>();
    private final Build _parentBuild;
    private String _previousStatus;
    private int _reinvocationCount;
    private String _status;
    private StopWatchRecordsGroup _stopWatchRecordsGroup;
    private Map<String, TestClassResult> _testClassResults;
    private List<URL> _testrayAttachmentURLs;
    private List<URL> _testrayS3AttachmentURLs;
    private Boolean _uniqueFailure;

    @Override
    public void addDownstreamBuilds(Map<String, String> urlAxisNames) {
        final BaseBuild thisBuild = this;
        ArrayList callables = new ArrayList(urlAxisNames.size());
        for (Map.Entry<String, String> urlEntry : urlAxisNames.entrySet()) {
            String url = urlEntry.getKey();
            try {
                url = JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.decode(url));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException("Unable to decode " + url, unsupportedEncodingException);
            }
            if (this.hasBuildURL(url)) continue;
            final String axisName = urlEntry.getValue();
            final String buildURL = url;
            Callable<Build> callable = new Callable<Build>(){

                @Override
                public Build call() {
                    try {
                        return BuildFactory.newBuild(buildURL, thisBuild, axisName);
                    }
                    catch (RuntimeException runtimeException) {
                        if (!BaseBuild.this.isFromArchive()) {
                            NotificationUtil.sendSlackNotification(runtimeException.getMessage() + "\nBuild URL: " + buildURL, "ci-notifications", "Build Object Failure");
                        }
                        return null;
                    }
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, true, this.getExecutorService());
        this.downstreamBuilds.addAll(parallelExecutor.execute());
    }

    @Override
    public void addDownstreamBuilds(String ... urls) {
        HashMap<String, String> urlAxisNames = new HashMap<String, String>();
        for (String url : urls) {
            urlAxisNames.put(url, null);
        }
        this.addDownstreamBuilds(urlAxisNames);
    }

    public abstract void addTimelineData(TimelineData var1);

    @Override
    public void archive() {
        this.archive(this.getArchiveName());
    }

    @Override
    public void archive(String archiveName) {
        this.setArchiveName(archiveName);
        if (this.fromArchive) {
            return;
        }
        File archiveDir = new File(this.getArchiveRootDir(), this.getArchivePath());
        if (!archiveDir.exists()) {
            archiveDir.mkdirs();
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(this.getArchiveCallables(), this.getExecutorService());
        parallelExecutor.execute();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseBuild)) {
            return false;
        }
        BaseBuild baseBuild = (BaseBuild)object;
        return Objects.equals(this.getBuildURL(), baseBuild.getBuildURL());
    }

    @Override
    public List<Callable<Object>> getArchiveCallables() {
        ArrayList<Callable<Object>> archiveCallables = new ArrayList<Callable<Object>>();
        archiveCallables.add(new Callable<Object>(){

            @Override
            public Object call() {
                BaseBuild.this._archiveBuildJSON();
                return null;
            }
        });
        archiveCallables.add(new Callable<Object>(){

            @Override
            public Object call() {
                BaseBuild.this._archiveConsoleLog();
                return null;
            }
        });
        archiveCallables.add(new Callable<Object>(){

            @Override
            public Object call() {
                BaseBuild.this._archiveMarkerFile();
                return null;
            }
        });
        archiveCallables.add(new Callable<Object>(){

            @Override
            public Object call() {
                BaseBuild.this._archiveTestReportJSON();
                return null;
            }
        });
        if (this.downstreamBuilds != null && !this.downstreamBuilds.isEmpty()) {
            for (Build downstreamBuild : this.downstreamBuilds) {
                archiveCallables.addAll(downstreamBuild.getArchiveCallables());
            }
        }
        return archiveCallables;
    }

    @Override
    public String getArchiveName() {
        if (this.getParentBuild() == null) {
            return this._archiveName;
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (this == topLevelBuild) {
            return this._archiveName;
        }
        return topLevelBuild.getArchiveName();
    }

    @Override
    public String getArchivePath() {
        String archiveName = this.getArchiveName();
        StringBuilder sb = new StringBuilder(archiveName);
        if (!archiveName.endsWith("/")) {
            sb.append("/");
        }
        sb.append(this._jenkinsMaster.getName());
        sb.append("/");
        sb.append(this.getJobName());
        sb.append("/");
        sb.append(this.getBuildNumber());
        return sb.toString();
    }

    @Override
    public File getArchiveRootDir() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild == null) {
            return this._archiveRootDir;
        }
        if (this.equals(parentBuild)) {
            System.out.println("STACKOVERFLOW CATCH");
            return this._archiveRootDir;
        }
        return parentBuild.getArchiveRootDir();
    }

    @Override
    public long getAverageDelayTime() {
        if (this.getDownstreamBuildCount(null) == 0) {
            return 0L;
        }
        List<Build> allDownstreamBuilds = JenkinsResultsParserUtil.flatten(this.getDownstreamBuilds(null));
        if (allDownstreamBuilds.isEmpty()) {
            return 0L;
        }
        long totalDelayTime = 0L;
        for (Build downstreamBuild : allDownstreamBuilds) {
            totalDelayTime += downstreamBuild.getDelayTime().longValue();
        }
        return totalDelayTime / (long)allDownstreamBuilds.size();
    }

    @Override
    public List<String> getBadBuildURLs() {
        ArrayList<String> badBuildURLs = new ArrayList<String>();
        String jobURL = this.getJobURL();
        for (Integer badBuildNumber : this.badBuildNumbers) {
            badBuildURLs.add(JenkinsResultsParserUtil.combine(jobURL, "/", String.valueOf(badBuildNumber), "/"));
        }
        return badBuildURLs;
    }

    @Override
    public String getBaseGitRepositoryName() {
        if (this.gitRepositoryName == null) {
            Properties buildProperties = null;
            try {
                buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to get build.properties", ioException);
            }
            TopLevelBuild topLevelBuild = this.getTopLevelBuild();
            this.gitRepositoryName = topLevelBuild.getParameterValue("REPOSITORY_NAME");
            if (this.gitRepositoryName != null && !this.gitRepositoryName.isEmpty()) {
                return this.gitRepositoryName;
            }
            this.gitRepositoryName = buildProperties.getProperty(JenkinsResultsParserUtil.combine("repository[", topLevelBuild.getJobName(), "]"));
            if (this.gitRepositoryName == null) {
                throw new RuntimeException("Unable to get Git repository name for job " + topLevelBuild.getJobName());
            }
        }
        return this.gitRepositoryName;
    }

    @Override
    public String getBaseGitRepositorySHA(String gitRepositoryName) {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild instanceof WorkspaceBuild && !this.fromArchive) {
            WorkspaceBuild workspaceBuild = (WorkspaceBuild)((Object)topLevelBuild);
            Workspace workspace = workspaceBuild.getWorkspace();
            WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
            return workspaceGitRepository.getBaseBranchSHA();
        }
        if (gitRepositoryName.equals("liferay-jenkins-ee")) {
            Map<String, String> topLevelBuildStartPropertiesTempMap = topLevelBuild.getStartPropertiesTempMap();
            return topLevelBuildStartPropertiesTempMap.get("JENKINS_GITHUB_UPSTREAM_BRANCH_SHA");
        }
        Map<String, String> gitRepositoryGitDetailsTempMap = topLevelBuild.getBaseGitRepositoryDetailsTempMap();
        return gitRepositoryGitDetailsTempMap.get("github.upstream.branch.sha");
    }

    @Override
    public String getBranchName() {
        return this.branchName;
    }

    @Override
    public String getBuildDescription() {
        if (this._buildDescription == null && this.getBuildURL() != null) {
            JSONObject descriptionJSONObject = this.getBuildJSONObject("description");
            String description = descriptionJSONObject.optString("description");
            if (description.equals("")) {
                description = null;
            }
            this._buildDescription = description;
        }
        return this._buildDescription;
    }

    @Override
    public String getBuildDirPath() {
        StringBuilder sb = new StringBuilder();
        if (JenkinsResultsParserUtil.isWindows()) {
            sb.append("C:");
        }
        sb.append("/tmp/jenkins/");
        JenkinsMaster jenkinsMaster = this.getJenkinsMaster();
        sb.append(jenkinsMaster.getName());
        sb.append("/");
        sb.append(this.getJobName());
        if (this instanceof AxisBuild) {
            sb.append("/");
            AxisBuild axisBuild = (AxisBuild)this;
            sb.append(axisBuild.getAxisNumber());
        }
        sb.append("/");
        sb.append(this.getBuildNumber());
        return sb.toString();
    }

    @Override
    public JSONObject getBuildJSONObject() {
        String urlSuffix = "api/json";
        if (this.archiveFileExists(urlSuffix)) {
            return new JSONObject(this.getArchiveFileContent(urlSuffix));
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(this.getBuildURL() + "api/json"), false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build JSON object", ioException);
        }
    }

    @Override
    public int getBuildNumber() {
        return this._buildNumber;
    }

    @Override
    public Job.BuildProfile getBuildProfile() {
        String buildProfile = this.getParameterValue("TEST_PORTAL_BUILD_PROFILE");
        if (JenkinsResultsParserUtil.isNullOrEmpty(buildProfile)) {
            buildProfile = System.getenv("TEST_PORTAL_BUILD_PROFILE");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(buildProfile)) {
            if (buildProfile.equals("dxp")) {
                return Job.BuildProfile.DXP;
            }
            return Job.BuildProfile.PORTAL;
        }
        String branchName = this.getBranchName();
        if (!branchName.equals("master") && !branchName.startsWith("ee-")) {
            return Job.BuildProfile.DXP;
        }
        return Job.BuildProfile.PORTAL;
    }

    @Override
    public JSONObject getBuildResultsJSONObject(String[] buildResults, String[] testStatuses, String[] dataTypes) {
        List<String> dataTypesList;
        List<String> buildResultsList;
        JSONObject buildResultsJSONObject = new JSONObject();
        if (buildResults != null && !(buildResultsList = Arrays.asList(buildResults)).contains(this.getResult())) {
            return buildResultsJSONObject;
        }
        List<Object> testResults = new ArrayList();
        if (testStatuses == null) {
            testResults = this.getTestResults(null);
        } else {
            for (String string : testStatuses) {
                try {
                    testResults.addAll(this.getTestResults(string));
                }
                catch (RuntimeException runtimeException) {
                    System.out.println(runtimeException.getMessage());
                }
            }
        }
        if (dataTypes == null) {
            dataTypes = new String[]{"name", "status"};
        }
        if ((dataTypesList = Arrays.asList(dataTypes)).contains("buildResults") && this instanceof BatchBuild) {
            JSONArray buildResultsJSONArray = new JSONArray();
            for (Build build : this.getDownstreamBuilds(null)) {
                JSONObject buildResultJSONObject = new JSONObject();
                String axisName = null;
                if (build instanceof AxisBuild) {
                    AxisBuild axisBuild = (AxisBuild)build;
                    axisName = axisBuild.getAxisName();
                } else if (build instanceof DownstreamBuild) {
                    DownstreamBuild downstreamBuild = (DownstreamBuild)build;
                    axisName = downstreamBuild.getAxisName();
                }
                if (!JenkinsResultsParserUtil.isNullOrEmpty(axisName)) {
                    buildResultJSONObject.put("axisName", (Object)axisName);
                }
                if (dataTypesList.contains("buildURL")) {
                    buildResultJSONObject.put("buildURL", (Object)build.getBuildURL());
                }
                if (dataTypesList.contains("duration")) {
                    buildResultJSONObject.put("duration", build.getDuration());
                }
                buildResultJSONObject.put("result", (Object)build.getResult());
                if (dataTypesList.contains("stopWatchRecords")) {
                    JSONArray jsonArray;
                    StopWatchRecordsGroup stopWatchRecordsGroup = null;
                    if (build instanceof AxisBuild) {
                        AxisBuild axisBuild = (AxisBuild)build;
                        stopWatchRecordsGroup = axisBuild.getStopWatchRecordsGroup();
                    } else if (build instanceof DownstreamBuild) {
                        DownstreamBuild downstreamBuild = (DownstreamBuild)build;
                        stopWatchRecordsGroup = downstreamBuild.getStopWatchRecordsGroup();
                    }
                    if (stopWatchRecordsGroup != null && (jsonArray = stopWatchRecordsGroup.getJSONArray()).length() > 0) {
                        buildResultJSONObject.put("stopWatchRecords", (Object)jsonArray);
                    }
                }
                buildResultsJSONArray.put((Object)buildResultJSONObject);
            }
            buildResultsJSONObject.put("buildResults", (Object)buildResultsJSONArray);
        } else if (dataTypesList.contains("buildResults") && this instanceof DownstreamBuild) {
            JSONArray jSONArray;
            StopWatchRecordsGroup stopWatchRecordsGroup;
            DownstreamBuild downstreamBuild = (DownstreamBuild)this;
            buildResultsJSONObject.put("axisName", (Object)downstreamBuild.getAxisName());
            if (dataTypesList.contains("buildURL")) {
                buildResultsJSONObject.put("buildURL", (Object)this.getBuildURL());
            }
            if (dataTypesList.contains("duration")) {
                buildResultsJSONObject.put("duration", this.getDuration());
            }
            buildResultsJSONObject.put("result", (Object)this.getResult());
            if (dataTypesList.contains("stopWatchRecords") && (stopWatchRecordsGroup = downstreamBuild.getStopWatchRecordsGroup()) != null && (jSONArray = stopWatchRecordsGroup.getJSONArray()).length() > 0) {
                buildResultsJSONObject.put("stopWatchRecords", (Object)jSONArray);
            }
        }
        if (dataTypesList.contains("testResults")) {
            JSONArray testResultsJSONArray = new JSONArray();
            for (TestResult testResult : testResults) {
                JSONObject testResultJSONObject = new JSONObject();
                if (dataTypesList.contains("buildURL")) {
                    Build build = testResult.getBuild();
                    testResultJSONObject.put("buildURL", (Object)build.getBuildURL());
                }
                if (dataTypesList.contains("duration")) {
                    testResultJSONObject.put("duration", testResult.getDuration());
                }
                if (dataTypesList.contains("errorDetails")) {
                    String errorDetails = testResult.getErrorDetails();
                    if (errorDetails != null) {
                        if (errorDetails.contains("\n")) {
                            int index = errorDetails.indexOf("\n");
                            errorDetails = errorDetails.substring(0, index);
                        }
                        if (errorDetails.length() > 200) {
                            errorDetails = errorDetails.substring(0, 200);
                        }
                    }
                    testResultJSONObject.put("errorDetails", (Object)errorDetails);
                }
                if (dataTypesList.contains("name")) {
                    testResultJSONObject.put("name", (Object)testResult.getDisplayName());
                }
                if (dataTypesList.contains("status")) {
                    testResultJSONObject.put("status", (Object)testResult.getStatus());
                }
                testResultsJSONArray.put((Object)testResultJSONObject);
            }
            buildResultsJSONObject.put("testResults", (Object)testResultsJSONArray);
        }
        buildResultsJSONObject.put("jobVariant", (Object)this.getJobVariant());
        buildResultsJSONObject.put("result", (Object)this.getResult());
        return buildResultsJSONObject;
    }

    @Override
    public String getBuildURL() {
        String jobURL = this.getJobURL();
        if (jobURL == null || this._buildNumber == -1) {
            return null;
        }
        if (this.fromArchive) {
            return jobURL + "/" + this._buildNumber + "/";
        }
        try {
            jobURL = JenkinsResultsParserUtil.decode(jobURL);
            return JenkinsResultsParserUtil.encode(jobURL + "/" + this._buildNumber + "/");
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new RuntimeException("Unable to encode build URL", exception);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to decode job URL " + jobURL, unsupportedEncodingException);
        }
    }

    @Override
    public String getBuildURLRegex() {
        StringBuffer sb = new StringBuffer();
        sb.append("http[s]*:\\/\\/");
        sb.append(JenkinsResultsParserUtil.getRegexLiteral(this._jenkinsMaster.getName()));
        sb.append("[^\\/]*");
        sb.append("[\\/]+job[\\/]+");
        String jobNameRegexLiteral = JenkinsResultsParserUtil.getRegexLiteral(this.getJobName());
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\(", "(\\(|%28)");
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\)", "(\\)|%29)");
        sb.append(jobNameRegexLiteral);
        sb.append("[\\/]+");
        sb.append(this.getBuildNumber());
        sb.append("[\\/]*");
        return sb.toString();
    }

    @Override
    public String getConsoleText() {
        String urlSuffix = "consoleText";
        if (this.archiveFileExists(urlSuffix)) {
            return this.getArchiveFileContent(urlSuffix);
        }
        String buildURL = this.getBuildURL();
        if (buildURL == null) {
            return "";
        }
        if (this._jenkinsConsoleTextLoader == null) {
            this._jenkinsConsoleTextLoader = new JenkinsConsoleTextLoader(this.getBuildURL());
        }
        return this._jenkinsConsoleTextLoader.getConsoleText();
    }

    @Override
    public Long getDelayTime() {
        Long invokedTime;
        Long startTime = this.getStartTime();
        long currentTime = JenkinsResultsParserUtil.getCurrentTimeMillis();
        if (startTime == null) {
            startTime = currentTime;
        }
        if ((invokedTime = this.getInvokedTime()) == null) {
            invokedTime = currentTime;
        }
        return startTime - invokedTime;
    }

    @Override
    public int getDepth() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild == null) {
            return 0;
        }
        return parentBuild.getDepth() + 1;
    }

    @Override
    public String getDisplayName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJobName());
        String jobVariant = this.getParameterValue("JOB_VARIANT");
        if (jobVariant != null && !jobVariant.isEmpty()) {
            sb.append("/");
            sb.append(jobVariant);
        }
        return sb.toString();
    }

    @Override
    public int getDownstreamBuildCount(String status) {
        return this.getDownstreamBuildCount(null, status);
    }

    @Override
    public int getDownstreamBuildCount(String result, String status) {
        List<Build> downstreamBuilds = this.getDownstreamBuilds(result, status);
        return downstreamBuilds.size();
    }

    @Override
    public List<Build> getDownstreamBuilds(String status) {
        return this.getDownstreamBuilds(null, status);
    }

    @Override
    public List<Build> getDownstreamBuilds(String result, String status) {
        List<Build> filteredDownstreamBuilds = Collections.synchronizedList(new ArrayList());
        if (result == null && status == null) {
            filteredDownstreamBuilds.addAll(this.downstreamBuilds);
            return filteredDownstreamBuilds;
        }
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (status != null && !status.equals(downstreamBuild.getStatus()) || result != null && !result.equals(downstreamBuild.getResult())) continue;
            filteredDownstreamBuilds.add(downstreamBuild);
        }
        return filteredDownstreamBuilds;
    }

    @Override
    public long getDuration() {
        JSONObject buildJSONObject = this.getBuildJSONObject("duration,timestamp");
        if (buildJSONObject == null) {
            return 0L;
        }
        long duration = buildJSONObject.getLong("duration");
        if (duration == 0L) {
            long timestamp = buildJSONObject.getLong("timestamp");
            duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - timestamp;
        }
        return duration;
    }

    @Override
    public String getFailureMessage() {
        Element failureMessageElement = this.getFailureMessageElement();
        if (failureMessageElement == null) {
            return null;
        }
        Element codeElement = failureMessageElement.element("code");
        if (codeElement == null) {
            return null;
        }
        return codeElement.getText();
    }

    @Override
    public Element getGitHubMessageBuildAnchorElement() {
        this.getResult();
        int i = 0;
        String result = this.getResult();
        while (result == null) {
            if (i == 20) {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to create build anchor element. The process ", "timed out while waiting for a build result for ", this.getBuildURL(), "."));
            }
            JenkinsResultsParserUtil.sleep(30000L);
            result = this.getResult();
            ++i;
        }
        if (result.equals("SUCCESS")) {
            return Dom4JUtil.getNewAnchorElement(this.getBuildURL(), this.getDisplayName());
        }
        return Dom4JUtil.getNewAnchorElement(this.getBuildURL(), null, Dom4JUtil.getNewElement("strike", null, this.getDisplayName()));
    }

    @Override
    public Element getGitHubMessageElement() {
        return this.getGitHubMessageElement(false);
    }

    public Element getGitHubMessageElement(boolean showCommonFailuresCount) {
        String status = this.getStatus();
        if (!status.equals("completed") && this.getParentBuild() != null) {
            return null;
        }
        String result = this.getResult();
        if (result.equals("SUCCESS")) {
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div");
        Dom4JUtil.addToElement(messageElement, Dom4JUtil.getNewElement("h5", null, Dom4JUtil.getNewAnchorElement(this.getBuildURL(), this.getDisplayName())));
        if (showCommonFailuresCount) {
            Dom4JUtil.addToElement(messageElement, this.getGitHubMessageJobResultsElement(showCommonFailuresCount));
        } else {
            Dom4JUtil.addToElement(messageElement, this.getGitHubMessageJobResultsElement());
        }
        if (result.equals("ABORTED") && this.getDownstreamBuildCount(null) == 0) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build was aborted"));
            return messageElement;
        }
        Element failureMessageElement = this.getFailureMessageElement();
        if (failureMessageElement != null) {
            messageElement.add(failureMessageElement);
        }
        return messageElement;
    }

    @Override
    public Element getGitHubMessageUpstreamJobFailureElement() {
        return this.upstreamJobFailureMessageElement;
    }

    @Override
    public Map<String, String> getInjectedEnvironmentVariablesMap() throws IOException {
        String localBuildURL = JenkinsResultsParserUtil.getLocalURL(this.getBuildURL());
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(localBuildURL + "/injectedEnvVars/api/json", false);
        JSONObject envMapJSONObject = jsonObject.getJSONObject("envMap");
        Set envMapJSONObjectKeySet = envMapJSONObject.keySet();
        HashMap<String, String> injectedEnvironmentVariablesMap = new HashMap<String, String>();
        for (String key : envMapJSONObjectKeySet) {
            injectedEnvironmentVariablesMap.put(key, envMapJSONObject.getString(key));
        }
        return injectedEnvironmentVariablesMap;
    }

    @Override
    public String getInvocationURL() {
        String jobURL = this.getJobURL();
        if (jobURL == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(jobURL);
        sb.append("/buildWithParameters?");
        HashMap<String, String> parameters = new HashMap<String, String>(this.getParameters());
        try {
            parameters.put("token", JenkinsResultsParserUtil.getBuildProperty("jenkins.authentication.token"));
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get Jenkins authentication token", ioException);
        }
        for (Map.Entry parameter : parameters.entrySet()) {
            sb.append((String)parameter.getKey());
            sb.append("=");
            sb.append((String)parameter.getValue());
            sb.append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return JenkinsResultsParserUtil.fixURL(sb.toString());
    }

    @Override
    public Long getInvokedTime() {
        if (this.invokedTime != null) {
            return this.invokedTime;
        }
        this.invokedTime = this.getStartTime();
        return this.invokedTime;
    }

    @Override
    public JenkinsMaster getJenkinsMaster() {
        return this._jenkinsMaster;
    }

    @Override
    public JenkinsSlave getJenkinsSlave() {
        if (this._jenkinsSlave != null) {
            return this._jenkinsSlave;
        }
        String buildURL = this.getBuildURL();
        if (buildURL == null || this._jenkinsMaster == null) {
            return null;
        }
        JSONObject builtOnJSONObject = this.getBuildJSONObject("builtOn");
        String slaveName = builtOnJSONObject.optString("builtOn");
        if (slaveName.equals("")) {
            slaveName = "master";
        }
        this._jenkinsSlave = this._jenkinsMaster.getJenkinsSlave(slaveName);
        return this._jenkinsSlave;
    }

    @Override
    public Job getJob() {
        if (this._job != null) {
            return this._job;
        }
        this._job = JobFactory.newJob(this);
        return this._job;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getJobURL() {
        if (this._jenkinsMaster == null || this.jobName == null) {
            return null;
        }
        if (this.fromArchive) {
            return JenkinsResultsParserUtil.combine("${dependencies.url}", "/", this.getArchiveName(), "/", this._jenkinsMaster.getName(), "/", this.jobName);
        }
        String jobURL = JenkinsResultsParserUtil.combine("https://", this._jenkinsMaster.getName(), ".liferay.com/job/", this.jobName);
        try {
            return JenkinsResultsParserUtil.encode(jobURL);
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new RuntimeException("Unable to encode job URL " + jobURL, exception);
        }
    }

    @Override
    public String getJobVariant() {
        String jobVariant = this.getParameterValue("JOB_VARIANT");
        if (jobVariant == null || jobVariant.isEmpty()) {
            jobVariant = this.getParameterValue("JENKINS_JOB_VARIANT");
        }
        return jobVariant;
    }

    @Override
    public int getJobVariantsDownstreamBuildCount(List<String> jobVariants, String result, String status) {
        List<Build> jobVariantsDownstreamBuilds = this.getJobVariantsDownstreamBuilds(jobVariants, result, status);
        return jobVariantsDownstreamBuilds.size();
    }

    @Override
    public List<Build> getJobVariantsDownstreamBuilds(Iterable<String> jobVariants, String result, String status) {
        ArrayList<Build> jobVariantsDownstreamBuilds = new ArrayList<Build>();
        List<Build> downstreamBuilds = this.getDownstreamBuilds(result, status);
        block0: for (Build downstreamBuild : downstreamBuilds) {
            String downstreamBuildJobVariant = downstreamBuild.getJobVariant();
            for (String jobVariant : jobVariants) {
                if (!downstreamBuildJobVariant.startsWith(jobVariant)) continue;
                jobVariantsDownstreamBuilds.add(downstreamBuild);
                continue block0;
            }
        }
        return jobVariantsDownstreamBuilds;
    }

    @Override
    public Long getLatestStartTimestamp() {
        Long latestStartTimestamp = this.getStartTime();
        if (latestStartTimestamp == null) {
            return null;
        }
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            Long downstreamBuildLatestStartTimestamp = downstreamBuild.getLatestStartTimestamp();
            if (downstreamBuildLatestStartTimestamp == null) {
                return null;
            }
            latestStartTimestamp = Math.max(latestStartTimestamp, downstreamBuild.getLatestStartTimestamp());
        }
        return latestStartTimestamp;
    }

    @Override
    public Build getLongestDelayedDownstreamBuild() {
        List<Build> downstreamBuilds = this.getDownstreamBuilds(null);
        if (downstreamBuilds.isEmpty()) {
            return this;
        }
        Build longestDelayedBuild = downstreamBuilds.get(0);
        for (Build downstreamBuild : downstreamBuilds) {
            Build longestDelayedDownstreamBuild = downstreamBuild.getLongestDelayedDownstreamBuild();
            if (downstreamBuild.getDelayTime() > longestDelayedDownstreamBuild.getDelayTime()) {
                longestDelayedDownstreamBuild = downstreamBuild;
            }
            if (longestDelayedDownstreamBuild.getDelayTime() <= longestDelayedBuild.getDelayTime()) continue;
            longestDelayedBuild = longestDelayedDownstreamBuild;
        }
        return longestDelayedBuild;
    }

    @Override
    public Build getLongestRunningDownstreamBuild() {
        Build longestRunningDownstreamBuild = null;
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            if (longestRunningDownstreamBuild != null && downstreamBuild.getDuration() <= longestRunningDownstreamBuild.getDuration()) continue;
            longestRunningDownstreamBuild = downstreamBuild;
        }
        return longestRunningDownstreamBuild;
    }

    @Override
    public TestResult getLongestRunningTest() {
        List<TestResult> testResults = this.getTestResults(null);
        long longestTestDuration = 0L;
        TestResult longestRunningTest = null;
        for (TestResult testResult : testResults) {
            long testDuration = testResult.getDuration();
            if (testDuration <= longestTestDuration) continue;
            longestTestDuration = testDuration;
            longestRunningTest = testResult;
        }
        return longestRunningTest;
    }

    @Override
    public Map<String, String> getMetricLabels() {
        if (this._parentBuild != null) {
            return this._parentBuild.getMetricLabels();
        }
        return new TreeMap<String, String>();
    }

    @Override
    public List<Build> getModifiedDownstreamBuilds() {
        return this.getModifiedDownstreamBuildsByStatus(null);
    }

    @Override
    public List<Build> getModifiedDownstreamBuildsByStatus(String status) {
        ArrayList<Build> modifiedDownstreamBuilds = new ArrayList<Build>();
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (!downstreamBuild.isBuildModified() && !downstreamBuild.hasModifiedDownstreamBuilds()) continue;
            modifiedDownstreamBuilds.add(downstreamBuild);
        }
        if (status != null) {
            modifiedDownstreamBuilds.retainAll(this.getDownstreamBuilds(status));
        }
        return modifiedDownstreamBuilds;
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this._parameters);
    }

    @Override
    public String getParameterValue(String name) {
        return this._parameters.get(name);
    }

    @Override
    public Build getParentBuild() {
        return this._parentBuild;
    }

    public long getQueuingDuration() {
        JSONObject buildJSONObject = this.getBuildJSONObject("actions[queuingDurationMillis]");
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject;
            Object actions = actionsJSONArray.get(i);
            if (actions == JSONObject.NULL || !(actionJSONObject = actionsJSONArray.getJSONObject(i)).has("queuingDurationMillis")) continue;
            return actionJSONObject.getLong("queuingDurationMillis");
        }
        return 0L;
    }

    @Override
    public String getResult() {
        if (this.result == null && this.getBuildURL() != null) {
            JSONObject buildJSONObject = this.getBuildJSONObject("duration,result");
            long duration = buildJSONObject.optLong("duration");
            String result = buildJSONObject.optString("result");
            if (duration == 0L || JenkinsResultsParserUtil.isNullOrEmpty(result)) {
                result = null;
            }
            this.setResult(result);
        }
        return this.result;
    }

    @Override
    public Map<String, String> getStartPropertiesTempMap() {
        return this.getTempMap("start.properties");
    }

    @Override
    public Long getStartTime() {
        if (this.startTime != null) {
            return this.startTime;
        }
        JSONObject buildJSONObject = this.getBuildJSONObject("timestamp");
        if (buildJSONObject == null) {
            return null;
        }
        long timestamp = buildJSONObject.getLong("timestamp");
        if (timestamp != 0L) {
            this.startTime = timestamp;
        }
        return this.startTime;
    }

    @Override
    public String getStatus() {
        if (this._status == null || !this._status.equals("completed")) {
            this.getResult();
        }
        return this._status;
    }

    @Override
    public long getStatusAge() {
        return JenkinsResultsParserUtil.getCurrentTimeMillis() - this.statusModifiedTime;
    }

    @Override
    public long getStatusDuration(String status) {
        if (this.statusDurations.containsKey(status)) {
            return this.statusDurations.get(status);
        }
        return 0L;
    }

    @Override
    public String getStatusSummary() {
        return JenkinsResultsParserUtil.combine(String.valueOf(this.getDownstreamBuildCount("starting")), " Starting  ", "/ ", String.valueOf(this.getDownstreamBuildCount("missing")), " Missing  ", "/ ", String.valueOf(this.getDownstreamBuildCount("queued")), " Queued  ", "/ ", String.valueOf(this.getDownstreamBuildCount("running")), " Running  ", "/ ", String.valueOf(this.getDownstreamBuildCount("completed")), " Completed  ", "/ ", String.valueOf(this.getDownstreamBuildCount(null)), " Total ");
    }

    @Override
    public Map<String, String> getStopPropertiesTempMap() {
        return this.getTempMap("stop.properties");
    }

    @Override
    public StopWatchRecordsGroup getStopWatchRecordsGroup() {
        String status = this.getStatus();
        if (status == null || !status.equals("completed")) {
            this._stopWatchRecordsGroup = null;
            return new StopWatchRecordsGroup();
        }
        if (this._stopWatchRecordsGroup != null) {
            return this._stopWatchRecordsGroup;
        }
        this._stopWatchRecordsGroup = new StopWatchRecordsGroup();
        String consoleText = this.getConsoleText();
        for (String line : consoleText.split("\n")) {
            String stopWatchName;
            StopWatchRecord stopWatchRecord;
            String minutes;
            Matcher matcher = stopWatchStartTimestampPattern.matcher(line);
            if (matcher.matches()) {
                Date timestamp = null;
                try {
                    timestamp = stopWatchTimestampSimpleDateFormat.parse(matcher.group("timestamp"));
                }
                catch (ParseException parseException) {
                    throw new RuntimeException("Unable to parse timestamp in " + line, parseException);
                }
                String stopWatchName2 = matcher.group("name");
                this._stopWatchRecordsGroup.add(new StopWatchRecord(stopWatchName2, timestamp.getTime()));
                continue;
            }
            matcher = stopWatchPattern.matcher(line);
            if (!matcher.matches()) continue;
            long duration = Long.parseLong(matcher.group("milliseconds"));
            String seconds = matcher.group("seconds");
            if (seconds != null) {
                duration += Long.parseLong(seconds) * 1000L;
            }
            if ((minutes = matcher.group("minutes")) != null) {
                duration += Long.parseLong(minutes) * 60L * 1000L;
            }
            if ((stopWatchRecord = this._stopWatchRecordsGroup.get(stopWatchName = matcher.group("name"))) == null) continue;
            stopWatchRecord.setDuration(duration);
        }
        return this._stopWatchRecordsGroup;
    }

    @Override
    public TestClassResult getTestClassResult(String testClassName) {
        if (!this.isCompleted()) {
            return null;
        }
        this._initTestClassResults();
        if (this._testClassResults == null) {
            return null;
        }
        return this._testClassResults.get(testClassName);
    }

    @Override
    public List<TestClassResult> getTestClassResults() {
        if (!this.isCompleted()) {
            return new ArrayList<TestClassResult>();
        }
        this._initTestClassResults();
        if (this._testClassResults == null) {
            return new ArrayList<TestClassResult>();
        }
        return new ArrayList<TestClassResult>(this._testClassResults.values());
    }

    @Override
    public synchronized List<URL> getTestrayAttachmentURLs() {
        if (this._testrayAttachmentURLs != null) {
            return this._testrayAttachmentURLs;
        }
        this._testrayAttachmentURLs = new ArrayList<URL>();
        String consoleText = this.getConsoleText();
        for (String line : consoleText.split("\\n")) {
            Matcher matcher = _testrayAttachmentURLPattern.matcher(line);
            if (!matcher.find()) continue;
            try {
                this._testrayAttachmentURLs.add(new URL(matcher.group("url")));
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return this._testrayAttachmentURLs;
    }

    @Override
    public synchronized List<URL> getTestrayS3AttachmentURLs() {
        if (this._testrayS3AttachmentURLs != null) {
            return this._testrayS3AttachmentURLs;
        }
        this._testrayS3AttachmentURLs = new ArrayList<URL>();
        String consoleText = this.getConsoleText();
        for (String line : consoleText.split("\\n")) {
            Matcher matcher = _testrayS3ObjectURLPattern.matcher(line);
            if (!matcher.find()) continue;
            try {
                this._testrayS3AttachmentURLs.add(new URL(matcher.group("url")));
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return this._testrayS3AttachmentURLs;
    }

    @Override
    public JSONObject getTestReportJSONObject(boolean checkCache) {
        String result = this.getResult();
        if (result == null || !result.equals("SUCCESS") && !result.equals("UNSTABLE")) {
            return null;
        }
        String urlSuffix = "testReport/api/json";
        if (this.archiveFileExists(urlSuffix)) {
            return new JSONObject(this.getArchiveFileContent(urlSuffix));
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(this.getBuildURL() + urlSuffix), checkCache);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get test report JSON object", ioException);
        }
    }

    @Override
    public List<TestResult> getTestResults() {
        if (!this.isCompleted()) {
            return new ArrayList<TestResult>();
        }
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (TestClassResult testClassResult : this.getTestClassResults()) {
            testResults.addAll(testClassResult.getTestResults());
        }
        return testResults;
    }

    public List<TestResult> getTestResults(Build build, JSONArray suitesJSONArray, String testStatus) {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (int i = 0; i < suitesJSONArray.length(); ++i) {
            JSONObject suiteJSONObject = suitesJSONArray.getJSONObject(i);
            JSONArray casesJSONArray = suiteJSONObject.getJSONArray("cases");
            for (int j = 0; j < casesJSONArray.length(); ++j) {
                TestResult testResult = TestResultFactory.newTestResult(build, casesJSONArray.getJSONObject(j));
                if (testStatus != null && !testStatus.equals(testResult.getStatus())) continue;
                testResults.add(testResult);
            }
        }
        return testResults;
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            List<TestResult> downstreamTestResults = downstreamBuild.getTestResults(testStatus);
            if (downstreamTestResults == null) continue;
            testResults.addAll(downstreamTestResults);
        }
        return testResults;
    }

    @Override
    public String getTestSuiteName() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild == null) {
            return "default";
        }
        return parentBuild.getTestSuiteName();
    }

    @Override
    public TopLevelBuild getTopLevelBuild() {
        Build topLevelBuild;
        for (topLevelBuild = this; topLevelBuild != null && !(topLevelBuild instanceof TopLevelBuild); topLevelBuild = topLevelBuild.getParentBuild()) {
        }
        return (TopLevelBuild)topLevelBuild;
    }

    @Override
    public long getTotalDuration() {
        long totalDuration = this.getDuration();
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            totalDuration += downstreamBuild.getTotalDuration();
        }
        return totalDuration;
    }

    @Override
    public int getTotalSlavesUsedCount() {
        return this.getTotalSlavesUsedCount(null, false);
    }

    @Override
    public int getTotalSlavesUsedCount(String status, boolean modifiedBuildsOnly) {
        return this.getTotalSlavesUsedCount(status, modifiedBuildsOnly, false);
    }

    @Override
    public int getTotalSlavesUsedCount(String status, boolean modifiedBuildsOnly, boolean ignoreCurrentBuild) {
        int totalSlavesUsedCount = 1;
        if (ignoreCurrentBuild || modifiedBuildsOnly && !this.isBuildModified() || status != null && !this._status.equals(status)) {
            totalSlavesUsedCount = 0;
        }
        List<Build> downstreamBuilds = modifiedBuildsOnly ? this.getModifiedDownstreamBuildsByStatus(status) : this.getDownstreamBuilds(status);
        for (Build downstreamBuild : downstreamBuilds) {
            totalSlavesUsedCount += downstreamBuild.getTotalSlavesUsedCount(status, modifiedBuildsOnly);
        }
        return totalSlavesUsedCount;
    }

    @Override
    public List<TestResult> getUniqueFailureTestResults() {
        ArrayList<TestResult> uniqueFailureTestResults = new ArrayList<TestResult>();
        for (Build downstreamBuild : this.getFailedDownstreamBuilds()) {
            uniqueFailureTestResults.addAll(downstreamBuild.getUniqueFailureTestResults());
        }
        return uniqueFailureTestResults;
    }

    @Override
    public List<TestResult> getUpstreamJobFailureTestResults() {
        ArrayList<TestResult> upstreamFailureTestResults = new ArrayList<TestResult>();
        for (Build downstreamBuild : this.getFailedDownstreamBuilds()) {
            upstreamFailureTestResults.addAll(downstreamBuild.getUpstreamJobFailureTestResults());
        }
        return upstreamFailureTestResults;
    }

    @Override
    public boolean hasBuildURL(String buildURL) {
        try {
            buildURL = JenkinsResultsParserUtil.decode(buildURL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to decode " + buildURL, unsupportedEncodingException);
        }
        buildURL = JenkinsResultsParserUtil.getLocalURL(buildURL);
        String thisBuildURL = this.getBuildURL();
        if (thisBuildURL != null) {
            thisBuildURL = JenkinsResultsParserUtil.getLocalURL(thisBuildURL);
            try {
                if (URLCompareUtil.matches(new URL(buildURL), new URL(thisBuildURL))) {
                    return true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to compare urls ", buildURL, " and ", thisBuildURL), malformedURLException);
            }
        }
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (!downstreamBuild.hasBuildURL(buildURL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGenericCIFailure() {
        for (FailureMessageGenerator failureMessageGenerator : this.getFailureMessageGenerators()) {
            Element failureMessage = failureMessageGenerator.getMessageElement(this);
            if (failureMessage == null) continue;
            return failureMessageGenerator.isGenericCIFailure();
        }
        return false;
    }

    public int hashCode() {
        String key = this.getBuildURL();
        if (key != null) {
            return key.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean hasModifiedDownstreamBuilds() {
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (!downstreamBuild.isBuildModified() && !downstreamBuild.hasModifiedDownstreamBuilds()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBuildModified() {
        return !this._status.equals(this._previousStatus);
    }

    @Override
    public boolean isCompareToUpstream() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        return topLevelBuild.isCompareToUpstream();
    }

    @Override
    public boolean isCompleted() {
        String result = this.getResult();
        String status = this.getStatus();
        return result != null && status != null;
    }

    @Override
    public boolean isFailing() {
        if (!this.isCompleted()) {
            return true;
        }
        String result = this.getResult();
        return result == null || !result.equals("SUCCESS");
    }

    @Override
    public boolean isFromArchive() {
        return this.fromArchive;
    }

    @Override
    public boolean isFromCompletedBuild() {
        Build parentBuild = this.getParentBuild();
        if (parentBuild != null) {
            return parentBuild.isFromCompletedBuild();
        }
        return this.fromCompletedBuild;
    }

    @Override
    public boolean isUniqueFailure() {
        if (this._uniqueFailure != null) {
            return this._uniqueFailure;
        }
        if (!Objects.equals(this.getStatus(), "completed")) {
            return !UpstreamFailureUtil.isBuildFailingInUpstreamJob(this);
        }
        this._uniqueFailure = !UpstreamFailureUtil.isBuildFailingInUpstreamJob(this);
        return this._uniqueFailure;
    }

    @Override
    public void reinvoke() {
        this.reinvoke(null);
    }

    @Override
    public void reinvoke(ReinvokeRule reinvokeRule) {
        if (this.badBuildNumbers.size() >= 1) {
            return;
        }
        Build parentBuild = this.getParentBuild();
        if (parentBuild == null) {
            return;
        }
        String parentBuildStatus = parentBuild.getStatus();
        if (!parentBuildStatus.equals("running") || !JenkinsResultsParserUtil.isCINode() || this.fromCompletedBuild) {
            return;
        }
        if (reinvokeRule != null && !this.fromArchive) {
            String notificationRecipients;
            String message = JenkinsResultsParserUtil.combine(reinvokeRule.getName(), " failure detected at ", this.getBuildURL(), ". This build will be reinvoked.\n\n", reinvokeRule.toString(), "\n\n");
            System.out.println(message);
            TopLevelBuild topLevelBuild = this.getTopLevelBuild();
            if (topLevelBuild != null) {
                message = JenkinsResultsParserUtil.combine(message, "Top Level Build URL: ", topLevelBuild.getBuildURL());
            }
            if ((notificationRecipients = reinvokeRule.getNotificationRecipients()) != null && !notificationRecipients.isEmpty()) {
                NotificationUtil.sendEmail(message, "jenkins", "Build Reinvoked", reinvokeRule.notificationRecipients);
            }
        }
        String invocationURL = this.getInvocationURL();
        try {
            JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(invocationURL));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        System.out.println(this.getReinvokedMessage());
        this.reset();
    }

    @Override
    public void removeDownstreamBuild(Build build) {
        this.downstreamBuilds.remove(build);
    }

    @Override
    public String replaceBuildURL(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (this.downstreamBuilds != null) {
            Iterator<Build> iterator = this.getDownstreamBuilds("complete").iterator();
            while (iterator.hasNext()) {
                Build downstreamBuild;
                Build downstreamBaseBuild = downstreamBuild = iterator.next();
                text = downstreamBaseBuild.replaceBuildURL(text);
            }
        }
        text = text.replaceAll(this.getBuildURLRegex(), Matcher.quoteReplacement(JenkinsResultsParserUtil.combine("${dependencies.url}", "/", this.getArchivePath())));
        for (Build parentBuild = this.getParentBuild(); parentBuild != null; parentBuild = parentBuild.getParentBuild()) {
            text = text.replaceAll(parentBuild.getBuildURLRegex(), Matcher.quoteReplacement("${dependencies.url}" + parentBuild.getArchivePath()));
        }
        return text;
    }

    @Override
    public void setArchiveName(String archiveName) {
        this._archiveName = archiveName;
    }

    @Override
    public void setArchiveRootDir(File archiveRootDir) {
        if (archiveRootDir == null) {
            archiveRootDir = new File(JenkinsResultsParserUtil.urlDependenciesFile.substring("file:".length()));
        }
        if (!archiveRootDir.exists()) {
            throw new IllegalArgumentException(archiveRootDir.getPath() + " does not exist");
        }
        this._archiveRootDir = archiveRootDir;
    }

    @Override
    public void setCompareToUpstream(boolean compareToUpstream) {
    }

    @Override
    public void takeSlaveOffline(SlaveOfflineRule slaveOfflineRule) {
        if (slaveOfflineRule == null || this.fromArchive) {
            return;
        }
        String pinnedMessage = "";
        if (!slaveOfflineRule.shutdown) {
            pinnedMessage = "PINNED\n";
        }
        JenkinsSlave jenkinsSlave = this.getJenkinsSlave();
        String message = JenkinsResultsParserUtil.combine(pinnedMessage, slaveOfflineRule.getName(), " failure detected at ", this.getBuildURL(), ". ", jenkinsSlave.getName(), " will be taken offline.\n\n", slaveOfflineRule.toString(), "\n\n\nOffline Slave URL: https://", this._jenkinsMaster.getName(), ".liferay.com/computer/", jenkinsSlave.getName(), "\n");
        System.out.println(message);
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild != null) {
            message = JenkinsResultsParserUtil.combine(message, "Top Level Build URL: ", topLevelBuild.getBuildURL());
        }
        jenkinsSlave.takeSlavesOffline(message);
        String notificationRecipients = slaveOfflineRule.getNotificationRecipients();
        if (notificationRecipients != null && !notificationRecipients.isEmpty()) {
            NotificationUtil.sendEmail(message, "jenkins", "Slave Offline", slaveOfflineRule.notificationRecipients);
        }
    }

    @Override
    public synchronized void update() {
        block21: {
            String status = this.getStatus();
            if (status.equals("completed") && (this.isBuildModified() || this.hasModifiedDownstreamBuilds()) || !status.equals("completed")) {
                this._previousStatus = this._status;
                try {
                    if (status.equals("missing") || status.equals("queued") || status.equals("starting")) {
                        JSONObject runningBuildJSONObject = this.getRunningBuildJSONObject();
                        if (runningBuildJSONObject != null) {
                            this.setBuildNumber(runningBuildJSONObject.getInt("number"));
                        } else {
                            JSONObject queueItemJSONObject = this.getQueueItemJSONObject();
                            if (queueItemJSONObject != null) {
                                this.setStatus("queued");
                            } else if (status.equals("queued") || status.equals("starting")) {
                                this.setStatus("missing");
                            } else {
                                if (this._reinvocationCount >= 1) {
                                    this.setResult("MISSING");
                                    return;
                                }
                                try {
                                    JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(this.getInvocationURL()));
                                }
                                catch (IOException ioException) {
                                    throw new RuntimeException(ioException);
                                }
                                this.setStatus("starting");
                                ++this._reinvocationCount;
                            }
                        }
                    }
                    if (this.downstreamBuilds == null) break block21;
                    ArrayList callables = new ArrayList();
                    for (final Build downstreamBuild : this.downstreamBuilds) {
                        Callable<Object> callable = new Callable<Object>(){

                            @Override
                            public Object call() {
                                downstreamBuild.update();
                                return null;
                            }
                        };
                        callables.add(callable);
                    }
                    ParallelExecutor parallelExecutor = new ParallelExecutor(callables, this.getExecutorService());
                    parallelExecutor.execute();
                    String result = this.getResult();
                    if (this.downstreamBuilds.size() == this.getDownstreamBuildCount("completed") && result != null) {
                        this.setResult(result);
                    }
                    this.findDownstreamBuilds();
                    if (result == null || result.equals("SUCCESS")) {
                        return;
                    }
                    JenkinsSlave jenkinsSlave = this.getJenkinsSlave();
                    if (jenkinsSlave != null) {
                        jenkinsSlave.update();
                        if (!this.fromArchive && !jenkinsSlave.isOffline()) {
                            for (SlaveOfflineRule slaveOfflineRule : this.slaveOfflineRules) {
                                if (!slaveOfflineRule.matches(this)) continue;
                                this.takeSlaveOffline(slaveOfflineRule);
                                break;
                            }
                        }
                    }
                    if (this instanceof AxisBuild || this instanceof BatchBuild || this instanceof TopLevelBuild || this.fromArchive || this.badBuildNumbers.size() >= 1) {
                        return;
                    }
                    for (ReinvokeRule reinvokeRule : this.reinvokeRules) {
                        if (!reinvokeRule.matches(this)) continue;
                        this.reinvoke(reinvokeRule);
                        break;
                    }
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        }
    }

    protected static boolean isHighPriorityBuildFailureElement(Element gitHubMessage) {
        String content = null;
        try {
            content = Dom4JUtil.format(gitHubMessage, false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to format github message", ioException);
        }
        for (String highPriorityContentToken : _TOKENS_HIGH_PRIORITY_CONTENT) {
            if (!content.contains(highPriorityContentToken)) continue;
            return true;
        }
        return false;
    }

    protected BaseBuild(String url) {
        this(url, null);
    }

    protected BaseBuild(String url, Build parentBuild) {
        this._parentBuild = parentBuild;
        if (url.contains("buildWithParameters")) {
            this.setInvocationURL(url);
        } else {
            this.setBuildURL(url);
        }
        if (!this.fromArchive && JenkinsResultsParserUtil.isCINode()) {
            TopLevelBuild topLevelBuild = this.getTopLevelBuild();
            this._archiveRootDir = topLevelBuild != null ? new File(topLevelBuild.getBuildDirPath()) : new File(this.getBuildDirPath());
        }
        if (this.fromArchive || this.fromCompletedBuild) {
            this.update();
        }
    }

    protected void addDownstreamBuildsTimelineData(TimelineData timelineData) {
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            if (!(downstreamBuild instanceof BaseBuild)) continue;
            BaseBuild downstreamBaseBuild = (BaseBuild)downstreamBuild;
            downstreamBaseBuild.addTimelineData(timelineData);
        }
    }

    protected boolean archiveFileExists(String urlSuffix) {
        File archiveFile = this.getArchiveFile(urlSuffix);
        return archiveFile.exists();
    }

    protected boolean buildDurationsEnabled() {
        if (this._buildDurationsEnabled != null) {
            return this._buildDurationsEnabled;
        }
        String buildDurationsEnabled = null;
        try {
            TopLevelBuild topLevelBuild = this.getTopLevelBuild();
            String topLevelBranchName = null;
            String topLevelJobName = null;
            String topLevelTestSuiteName = null;
            if (topLevelBuild != null) {
                topLevelBranchName = topLevelBuild.getBranchName();
                topLevelJobName = topLevelBuild.getJobName();
                topLevelTestSuiteName = topLevelBuild.getTestSuiteName();
            }
            if (Objects.equals(buildDurationsEnabled = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "build.durations.enabled", topLevelBranchName, topLevelJobName, topLevelTestSuiteName), "true")) {
                this._buildDurationsEnabled = true;
                return this._buildDurationsEnabled;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._buildDurationsEnabled = false;
        return this._buildDurationsEnabled;
    }

    protected void checkForReinvocation(String consoleText) {
        if (consoleText == null || consoleText.isEmpty()) {
            return;
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild == null || topLevelBuild.fromArchive) {
            return;
        }
        int x = consoleText.indexOf("stop-current-job:");
        if (x != -1) {
            consoleText = consoleText.substring(0, x);
        }
        if (consoleText.contains(this.getReinvokedMessage())) {
            this.reset();
            this.update();
        }
    }

    protected void extractBuildURLComponents(Matcher matcher) {
        this._buildNumber = Integer.parseInt(matcher.group("buildNumber"));
        this.setJenkinsMaster(JenkinsMaster.getInstance(matcher.group("master")));
        this.setJobName(matcher.group("jobName"));
    }

    protected void findDownstreamBuilds() {
    }

    protected Pattern getArchiveBuildURLPattern() {
        return Pattern.compile(JenkinsResultsParserUtil.combine("(", Pattern.quote("${dependencies.url}"), "|", Pattern.quote(JenkinsResultsParserUtil.urlDependenciesFile), "|", Pattern.quote(JenkinsResultsParserUtil.urlDependenciesHttp), ")/*(?<archiveName>.*)/(?<master>[^/]+)/+(?<jobName>[^/]+)", ".*/(?<buildNumber>\\d+)/?"));
    }

    protected File getArchiveFile(String urlSuffix) {
        return new File(this.getArchiveRootDir(), this.getArchivePath() + "/" + urlSuffix);
    }

    protected String getArchiveFileContent(String urlSuffix) {
        if (!this.archiveFileExists(urlSuffix)) {
            return null;
        }
        try {
            return JenkinsResultsParserUtil.read(this.getArchiveFile(urlSuffix));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected String getBaseGitRepositoryType() {
        if (this.jobName.startsWith("test-subrepository-acceptance-pullrequest")) {
            return this.getBaseGitRepositoryName();
        }
        if (this.jobName.contains("portal")) {
            return "portal";
        }
        if (this.jobName.contains("plugins")) {
            return "plugins";
        }
        return "jenkins";
    }

    protected Build.BranchInformation getBranchInformation(String repositoryType) {
        Build.BranchInformation branchInformation = this._branchInformationMap.get(repositoryType);
        if (branchInformation == null) {
            branchInformation = new DefaultBranchInformation(this, repositoryType);
            String repositoryName = branchInformation.getRepositoryName();
            if (repositoryName == null) {
                return null;
            }
            this._branchInformationMap.put(repositoryType, branchInformation);
        }
        return this._branchInformationMap.get(repositoryType);
    }

    protected JSONObject getBuildJSONObject(String tree) {
        String urlSuffix = "api/json";
        if (this.archiveFileExists(urlSuffix)) {
            return new JSONObject(this.getArchiveFileContent(urlSuffix));
        }
        return JenkinsAPIUtil.getAPIJSONObject(this.getBuildURL(), tree);
    }

    protected String getBuildMessage() {
        if (this.jobName != null) {
            String status = this.getStatus();
            StringBuilder sb = new StringBuilder();
            sb.append("Build \"");
            if (this instanceof DownstreamBuild) {
                DownstreamBuild downstreamBuild = (DownstreamBuild)this;
                sb.append(downstreamBuild.getAxisName());
            } else {
                sb.append(this.jobName);
            }
            sb.append("\"");
            if (status.equals("completed")) {
                sb.append(" completed at ");
                sb.append(this.getBuildURL());
                sb.append(". ");
                sb.append(this.getResult());
                return sb.toString();
            }
            if (status.equals("missing")) {
                sb.append(" is missing ");
                sb.append(this.getJobURL());
                sb.append(".");
                return sb.toString();
            }
            if (status.equals("queued")) {
                sb.append(" is queued at ");
                sb.append(this.getJobURL());
                sb.append(".");
                return sb.toString();
            }
            if (status.equals("running")) {
                if (!this.badBuildNumbers.isEmpty()) {
                    sb.append(" ");
                    List<String> badBuildURLs = this.getBadBuildURLs();
                    sb.append(badBuildURLs.get(this.badBuildNumbers.size() - 1));
                    sb.append(" restarted at ");
                } else {
                    sb.append(" started at ");
                }
                sb.append(this.getBuildURL());
                sb.append(".");
                return sb.toString();
            }
            if (status.equals("starting")) {
                sb.append(" invoked at ");
                sb.append(this.getJobURL());
                sb.append(".");
                return sb.toString();
            }
            throw new RuntimeException("Unknown status: " + status);
        }
        return "";
    }

    protected JSONArray getBuildsJSONArray(final int page) throws IOException {
        Retryable<JSONArray> retryable = new Retryable<JSONArray>(true, 2, 10, true){

            @Override
            public JSONArray execute() {
                String url = JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(BaseBuild.this.getJobURL(), "/api/json?tree=allBuilds[actions[", "parameters[name,type,value]],building,duration,", "number,result,url]{", String.valueOf(page * 100), ",", String.valueOf((page + 1) * 100), "}"));
                try {
                    JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(url, false);
                    return jsonObject.getJSONArray("allBuilds");
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        };
        return (JSONArray)retryable.executeWithRetries();
    }

    protected Element getBuildTimeElement() {
        return Dom4JUtil.getNewElement("p", null, "Build Time: ", JenkinsResultsParserUtil.toDurationString(this.getDuration()));
    }

    protected MultiPattern getBuildURLMultiPattern() {
        return _buildURLMultiPattern;
    }

    protected String getDiffDurationString(long diffDuration) {
        String diffDurationPrefix = "";
        if (diffDuration < 0L) {
            diffDurationPrefix = "-";
            diffDuration *= -1L;
        } else if (diffDuration > 0L) {
            diffDurationPrefix = "+";
        }
        return JenkinsResultsParserUtil.combine(diffDurationPrefix, JenkinsResultsParserUtil.toDurationString(diffDuration));
    }

    protected int getDownstreamBuildCountByResult(String result) {
        List<Build> downstreamBuilds = this.getDownstreamBuilds(null);
        if (result == null) {
            return downstreamBuilds.size();
        }
        int count = 0;
        for (Build downstreamBuild : downstreamBuilds) {
            String downstreamBuildResult = downstreamBuild.getResult();
            if (!Objects.equals(downstreamBuildResult, result)) continue;
            ++count;
        }
        return count;
    }

    protected Map<Build, Element> getDownstreamBuildMessages(List<Build> downstreamBuilds) {
        ArrayList callables = new ArrayList();
        for (final Build downstreamBuild : downstreamBuilds) {
            Callable<Element> callable = new Callable<Element>(){

                @Override
                public Element call() {
                    return downstreamBuild.getGitHubMessageElement();
                }
            };
            callables.add(callable);
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, this.getExecutorService());
        List elements = parallelExecutor.execute();
        LinkedHashMap<Build, Element> elementsMap = new LinkedHashMap<Build, Element>();
        for (int i = 0; i < elements.size(); ++i) {
            elementsMap.put(downstreamBuilds.get(i), (Element)elements.get(i));
        }
        return elementsMap;
    }

    protected ExecutorService getExecutorService() {
        return null;
    }

    protected Element getExpanderAnchorElement(String expanderName, String namespace) {
        Element expanderAnchorElement = Dom4JUtil.getNewAnchorElement("", "+ ");
        expanderAnchorElement.addAttribute("id", JenkinsResultsParserUtil.combine(namespace, "-expander-anchor-", expanderName));
        expanderAnchorElement.addAttribute("onClick", JenkinsResultsParserUtil.combine("return toggleStopWatchRecordExpander('", namespace, "', '", expanderName, "')"));
        expanderAnchorElement.addAttribute("style", "font-family: monospace, monospace; text-decoration: none");
        return expanderAnchorElement;
    }

    protected List<Build> getFailedDownstreamBuilds() {
        ArrayList<Build> failedDownstreamBuilds = new ArrayList<Build>();
        failedDownstreamBuilds.addAll(this.getDownstreamBuilds("ABORTED", null));
        failedDownstreamBuilds.addAll(this.getDownstreamBuilds("FAILURE", null));
        failedDownstreamBuilds.addAll(this.getDownstreamBuilds("UNSTABLE", null));
        return failedDownstreamBuilds;
    }

    protected Element getFailureMessageElement() {
        for (FailureMessageGenerator failureMessageGenerator : this.getFailureMessageGenerators()) {
            Element failureMessage = failureMessageGenerator.getMessageElement(this);
            if (failureMessage == null) continue;
            return failureMessage;
        }
        return null;
    }

    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    protected Element getFullConsoleClickHereElement() {
        return Dom4JUtil.getNewElement("h5", null, "For full console, click ", Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "/consoleText", "here"), ".");
    }

    protected abstract Element getGitHubMessageJobResultsElement();

    protected Element getGitHubMessageJobResultsElement(boolean showCommonFailuresCount) {
        return this.getGitHubMessageJobResultsElement();
    }

    protected List<Element> getJenkinsReportBuildDurationsElements() {
        return new ArrayList<Element>();
    }

    protected String getJenkinsReportBuildInfoCellElementTagName() {
        return "td";
    }

    protected List<Element> getJenkinsReportStopWatchRecordElements() {
        ArrayList<Element> jenkinsReportStopWatchRecordTableRowElements = new ArrayList<Element>();
        Element stopWatchRecordHeaderRowElement = Dom4JUtil.getNewElement("tr");
        stopWatchRecordHeaderRowElement.addAttribute("id", this.hashCode() + "-stop-watch-record-header");
        stopWatchRecordHeaderRowElement.addAttribute("style", "display: none");
        Element headerDataElement = Dom4JUtil.getNewElement("td", stopWatchRecordHeaderRowElement, this.getExpanderAnchorElement("stop-watch-record-header", String.valueOf(this.hashCode())), Dom4JUtil.getNewElement("u", null, "Stop Watch Record"));
        headerDataElement.addAttribute("style", JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf(this.getDepth() * 35), "px"));
        jenkinsReportStopWatchRecordTableRowElements.add(stopWatchRecordHeaderRowElement);
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (!stopWatchRecordsGroup.isEmpty()) {
            ArrayList<String> childStopWatchRecordNames = new ArrayList<String>(stopWatchRecordsGroup.size());
            for (StopWatchRecord stopWatchRecord : stopWatchRecordsGroup) {
                childStopWatchRecordNames.add(stopWatchRecord.getName());
            }
            stopWatchRecordHeaderRowElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRecordNames));
        }
        for (StopWatchRecord stopWatchRecord : this.getStopWatchRecordsGroup()) {
            jenkinsReportStopWatchRecordTableRowElements.addAll(this._getStopWatchRecordTableRowElements(stopWatchRecord));
        }
        return jenkinsReportStopWatchRecordTableRowElements;
    }

    protected Element getJenkinsReportTableRowElement() {
        String cellElementTagName = this.getJenkinsReportBuildInfoCellElementTagName();
        Element stopWatchRecordsExpanderAnchorElement = this.getStopWatchRecordsExpanderAnchorElement();
        Element nameCellElement = Dom4JUtil.getNewElement(cellElementTagName, null, stopWatchRecordsExpanderAnchorElement, Dom4JUtil.getNewAnchorElement(this.getBuildURL(), null, this.getDisplayName()));
        int indent = this.getDepth() * 35;
        if (stopWatchRecordsExpanderAnchorElement != null) {
            indent -= 20;
        }
        nameCellElement.addAttribute("style", "text-indent: " + indent);
        Element buildInfoElement = Dom4JUtil.getNewElement("tr", null, nameCellElement, Dom4JUtil.getNewElement(cellElementTagName, null, Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "console", null, "Console")), Dom4JUtil.getNewElement(cellElementTagName, null, Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "testReport", "Test Report")));
        ArrayList<String> childStopWatchRows = new ArrayList<String>();
        if (this.buildDurationsEnabled()) {
            childStopWatchRows.add("build-durations-header");
            childStopWatchRows.add("test-durations-header");
        }
        childStopWatchRows.add("stop-watch-record-header");
        buildInfoElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRows));
        buildInfoElement.addAttribute("id", String.valueOf(this.hashCode()) + "-");
        this.getStartTime();
        if (this.startTime == null) {
            Dom4JUtil.addToElement(buildInfoElement, Dom4JUtil.getNewElement(cellElementTagName, null, "", this.getJenkinsReportTimeZoneName()));
        } else {
            Dom4JUtil.addToElement(buildInfoElement, Dom4JUtil.getNewElement(cellElementTagName, null, this.toJenkinsReportDateString(new Date(this.startTime), this.getJenkinsReportTimeZoneName())));
        }
        long duration = this.getDuration();
        Dom4JUtil.addToElement(buildInfoElement, Dom4JUtil.getNewElement(cellElementTagName, null, JenkinsResultsParserUtil.toDurationString(duration)));
        Element estimatedDurationElement = null;
        Element diffDurationElement = null;
        if (this.buildDurationsEnabled()) {
            String estimatedDurationString = "n/a";
            String diffDurationString = "n/a";
            if (this instanceof DownstreamBuild) {
                DownstreamBuild downstreamBuild = (DownstreamBuild)this;
                long averageDuration = downstreamBuild.getAverageDuration();
                estimatedDurationString = JenkinsResultsParserUtil.toDurationString(averageDuration);
                diffDurationString = this.getDiffDurationString(duration - averageDuration);
            }
            estimatedDurationElement = Dom4JUtil.getNewElement(cellElementTagName, null, estimatedDurationString);
            diffDurationElement = Dom4JUtil.getNewElement(cellElementTagName, null, diffDurationString);
        }
        Dom4JUtil.addToElement(buildInfoElement, estimatedDurationElement);
        Dom4JUtil.addToElement(buildInfoElement, diffDurationElement);
        String status = this.getStatus();
        status = status != null ? StringUtils.upperCase((String)status) : "";
        Dom4JUtil.getNewElement(cellElementTagName, buildInfoElement, status);
        String result = this.getResult();
        if (result == null) {
            result = "";
        }
        Dom4JUtil.getNewElement(cellElementTagName, buildInfoElement, result);
        return buildInfoElement;
    }

    protected List<Element> getJenkinsReportTableRowElements(String result, String status) {
        ArrayList<Element> tableRowElements = new ArrayList<Element>();
        if (this.getParentBuild() != null && (result == null || result.equals(this.getResult())) && (status == null || status.equals(this.getStatus()))) {
            tableRowElements.add(this.getJenkinsReportTableRowElement());
            if (this.buildDurationsEnabled()) {
                tableRowElements.addAll(this.getJenkinsReportBuildDurationsElements());
                tableRowElements.addAll(this.getJenkinsReportTestDurationsElements());
            }
            tableRowElements.addAll(this.getJenkinsReportStopWatchRecordElements());
        }
        List<Build> builds = this.getDownstreamBuilds(result, status);
        Collections.sort(builds, new BuildDisplayNameComparator());
        String batchName = null;
        for (Build build : builds) {
            DownstreamBuild downstreamBuild;
            String downstreamBatchName;
            if (!(build instanceof BaseBuild)) continue;
            if (build instanceof DownstreamBuild && !Objects.equals(batchName, downstreamBatchName = (downstreamBuild = (DownstreamBuild)build).getBatchName())) {
                tableRowElements.add(Dom4JUtil.getNewElement("th", null, downstreamBatchName));
                batchName = downstreamBatchName;
            }
            BaseBuild baseBuild = (BaseBuild)build;
            tableRowElements.addAll(baseBuild.getJenkinsReportTableRowElements(result, status));
        }
        return tableRowElements;
    }

    protected List<Element> getJenkinsReportTestDurationsElements() {
        return new ArrayList<Element>();
    }

    protected String getJenkinsReportTimeZoneName() {
        return _NAME_JENKINS_REPORT_TIME_ZONE;
    }

    protected Map<String, String> getParameters(JSONArray jsonArray) {
        HashMap<String, String> parameters = new HashMap<String, String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            parameters.put(jsonObject.getString("name"), jsonObject.optString("value"));
        }
        return parameters;
    }

    protected Map<String, String> getParameters(JSONObject buildJSONObject) {
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        if (actionsJSONArray.length() == 0) {
            return new HashMap<String, String>();
        }
        JSONObject parametersActionsJSONObject = null;
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionsJSONObject = actionsJSONArray.getJSONObject(i);
            if (!Objects.equals(actionsJSONObject.optString("_class"), "hudson.model.ParametersAction")) continue;
            parametersActionsJSONObject = actionsJSONObject;
            break;
        }
        if (parametersActionsJSONObject != null && parametersActionsJSONObject.has("parameters")) {
            JSONArray parametersJSONArray = parametersActionsJSONObject.getJSONArray("parameters");
            return this.getParameters(parametersJSONArray);
        }
        return new HashMap<String, String>();
    }

    protected JSONObject getQueueItemJSONObject() throws IOException {
        JSONArray queueItemsJSONArray = this.getQueueItemsJSONArray();
        for (int i = 0; i < queueItemsJSONArray.length(); ++i) {
            JSONObject queueItemJSONObject = queueItemsJSONArray.getJSONObject(i);
            JSONObject taskJSONObject = queueItemJSONObject.getJSONObject("task");
            String queueItemName = taskJSONObject.getString("name");
            if (!queueItemName.equals(this.jobName) || !this._parameters.equals(this.getParameters(queueItemJSONObject))) continue;
            return queueItemJSONObject;
        }
        return null;
    }

    protected JSONArray getQueueItemsJSONArray() throws IOException {
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine("http://", this._jenkinsMaster.getName(), "/queue/api/json?tree=items[actions[parameters", "[name,value]],task[name,url]]"), false);
        return jsonObject.getJSONArray("items");
    }

    protected String getReinvokedMessage() {
        return "Reinvoked: " + this.getBuildURL();
    }

    protected JSONObject getRunningBuildJSONObject() throws IOException {
        JSONArray buildsJSONArray;
        int page = 0;
        while ((buildsJSONArray = this.getBuildsJSONArray(page)).length() != 0) {
            for (int i = 0; i < buildsJSONArray.length(); ++i) {
                JSONObject buildJSONObject = buildsJSONArray.getJSONObject(i);
                Map<String, String> parameters = this.getParameters();
                if (!parameters.equals(this.getParameters(buildJSONObject)) || this.badBuildNumbers.contains(buildJSONObject.getInt("number"))) continue;
                return buildJSONObject;
            }
            ++page;
        }
        return null;
    }

    protected String getStartPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/start.properties.json";
        }
        return this.getParameterValue("JSON_MAP_URL");
    }

    protected String getStopPropertiesTempMapURL() {
        return null;
    }

    protected Element getStopWatchRecordExpanderAnchorElement(StopWatchRecord stopWatchRecord, String namespace) {
        Set<StopWatchRecord> childStopWatchRecords = stopWatchRecord.getChildStopWatchRecords();
        if (childStopWatchRecords == null) {
            return null;
        }
        return this.getExpanderAnchorElement(stopWatchRecord.getName(), namespace);
    }

    protected Element getStopWatchRecordsExpanderAnchorElement() {
        StopWatchRecordsGroup stopWatchRecordsGroup = this.getStopWatchRecordsGroup();
        if (stopWatchRecordsGroup.isEmpty()) {
            return null;
        }
        Element stopWatchRecordsExpanderAnchorElement = Dom4JUtil.getNewAnchorElement("", "+ ");
        String hashCode = String.valueOf(this.hashCode());
        stopWatchRecordsExpanderAnchorElement.addAttribute("id", JenkinsResultsParserUtil.combine(hashCode, "-expander-anchor-"));
        stopWatchRecordsExpanderAnchorElement.addAttribute("onClick", JenkinsResultsParserUtil.combine("return toggleStopWatchRecordExpander('", hashCode, "', '')"));
        stopWatchRecordsExpanderAnchorElement.addAttribute("style", "font-family: monospace, monospace; text-decoration: none");
        return stopWatchRecordsExpanderAnchorElement;
    }

    protected Map<String, String> getTempMap(String tempMapName) {
        String tempMapURL = this.getTempMapURL(tempMapName);
        if (tempMapURL == null) {
            return this.getTempMapFromBuildDatabase(tempMapName);
        }
        JSONObject tempMapJSONObject = null;
        try {
            tempMapJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(tempMapURL), false, 0, 0, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (tempMapJSONObject == null || !tempMapJSONObject.has("properties")) {
            return this.getTempMapFromBuildDatabase(tempMapName);
        }
        JSONArray propertiesJSONArray = tempMapJSONObject.getJSONArray("properties");
        HashMap<String, String> tempMap = new HashMap<String, String>(propertiesJSONArray.length());
        for (int i = 0; i < propertiesJSONArray.length(); ++i) {
            JSONObject propertyJSONObject = propertiesJSONArray.getJSONObject(i);
            String key = propertyJSONObject.getString("name");
            String value = propertyJSONObject.optString("value");
            if (value == null || value.isEmpty()) continue;
            tempMap.put(key, value);
        }
        return tempMap;
    }

    protected Map<String, String> getTempMapFromBuildDatabase(String tempMapName) {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        if (!this.fromArchive) {
            BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase(this);
            Properties properties = buildDatabase.getProperties(tempMapName);
            for (String propertyName : properties.stringPropertyNames()) {
                tempMap.put(propertyName, properties.getProperty(propertyName));
            }
        }
        return tempMap;
    }

    protected String getTempMapURL(String tempMapName) {
        if (tempMapName.equals("start.properties")) {
            return this.getStartPropertiesTempMapURL();
        }
        if (tempMapName.equals("stop.properties")) {
            return this.getStopPropertiesTempMapURL();
        }
        return null;
    }

    protected int getTestCountByStatus(String status) {
        JSONObject testReportJSONObject = this.getTestReportJSONObject(false);
        if (testReportJSONObject == null) {
            return 0;
        }
        if (status.equals("FAILURE")) {
            return testReportJSONObject.getInt("failCount");
        }
        if (status.equals("SUCCESS")) {
            return testReportJSONObject.getInt("passCount");
        }
        throw new IllegalArgumentException("Invalid status: " + status);
    }

    protected boolean isParentBuildRoot() {
        if (this._parentBuild == null) {
            return false;
        }
        return this._parentBuild.getParentBuild() == null && this._parentBuild instanceof TopLevelBuild;
    }

    protected void loadParametersFromBuildJSONObject() {
        if (this.getBuildURL() == null) {
            return;
        }
        JSONObject buildJSONObject = this.getBuildJSONObject("actions[parameters[*]]");
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        if (actionsJSONArray.length() == 0) {
            this._parameters = new HashMap<String, String>();
            return;
        }
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject actionJSONObject = actionsJSONArray.getJSONObject(i);
            if (!actionJSONObject.has("parameters")) continue;
            JSONArray parametersJSONArray = actionJSONObject.getJSONArray("parameters");
            this._parameters = new HashMap<String, String>(parametersJSONArray.length());
            for (int j = 0; j < parametersJSONArray.length(); ++j) {
                String valueString;
                JSONObject parameterJSONObject = parametersJSONArray.getJSONObject(j);
                Object value = parameterJSONObject.opt("value");
                if (!(value instanceof String) || (valueString = value.toString()).isEmpty()) continue;
                this._parameters.put(parameterJSONObject.getString("name"), value.toString());
            }
            return;
        }
        this._parameters = Collections.emptyMap();
    }

    protected void loadParametersFromQueryString(String queryString) {
        Map<String, String> defaultJobParameters = this._getDefaultJobParameters();
        this._parameters.putAll(defaultJobParameters);
        for (String parameter : queryString.split("&")) {
            String[] nameValueArray;
            if (!parameter.contains("=") || !defaultJobParameters.containsKey((nameValueArray = parameter.split("="))[0])) continue;
            if (nameValueArray.length == 2) {
                this._parameters.put(nameValueArray[0], nameValueArray[1]);
                continue;
            }
            if (nameValueArray.length != 1) continue;
            this._parameters.put(nameValueArray[0], "");
        }
    }

    protected void reset() {
        this.badBuildNumbers.add(this.getBuildNumber());
        this.setResult(null);
        this.setBuildNumber(-1);
        this.downstreamBuilds.clear();
    }

    protected void setBuildNumber(int buildNumber) {
        if (this._buildNumber != buildNumber) {
            int previousBuildNumber = this._buildNumber;
            this._buildNumber = buildNumber;
            this.consoleReadCursor = 0;
            if (this._buildNumber == -1) {
                this.setStatus("starting");
            } else if (!this.badBuildNumbers.contains(previousBuildNumber)) {
                this.setStatus("running");
            }
        }
    }

    protected void setBuildURL(String buildURL) {
        try {
            buildURL = JenkinsResultsParserUtil.decode(buildURL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unable to decode " + buildURL, unsupportedEncodingException);
        }
        Build parentBuild = this.getParentBuild();
        try {
            String archiveMarkerContent;
            this.fromArchive = parentBuild != null ? parentBuild.isFromArchive() : (archiveMarkerContent = JenkinsResultsParserUtil.toString(buildURL + "/archive-marker", false, 0, 0, 0)) != null && !archiveMarkerContent.isEmpty();
        }
        catch (IOException ioException) {
            this.fromArchive = false;
        }
        MultiPattern buildURLMultiPattern = this.getBuildURLMultiPattern();
        Matcher matcher = buildURLMultiPattern.find(buildURL);
        if (matcher == null) {
            Pattern archiveBuildURLPattern = this.getArchiveBuildURLPattern();
            matcher = archiveBuildURLPattern.matcher(buildURL);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Invalid build URL " + buildURL);
            }
            this.setArchiveName(matcher.group("archiveName"));
        }
        this.extractBuildURLComponents(matcher);
        this.loadParametersFromBuildJSONObject();
        this.consoleReadCursor = 0;
        this.setStatus("running");
        this.fromCompletedBuild = this.isFromCompletedBuild();
    }

    protected void setInvocationURL(String invocationURL) {
        if (this.getBuildURL() != null) {
            return;
        }
        try {
            invocationURL = JenkinsResultsParserUtil.decode(invocationURL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unable to decode " + invocationURL, unsupportedEncodingException);
        }
        Matcher invocationURLMatcher = invocationURLPattern.matcher(invocationURL);
        if (!invocationURLMatcher.find()) {
            throw new RuntimeException("Invalid invocation URL");
        }
        this.setJobName(invocationURLMatcher.group("jobName"));
        this.setJenkinsMaster(JenkinsMaster.getInstance(invocationURLMatcher.group("master")));
        this.loadParametersFromQueryString(invocationURL);
        this.setStatus("starting");
        if (JenkinsResultsParserUtil.isCINode()) {
            invocationURL = JenkinsResultsParserUtil.getLocalURL(invocationURL);
        }
        try {
            JenkinsResultsParserUtil.toString(invocationURL, false);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected void setJenkinsMaster(JenkinsMaster jenkinsMaster) {
        this._jenkinsMaster = jenkinsMaster;
    }

    protected void setJobName(String jobName) {
        this.jobName = jobName;
        Matcher matcher = jobNamePattern.matcher(jobName);
        if (matcher.find()) {
            this.branchName = matcher.group("branchName");
            return;
        }
        this.branchName = "master";
    }

    protected void setResult(String result) {
        this.result = result;
        if (result == null || this.getDownstreamBuildCount("completed") < this.getDownstreamBuildCount(null)) {
            this.setStatus("running");
        } else {
            this.setStatus("completed");
        }
    }

    protected void setStatus(String status) {
        if (this._isDifferent(status, this._status)) {
            this._status = status;
            long previousStatusModifiedTime = this.statusModifiedTime;
            this.statusModifiedTime = JenkinsResultsParserUtil.getCurrentTimeMillis();
            this.statusDurations.put(this._previousStatus, this.statusModifiedTime - previousStatusModifiedTime);
            if (this.isParentBuildRoot() && !this.badBuildNumbers.contains(this._buildNumber)) {
                System.out.println(this.getBuildMessage());
            }
        }
    }

    protected String toJenkinsReportDateString(Date date, String timeZoneName) {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        return JenkinsResultsParserUtil.toDateString(date, buildProperties.getProperty("jenkins.report.date.format"), timeZoneName);
    }

    protected void writeArchiveFile(String content, String path) throws IOException {
        JenkinsResultsParserUtil.write(new File(this.getArchiveRootDir(), path), JenkinsResultsParserUtil.redact(this.replaceBuildURL(content)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _archive(String content, boolean required, String urlSuffix) {
        boolean readyToArchive = true;
        String status = this.getStatus();
        if (!status.equals("completed")) {
            readyToArchive = false;
        } else if (!(this instanceof TopLevelBuild)) {
            JSONObject buildJSONObject = JenkinsAPIUtil.getAPIJSONObject(this.getBuildURL(), "duration");
            if (buildJSONObject != null) {
                long duration = buildJSONObject.optLong("duration", 0L);
                if (duration == 0L) {
                    readyToArchive = false;
                }
            } else {
                readyToArchive = false;
            }
        }
        File archiveFile = this.getArchiveFile(urlSuffix);
        if (!readyToArchive) {
            if (!archiveFile.exists()) return;
            JenkinsResultsParserUtil.delete(archiveFile);
            return;
        }
        if (archiveFile.exists()) {
            return;
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        String urlString = this.getBuildURL() + urlSuffix;
        if (urlString.endsWith("json")) {
            urlString = urlString + "?pretty";
        }
        urlSuffix = JenkinsResultsParserUtil.fixFileName(urlSuffix);
        if (JenkinsResultsParserUtil.isNullOrEmpty(content)) {
            try {
                int maxRetries = 0;
                int retryPeriodSeconds = 0;
                if (required) {
                    maxRetries = 2;
                    retryPeriodSeconds = 5;
                }
                content = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(urlString), false, maxRetries, retryPeriodSeconds, 0, true);
            }
            catch (IOException ioException) {
                if (!required) return;
                throw new RuntimeException("Unable to archive " + urlString, ioException);
            }
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(content)) {
            return;
        }
        try {
            this.writeArchiveFile(content, this.getArchivePath() + "/" + urlSuffix);
            if (!JenkinsResultsParserUtil.debug) return;
        }
        catch (IOException ioException) {
            try {
                throw new RuntimeException("Unable to write file", ioException);
            }
            catch (Throwable throwable) {
                if (!JenkinsResultsParserUtil.debug) throw throwable;
                System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(this.getArchiveFile(urlSuffix)), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
                throw throwable;
            }
        }
        System.out.println(JenkinsResultsParserUtil.combine("Archived ", String.valueOf(this.getArchiveFile(urlSuffix)), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
        return;
    }

    private void _archiveBuildJSON() {
        this._archive(null, true, "api/json");
    }

    private void _archiveConsoleLog() {
        this._archive(this.getConsoleText(), true, "consoleText");
    }

    private void _archiveMarkerFile() {
        this._archive(String.valueOf(JenkinsResultsParserUtil.getCurrentTimeMillis()), true, "archive-marker");
    }

    private void _archiveTestReportJSON() {
        this._archive(null, false, "testReport/api/json");
    }

    private Map<String, String> _getDefaultJobParameters() {
        JSONObject jobJSONObject = null;
        String jobURL = this.getJobURL();
        if (JenkinsResultsParserUtil.isCINode()) {
            jobURL = JenkinsResultsParserUtil.getLocalURL(jobURL);
        }
        try {
            jobJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(jobURL, "/api/json?tree=actions[parameterDefinitions[", "defaultParameterValue[value],name]]"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        JSONObject actionsJSONObject = null;
        JSONArray actionsJSONArray = jobJSONObject.getJSONArray("actions");
        for (int i = 0; i < actionsJSONArray.length(); ++i) {
            JSONObject jsonObject = actionsJSONArray.getJSONObject(i);
            if (!jsonObject.has("parameterDefinitions")) continue;
            actionsJSONObject = jsonObject;
            break;
        }
        HashMap<String, String> jobParameters = new HashMap<String, String>();
        if (actionsJSONObject == null) {
            return jobParameters;
        }
        JSONArray parameterDefinitionsJSONArray = actionsJSONObject.getJSONArray("parameterDefinitions");
        for (int i = 0; i < parameterDefinitionsJSONArray.length(); ++i) {
            JSONObject parameterJSONObject = parameterDefinitionsJSONArray.getJSONObject(i);
            JSONObject defaultParameterValueJSONObject = parameterJSONObject.getJSONObject("defaultParameterValue");
            jobParameters.put(parameterJSONObject.getString("name"), defaultParameterValueJSONObject.getString("value"));
        }
        return jobParameters;
    }

    private List<Element> _getStopWatchRecordTableRowElements(StopWatchRecord stopWatchRecord) {
        Element buildInfoElement = Dom4JUtil.getNewElement("tr", null, new Object[0]);
        String buildHashCode = String.valueOf(this.hashCode());
        buildInfoElement.addAttribute("id", buildHashCode + "-" + stopWatchRecord.getName());
        buildInfoElement.addAttribute("style", "display: none");
        Element expanderAnchorElement = this.getStopWatchRecordExpanderAnchorElement(stopWatchRecord, buildHashCode);
        Element nameElement = Dom4JUtil.getNewElement("td", buildInfoElement, expanderAnchorElement, stopWatchRecord.getShortName());
        int indent = (this.getDepth() + stopWatchRecord.getDepth() + 1) * 35;
        if (expanderAnchorElement != null) {
            indent -= 20;
        }
        nameElement.addAttribute("style", JenkinsResultsParserUtil.combine("text-indent: ", String.valueOf(indent), "px"));
        Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
        Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
        Dom4JUtil.getNewElement("td", buildInfoElement, this.toJenkinsReportDateString(new Date(stopWatchRecord.getStartTimestamp()), this.getJenkinsReportTimeZoneName()));
        Long duration = stopWatchRecord.getDuration();
        if (duration == null) {
            Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
        } else {
            Dom4JUtil.getNewElement("td", buildInfoElement, JenkinsResultsParserUtil.toDurationString(stopWatchRecord.getDuration()));
        }
        Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
        Dom4JUtil.getNewElement("td", buildInfoElement, "&nbsp;");
        ArrayList<Element> jenkinsReportTableRowElements = new ArrayList<Element>();
        jenkinsReportTableRowElements.add(buildInfoElement);
        Set<StopWatchRecord> childStopWatchRecords = stopWatchRecord.getChildStopWatchRecords();
        if (childStopWatchRecords != null) {
            ArrayList<String> childStopWatchRecordNames = new ArrayList<String>(childStopWatchRecords.size());
            for (StopWatchRecord childStopWatchRecord : childStopWatchRecords) {
                childStopWatchRecordNames.add(childStopWatchRecord.getName());
                List<Element> childJenkinsReportTableRowElements = this._getStopWatchRecordTableRowElements(childStopWatchRecord);
                for (Element childJenkinsReportTableRowElement : childJenkinsReportTableRowElements) {
                    childJenkinsReportTableRowElement.addAttribute("style", "display: none");
                }
                jenkinsReportTableRowElements.addAll(childJenkinsReportTableRowElements);
            }
            buildInfoElement.addAttribute("child-stopwatch-rows", JenkinsResultsParserUtil.join(",", childStopWatchRecordNames));
        }
        return jenkinsReportTableRowElements;
    }

    private synchronized void _initTestClassResults() {
        if (!this.isCompleted() || this._testClassResults != null) {
            return;
        }
        JSONObject testReportJSONObject = null;
        try {
            testReportJSONObject = this.getTestReportJSONObject(true);
        }
        catch (RuntimeException runtimeException) {
            this._testClassResults = new ConcurrentHashMap<String, TestClassResult>();
            return;
        }
        this._testClassResults = new ConcurrentHashMap<String, TestClassResult>();
        if (testReportJSONObject == null) {
            return;
        }
        ArrayList<JSONArray> suitesJSONArrays = new ArrayList<JSONArray>();
        if (testReportJSONObject.has("suites")) {
            suitesJSONArrays.add(testReportJSONObject.getJSONArray("suites"));
        } else if (testReportJSONObject.has("childReports")) {
            JSONArray childReportsJSONArray = testReportJSONObject.getJSONArray("childReports");
            for (int i = 0; i < childReportsJSONArray.length(); ++i) {
                JSONObject resultJSONObject;
                JSONObject childReportJSONObject = childReportsJSONArray.getJSONObject(i);
                if (!childReportJSONObject.has("result") || !(resultJSONObject = childReportJSONObject.getJSONObject("result")).has("suites")) continue;
                suitesJSONArrays.add(resultJSONObject.getJSONArray("suites"));
            }
        }
        for (JSONArray suitesJSONArray : suitesJSONArrays) {
            for (int i = 0; i < suitesJSONArray.length(); ++i) {
                JSONObject suiteJSONObject = suitesJSONArray.getJSONObject(i);
                TestClassResult testClassResult = TestClassResultFactory.newTestClassResult(this, suiteJSONObject);
                this._testClassResults.put(testClassResult.getClassName(), testClassResult);
            }
        }
    }

    private boolean _isDifferent(String newValue, String oldValue) {
        if (oldValue == null) {
            return newValue != null;
        }
        return !oldValue.equals(newValue);
    }

    static {
        _TOKENS_HIGH_PRIORITY_CONTENT = new String[]{"compileJSP", "SourceFormatter.format", "Unable to compile JSPs"};
        _buildURLMultiPattern = new MultiPattern(JenkinsResultsParserUtil.combine("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+).*/(?<buildNumber>", "\\d+)/?"));
        _testrayAttachmentURLPattern = Pattern.compile("\\[beanshell\\] Uploaded (?<url>https://testray.liferay.com/[^\\s]+)");
        _testrayS3ObjectURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\[beanshell\\] Created S3 Object (?<url>", "https://storage.cloud.google.com/[^\\s?]+).*"));
        Properties properties = null;
        try {
            properties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        _NAME_JENKINS_REPORT_TIME_ZONE = properties.getProperty("jenkins.report.time.zone");
    }

    protected static class TimelineData {
        private final long _duration;
        private final long _startTime;
        private final TimelineDataPoint[] _timeline;

        protected TimelineData(int size, TopLevelBuild topLevelBuild) {
            if (topLevelBuild != topLevelBuild.getTopLevelBuild()) {
                throw new IllegalArgumentException("Nested TopLevelBuild objects are invalid");
            }
            if (size < 1) {
                throw new IllegalArgumentException("Invalid size " + size);
            }
            this._duration = topLevelBuild.getDuration();
            this._startTime = topLevelBuild.getStartTime();
            this._timeline = new TimelineDataPoint[size];
            for (int i = 0; i < size; ++i) {
                this._timeline[i] = new TimelineDataPoint((int)((long)i * (this._duration / (long)this._timeline.length)));
            }
            topLevelBuild.addTimelineData(this);
        }

        protected void addTimelineData(BaseBuild build) {
            int startIndex;
            Long buildInvokedTime = build.getInvokedTime();
            if (buildInvokedTime == null) {
                return;
            }
            this._timeline[this._getIndex(buildInvokedTime)]._invocationsCount++;
            Long buildStartTime = build.getStartTime();
            if (buildStartTime == null) {
                return;
            }
            int endIndex = this._getIndex(buildStartTime + build.getDuration());
            for (int i = startIndex = this._getIndex(buildStartTime); i <= endIndex; ++i) {
                this._timeline[i]._slaveUsageCount++;
            }
        }

        protected int[] getIndexData() {
            int[] indexes = new int[this._timeline.length];
            for (int i = 0; i < this._timeline.length; ++i) {
                indexes[i] = this._timeline[i]._index;
            }
            return indexes;
        }

        protected int[] getInvocationsData() {
            int[] invocationsData = new int[this._timeline.length];
            for (int i = 0; i < this._timeline.length; ++i) {
                invocationsData[i] = this._timeline[i]._invocationsCount;
            }
            return invocationsData;
        }

        protected int[] getSlaveUsageData() {
            int[] slaveUsageData = new int[this._timeline.length];
            for (int i = 0; i < this._timeline.length; ++i) {
                slaveUsageData[i] = this._timeline[i]._slaveUsageCount;
            }
            return slaveUsageData;
        }

        private int _getIndex(long timestamp) {
            int index = (int)((timestamp - this._startTime) * (long)this._timeline.length / this._duration);
            if (index >= this._timeline.length) {
                return this._timeline.length - 1;
            }
            if (index < 0) {
                return 0;
            }
            return index;
        }

        private static class TimelineDataPoint {
            private final int _index;
            private int _invocationsCount;
            private int _slaveUsageCount;

            private TimelineDataPoint(int index) {
                this._index = index;
            }
        }
    }

    public static class DefaultBranchInformation
    implements Build.BranchInformation {
        private String _branchInformationString;
        private final Build _build;
        private final String _repositoryType;

        @Override
        public String getCachedRemoteGitRefName() {
            return JenkinsResultsParserUtil.combine("cache-", this.getReceiverUsername(), "-", this.getUpstreamBranchSHA(), "-", this.getOriginName(), "-", this.getSenderBranchSHA());
        }

        @Override
        public String getOriginName() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.origin.name=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public Integer getPullRequestNumber() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.pull.request.number=(\\d+)\\n[\\S\\s]*")) {
                return Integer.valueOf(branchInformationString.replaceAll(regex, "$1"));
            }
            return 0;
        }

        @Override
        public String getReceiverUsername() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.receiver.username=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getRepositoryName() {
            Properties buildProperties;
            try {
                buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            String repositoryType = this._repositoryType;
            if (repositoryType.equals("portal.base") || repositoryType.equals("portal.ee")) {
                repositoryType = "portal";
            }
            return JenkinsResultsParserUtil.getProperty(buildProperties, repositoryType + ".repository", this.getUpstreamBranchName());
        }

        @Override
        public String getSenderBranchName() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.sender.branch.name=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getSenderBranchSHA() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.sender.branch.sha=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public RemoteGitRef getSenderRemoteGitRef() {
            String remoteURL = JenkinsResultsParserUtil.combine("git@github.com:", this.getSenderUsername(), "/", this.getRepositoryName(), ".git");
            return GitUtil.getRemoteGitRef(this.getSenderBranchName(), new File("."), remoteURL);
        }

        @Override
        public String getSenderUsername() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.sender.username=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getUpstreamBranchName() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.upstream.branch.name=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        @Override
        public String getUpstreamBranchSHA() {
            String regex;
            String branchInformationString = this._getBranchInformationString();
            if (branchInformationString.matches(regex = "[\\S\\s]*github.upstream.branch.sha=(.+)\\n[\\S\\s]*")) {
                return branchInformationString.replaceAll(regex, "$1");
            }
            return null;
        }

        protected DefaultBranchInformation(Build build, String repositoryType) {
            this._build = build;
            this._repositoryType = repositoryType;
        }

        private String _getBranchInformationString() {
            if (this._branchInformationString != null) {
                return this._branchInformationString;
            }
            String consoleText = this._build.getConsoleText();
            int x = -1;
            Pattern pattern = Pattern.compile(JenkinsResultsParserUtil.combine("## (http://cloud-.*/)?git.", this._repositoryType, ".properties"));
            Matcher matcher = pattern.matcher(consoleText);
            if (matcher.find()) {
                x = matcher.start();
            }
            if (x == -1) {
                return "";
            }
            int y = consoleText.indexOf("prepare.repositories.", x);
            if (y == -1) {
                y = consoleText.indexOf("Deleting:", x);
            }
            if ((y = consoleText.indexOf("\n", y)) == -1) {
                return "";
            }
            this._branchInformationString = consoleText.substring(x, y);
            return this._branchInformationString;
        }
    }

    public static class BuildDisplayNameComparator
    implements Comparator<Build> {
        private static final Pattern _pattern = Pattern.compile("(?<batchName>[^/]+)/(?<segment>\\d+)(/(?<axis>\\d+))?");

        @Override
        public int compare(Build build1, Build build2) {
            Integer segment2;
            String batchName2;
            String axisName1 = this._getAxisName(build1);
            String axisName2 = this._getAxisName(build2);
            if (JenkinsResultsParserUtil.isNullOrEmpty(axisName1) || JenkinsResultsParserUtil.isNullOrEmpty(axisName2)) {
                String displayName1 = build1.getDisplayName();
                String displayName2 = build2.getDisplayName();
                return displayName1.compareTo(displayName2);
            }
            Matcher matcher1 = _pattern.matcher(axisName1);
            Matcher matcher2 = _pattern.matcher(axisName2);
            if (!matcher1.find() || !matcher2.find()) {
                String displayName1 = build1.getDisplayName();
                String displayName2 = build2.getDisplayName();
                return displayName1.compareTo(displayName2);
            }
            String batchName1 = matcher1.group("batchName");
            if (!batchName1.equals(batchName2 = matcher2.group("batchName"))) {
                return batchName1.compareTo(batchName2);
            }
            Integer segment1 = Integer.valueOf(matcher1.group("segment"));
            if (!segment1.equals(segment2 = Integer.valueOf(matcher2.group("segment")))) {
                return segment1.compareTo(segment2);
            }
            String axisString1 = matcher1.group("axis");
            String axisString2 = matcher2.group("axis");
            if (JenkinsResultsParserUtil.isNullOrEmpty(axisString1) || JenkinsResultsParserUtil.isNullOrEmpty(axisString2)) {
                String displayName1 = build1.getDisplayName();
                String displayName2 = build2.getDisplayName();
                return displayName1.compareTo(displayName2);
            }
            Integer axis1 = Integer.valueOf(axisString1);
            Integer axis2 = Integer.valueOf(axisString2);
            return axis1.compareTo(axis2);
        }

        private String _getAxisName(Build build) {
            if (build instanceof AxisBuild) {
                AxisBuild axisBuild = (AxisBuild)build;
                return axisBuild.getAxisNumber();
            }
            if (build instanceof DownstreamBuild) {
                DownstreamBuild downstreamBuild = (DownstreamBuild)build;
                return downstreamBuild.getAxisName();
            }
            return build.getJobVariant();
        }
    }
}

