/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import java.util.Hashtable;
import org.dom4j.Element;

public class SemanticVersioningFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final String _SEMVER_END_STRING = ":baseline FAILED";
    private static final String _SEMVER_START_STRING = "PACKAGE_NAME";

    @Override
    public String getMessage(String buildURL, String consoleOutput, Hashtable<?, ?> properties) {
        if (!consoleOutput.contains(_SEMVER_END_STRING) || !consoleOutput.contains(_SEMVER_START_STRING)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>Please fix <strong>semantic versioning</strong> on ");
        sb.append("<strong><a href=\"https://github.com/");
        sb.append(properties.get("github.origin.name"));
        sb.append("/");
        sb.append(properties.get("repository"));
        sb.append("/tree/");
        sb.append(properties.get("github.sender.branch.name"));
        sb.append("\">");
        sb.append(properties.get("github.origin.name"));
        sb.append("/");
        sb.append(properties.get("github.sender.branch.name"));
        sb.append("</a></strong>.</p>");
        int end = consoleOutput.indexOf(_SEMVER_END_STRING);
        end = consoleOutput.indexOf("\n", end);
        int start = consoleOutput.lastIndexOf(_SEMVER_START_STRING, end);
        start = consoleOutput.lastIndexOf("\n", start);
        sb.append(this.getConsoleOutputSnippet(consoleOutput, true, start, end));
        return sb.toString();
    }

    @Override
    public Element getMessageElement(Build build) {
        String consoleText = build.getConsoleText();
        if (!consoleText.contains(_SEMVER_END_STRING) || !consoleText.contains(_SEMVER_START_STRING)) {
            return null;
        }
        int end = consoleText.indexOf(_SEMVER_END_STRING);
        end = consoleText.indexOf("\n", end);
        int start = consoleText.lastIndexOf(_SEMVER_START_STRING, end);
        start = consoleText.lastIndexOf("\n", start);
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("p", null, "Please fix ", Dom4JUtil.getNewElement("strong", null, "semantic versioning"), " on ", Dom4JUtil.getNewElement("strong", null, this.getBaseBranchAnchorElement(build.getTopLevelBuild()), this.getConsoleOutputSnippetElement(consoleText, true, start, end))));
    }
}

