/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class SecurePrintStream
extends PrintStream {
    private static SecurePrintStream _securePrintStream;
    private final SecurePrintStreamByteArrayOutputStream _securePrintStreamByteArrayOutputStream;
    private boolean _suspendFlush;
    private final PrintStream _systemOutPrintStream;
    private PrintStream _tempPrintStream;

    public static SecurePrintStream getInstance() {
        if (_securePrintStream == null) {
            try {
                _securePrintStream = new SecurePrintStream(new SecurePrintStreamByteArrayOutputStream());
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException(uee);
            }
        }
        return _securePrintStream;
    }

    @Override
    public PrintStream append(char c) {
        if (this._suspendFlush) {
            return this._tempPrintStream.append(c);
        }
        return super.append(c);
    }

    @Override
    public PrintStream append(CharSequence charSequence) {
        if (this._suspendFlush) {
            return this._tempPrintStream.append(charSequence);
        }
        return super.append(charSequence);
    }

    @Override
    public PrintStream append(CharSequence charSequence, int start, int end) {
        if (this._suspendFlush) {
            return this._tempPrintStream.append(charSequence, start, end);
        }
        return super.append(charSequence, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this._suspendFlush) {
            return;
        }
        SecurePrintStream securePrintStream = this;
        synchronized (securePrintStream) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                this._tempPrintStream = new PrintStream(byteArrayOutputStream);
                this._suspendFlush = true;
                String content = this._securePrintStreamByteArrayOutputStream.toString();
                content = JenkinsResultsParserUtil.redact(content);
                this._systemOutPrintStream.print(content);
            }
            finally {
                this._securePrintStreamByteArrayOutputStream.reset();
                this._suspendFlush = false;
                try {
                    this._securePrintStreamByteArrayOutputStream.write(byteArrayOutputStream.toByteArray());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                finally {
                    byteArrayOutputStream.reset();
                }
                this._tempPrintStream.close();
            }
        }
    }

    @Override
    public void print(boolean b) {
        if (this._suspendFlush) {
            this._tempPrintStream.print(b);
            return;
        }
        super.print(b);
    }

    @Override
    public void print(char c) {
        if (this._suspendFlush) {
            this._tempPrintStream.print(c);
            return;
        }
        super.print(c);
    }

    @Override
    public void print(char[] chars) {
        if (this._suspendFlush) {
            this._tempPrintStream.print(chars);
            return;
        }
        super.print(chars);
    }

    @Override
    public void print(double d) {
        if (this._suspendFlush) {
            this._tempPrintStream.print(d);
            return;
        }
        super.print(d);
    }

    @Override
    public void print(float f) {
        if (this._suspendFlush) {
            this._tempPrintStream.print(f);
            return;
        }
        super.print(f);
    }

    @Override
    public void print(int i) {
        if (this._suspendFlush) {
            this._tempPrintStream.print(i);
            return;
        }
        super.print(i);
    }

    @Override
    public void print(long l) {
        if (this._suspendFlush) {
            this._tempPrintStream.print(l);
            return;
        }
        super.print(l);
    }

    @Override
    public void print(Object object) {
        if (this._suspendFlush) {
            this._tempPrintStream.print(object);
            return;
        }
        super.print(object);
    }

    @Override
    public void print(String string) {
        if (this._suspendFlush) {
            this._tempPrintStream.print(string);
            return;
        }
        super.print(string);
    }

    @Override
    public void println() {
        if (this._suspendFlush) {
            this._tempPrintStream.println();
            return;
        }
        super.println();
    }

    @Override
    public void println(boolean b) {
        if (this._suspendFlush) {
            this._tempPrintStream.println(b);
            return;
        }
        super.println(b);
    }

    @Override
    public void println(char c) {
        if (this._suspendFlush) {
            this._tempPrintStream.println(c);
            return;
        }
        super.println(c);
    }

    @Override
    public void println(char[] chars) {
        if (this._suspendFlush) {
            this._tempPrintStream.println(chars);
            return;
        }
        super.println(chars);
    }

    @Override
    public void println(double d) {
        if (this._suspendFlush) {
            this._tempPrintStream.println(d);
            return;
        }
        super.println(d);
    }

    @Override
    public void println(float f) {
        if (this._suspendFlush) {
            this._tempPrintStream.println(f);
            return;
        }
        super.println(f);
    }

    @Override
    public void println(int i) {
        if (this._suspendFlush) {
            this._tempPrintStream.println(i);
            return;
        }
        super.println(i);
    }

    @Override
    public void println(long l) {
        if (this._suspendFlush) {
            this._tempPrintStream.println(l);
            return;
        }
        super.println(l);
    }

    @Override
    public void println(Object object) {
        if (this._suspendFlush) {
            this._tempPrintStream.println(object);
            return;
        }
        super.println(object);
    }

    @Override
    public void println(String string) {
        if (this._suspendFlush) {
            this._tempPrintStream.println(string);
            return;
        }
        super.println(string);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (this._suspendFlush) {
            this._tempPrintStream.write(bytes);
            return;
        }
        super.write(bytes);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        if (this._suspendFlush) {
            this._tempPrintStream.write(buffer, offset, length);
            return;
        }
        super.write(buffer, offset, length);
    }

    @Override
    public void write(int b) {
        if (this._suspendFlush) {
            this._tempPrintStream.write(b);
            return;
        }
        super.write(b);
    }

    private SecurePrintStream(SecurePrintStreamByteArrayOutputStream securePrintStreamByteArrayOutputStream) throws UnsupportedEncodingException {
        super(securePrintStreamByteArrayOutputStream, true);
        this._securePrintStreamByteArrayOutputStream = securePrintStreamByteArrayOutputStream;
        this._securePrintStreamByteArrayOutputStream.setSecurePrintStream(this);
        this._systemOutPrintStream = System.out;
    }

    private static class SecurePrintStreamByteArrayOutputStream
    extends ByteArrayOutputStream {
        private SecurePrintStream _securePrintStream;

        private SecurePrintStreamByteArrayOutputStream() {
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            if (this._securePrintStream != null) {
                this._securePrintStream.flush();
            }
        }

        public void setSecurePrintStream(SecurePrintStream securePrintStream) {
            this._securePrintStream = securePrintStream;
        }
    }
}

