/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.json.JSONObject;

public class RebaseErrorTopLevelBuild
extends TopLevelBuild {
    private boolean _validResult;

    public RebaseErrorTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getResult() {
        if (this._validResult) {
            return this.result;
        }
        super.getResult();
        if (this.result == null) {
            return this.result;
        }
        try {
            if (this.result.equals("SUCCESS")) {
                String string = this.result = "FAILURE";
                return string;
            }
            if (!this.result.equals("FAILURE")) {
                String string = this.result;
                return string;
            }
            long time = System.currentTimeMillis();
            Map<String, String> stopPropertiesTempMap = this.getStopPropertiesTempMap();
            while (!stopPropertiesTempMap.containsKey("TOP_LEVEL_GITHUB_COMMENT_ID")) {
                if (System.currentTimeMillis() - time > 300000L) {
                    System.out.println("No entry exists for TOP_LEVEL_GITHUB_COMMENT_ID in stop.properties");
                    String string = this.result;
                    return string;
                }
                JenkinsResultsParserUtil.sleep(10000L);
                stopPropertiesTempMap = this.getStopPropertiesTempMap();
            }
            if (this.matchCommentTokens(this.getActualCommentTokens(stopPropertiesTempMap), this.getExpectedCommentTokens())) {
                this.result = "SUCCESS";
            }
            String string = this.result;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while trying to match the actual output with the expected output", e);
        }
        finally {
            this._validResult = true;
        }
    }

    protected List<String> getActualCommentTokens(Map<String, String> stopPropertiesTempMap) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("https://api.github.com/repos/");
        sb.append(this.getParameterValue("GITHUB_RECEIVER_USERNAME"));
        sb.append("/");
        sb.append("liferay-portal-ee");
        sb.append("/issues/comments/");
        sb.append(stopPropertiesTempMap.get("TOP_LEVEL_GITHUB_COMMENT_ID"));
        JSONObject jsonObject = this.getJSONObjectFromURL(sb.toString());
        String commentBody = jsonObject.getString("body");
        Element rootElement = this.getElement(commentBody);
        return this.getCommentTokens(rootElement);
    }

    protected List<String> getCommentTokens(Element element) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add("tag: " + element.getName() + " text: " + element.getText());
        List elementObjects = element.elements();
        for (Object childElementObject : elementObjects) {
            tokens.addAll(this.getCommentTokens((Element)childElementObject));
        }
        List attributeObjects = element.attributes();
        for (Object attributeObject : attributeObjects) {
            Attribute attribute = (Attribute)attributeObject;
            tokens.add("tag: " + element.getName() + " attribute: " + attribute.getName() + " text: " + attribute.getValue());
        }
        return tokens;
    }

    protected Element getElement(String content) {
        try {
            Document document = Dom4JUtil.parse(JenkinsResultsParserUtil.combine("<div>", content, "</div>"));
            return document.getRootElement();
        }
        catch (DocumentException de) {
            throw new RuntimeException("Unable to parse XML", de);
        }
    }

    protected List<String> getExpectedCommentTokens() throws IOException {
        Element rootElement = null;
        Class<?> clazz = this.getClass();
        String resource = JenkinsResultsParserUtil.readInputStream(clazz.getResourceAsStream("RebaseErrorTopLevelBuildTemplate.html"));
        rootElement = this.getElement(resource);
        return this.getCommentTokens(rootElement);
    }

    protected JSONObject getJSONObjectFromURL(String url) throws IOException {
        Properties properties = JenkinsResultsParserUtil.getBuildProperties();
        StringBuilder sb = new StringBuilder();
        URL urlObject = new URL(url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)urlObject.openConnection();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setRequestProperty("Authorization", "token " + properties.getProperty("github.access.token"));
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        InputStream inputStream = httpURLConnection.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line);
        }
        bufferedReader.close();
        return new JSONObject(sb.toString());
    }

    protected boolean matchCommentTokens(List<String> actualCommentTokens, List<String> expectedCommentTokens) {
        for (int i = 0; i < expectedCommentTokens.size(); ++i) {
            System.out.println();
            System.out.println("Test " + i);
            Pattern pattern = Pattern.compile(expectedCommentTokens.get(i).replaceAll("\\s+", "\\\\s*"));
            Matcher matcher = pattern.matcher(actualCommentTokens.get(i));
            System.out.println("'" + expectedCommentTokens.get(i) + "'");
            System.out.println("pattern: " + pattern.pattern());
            System.out.println("'" + actualCommentTokens.get(i) + "'");
            if (!matcher.find()) {
                System.out.println("Tokens mismatched");
                return false;
            }
            System.out.println("Tokens matched");
        }
        return true;
    }
}

