/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import java.util.Hashtable;
import org.dom4j.Element;

public class LocalGitMirrorFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final String _LOCAL_GIT_FAILURE_END_STRING = "BUILD FAILED";
    private static final String _LOCAL_GIT_FAILURE_START_STRING = "Too many retries while synchronizing GitHub pull request.";

    @Override
    public String getMessage(String buildURL, String consoleOutput, Hashtable<?, ?> properties) {
        if (!consoleOutput.contains(_LOCAL_GIT_FAILURE_END_STRING) || !consoleOutput.contains(_LOCAL_GIT_FAILURE_START_STRING)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>Unable to synchronize with <strong>local Git mirror");
        sb.append("</strong>.</p>");
        int end = consoleOutput.indexOf(_LOCAL_GIT_FAILURE_END_STRING);
        int start = consoleOutput.lastIndexOf(_LOCAL_GIT_FAILURE_START_STRING, end);
        consoleOutput = consoleOutput.substring(start, end);
        int minIndex = consoleOutput.length();
        for (String string : new String[]{"error: ", "fatal: "}) {
            int index = consoleOutput.indexOf(string);
            if (index == -1 || index >= minIndex) continue;
            minIndex = index;
        }
        int gitCommandIndex = consoleOutput.lastIndexOf("+ git", minIndex);
        if (gitCommandIndex != -1) {
            start = gitCommandIndex;
        }
        start = consoleOutput.lastIndexOf("\n", start);
        end = consoleOutput.lastIndexOf("\n");
        sb.append(this.getConsoleOutputSnippet(consoleOutput, false, start, end));
        return sb.toString();
    }

    @Override
    public Element getMessageElement(Build build) {
        String consoleText = build.getConsoleText();
        if (!consoleText.contains(_LOCAL_GIT_FAILURE_END_STRING) || !consoleText.contains(_LOCAL_GIT_FAILURE_START_STRING)) {
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div");
        Dom4JUtil.getNewElement("p", messageElement, "Unable to synchronize with ", Dom4JUtil.getNewElement("strong", null, "local Git mirror"), ".");
        int end = consoleText.indexOf(_LOCAL_GIT_FAILURE_END_STRING);
        int start = consoleText.lastIndexOf(_LOCAL_GIT_FAILURE_START_STRING, end);
        consoleText = consoleText.substring(start, end);
        int minIndex = consoleText.length();
        for (String string : new String[]{"error: ", "fatal: "}) {
            int index = consoleText.indexOf(string);
            if (index == -1 || index >= minIndex) continue;
            minIndex = index;
        }
        int gitCommandIndex = consoleText.lastIndexOf("+ git", minIndex);
        if (gitCommandIndex != -1) {
            start = gitCommandIndex;
        }
        start = consoleText.lastIndexOf("\n", start);
        end = consoleText.lastIndexOf("\n");
        messageElement.add(this.getConsoleOutputSnippetElement(consoleText, false, start, end));
        return messageElement;
    }
}

