/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class JenkinsMaster
implements Comparable<JenkinsMaster> {
    protected static long maxRecentBatchAge = 120000L;
    private boolean _available;
    private final Map<Long, Integer> _batchSizes = new TreeMap<Long, Integer>();
    private final String _masterName;
    private final String _masterURL;
    private int _reportedAvailableSlavesCount;
    private String _summary;

    public JenkinsMaster(String masterName, String masterURL) {
        this._masterName = masterName;
        this._masterURL = masterURL;
    }

    public synchronized void addRecentBatch(int batchSize) {
        this._batchSizes.put(System.currentTimeMillis() + maxRecentBatchAge, batchSize);
        this.getAvailableSlavesCount();
    }

    @Override
    public int compareTo(JenkinsMaster jenkinsMaster) {
        int result;
        Integer availableSlavesCount = this.getAvailableSlavesCount();
        int value = availableSlavesCount.compareTo(jenkinsMaster.getAvailableSlavesCount());
        if (value != 0) {
            return -value;
        }
        Random random = new Random();
        while ((result = random.nextInt(3) - 1) == 0) {
        }
        return result;
    }

    public int getAvailableSlavesCount() {
        int recentBatchSizesTotal = this._getRecentBatchSizesTotal();
        StringBuilder sb = new StringBuilder();
        sb.append("{availableSlavesCount=");
        int availableSlavesCount = this._reportedAvailableSlavesCount - recentBatchSizesTotal;
        sb.append(availableSlavesCount);
        sb.append(", masterURL=");
        sb.append(this._masterURL);
        sb.append(", recentBatchSizesTotal=");
        sb.append(recentBatchSizesTotal);
        sb.append(", reportedAvailableSlavesCount=");
        sb.append(this._reportedAvailableSlavesCount);
        sb.append("}");
        this._summary = sb.toString();
        return availableSlavesCount;
    }

    public String getMasterName() {
        return this._masterName;
    }

    public boolean isAvailable() {
        return this._available;
    }

    public String toString() {
        this.getAvailableSlavesCount();
        return this._summary;
    }

    public void update() {
        JSONObject computerJSONObject = null;
        JSONObject queueJSONObject = null;
        try {
            computerJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.combine(this._masterURL, "/computer/api/json?tree=computer[displayName,", "idle,offline]")), false, 5000);
            queueJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(this._masterURL + "/queue/api/json?tree=items[task[name],why]"), false, 5000);
        }
        catch (Exception e) {
            System.out.println("Unable to read " + this._masterURL);
            this._available = false;
            return;
        }
        this._available = true;
        int idleCount = 0;
        JSONArray computerJSONArray = computerJSONObject.getJSONArray("computer");
        for (int i = 0; i < computerJSONArray.length(); ++i) {
            String displayName;
            JSONObject curComputerJSONObject = computerJSONArray.getJSONObject(i);
            if (!curComputerJSONObject.getBoolean("idle") || curComputerJSONObject.getBoolean("offline") || (displayName = curComputerJSONObject.getString("displayName")).equals("master")) continue;
            ++idleCount;
        }
        int queueCount = 0;
        if (queueJSONObject.has("items")) {
            JSONArray itemsJSONArray = queueJSONObject.getJSONArray("items");
            for (int i = 0; i < itemsJSONArray.length(); ++i) {
                String why;
                JSONObject taskJSONObject;
                String taskName;
                JSONObject itemJSONObject = itemsJSONArray.getJSONObject(i);
                if (itemJSONObject.has("task") && (taskName = (taskJSONObject = itemJSONObject.getJSONObject("task")).getString("name")).equals("verification-node") || itemJSONObject.has("why") && (why = itemJSONObject.getString("why")).endsWith("is offline")) continue;
                ++queueCount;
            }
        }
        this._reportedAvailableSlavesCount = idleCount - queueCount;
        this.getAvailableSlavesCount();
    }

    private synchronized int _getRecentBatchSizesTotal() {
        long currentTimestamp = System.currentTimeMillis();
        int recentBatchSizesTotal = 0;
        ArrayList<Long> expiredTimestamps = new ArrayList<Long>(this._batchSizes.size());
        for (long expirationTimestamp : this._batchSizes.keySet()) {
            if (expirationTimestamp < currentTimestamp) {
                expiredTimestamps.add(expirationTimestamp);
                continue;
            }
            recentBatchSizesTotal += this._batchSizes.get(expirationTimestamp).intValue();
        }
        for (Long expiredTimestamp : expiredTimestamps) {
            this._batchSizes.remove(expiredTimestamp);
        }
        return recentBatchSizesTotal;
    }
}

