/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JenkinsConsoleTextLoader {
    protected String buildURL;
    protected boolean hasMoreData = true;
    protected StringBuilder logStringBuilder;
    protected long serverLogSize;
    private static final Pattern _anchorPattern = Pattern.compile("\\<a[^>]*\\>(?<text>[^<]*)\\</a\\>");

    public JenkinsConsoleTextLoader(String buildURL) {
        this.buildURL = JenkinsResultsParserUtil.getLocalURL(buildURL);
        this.logStringBuilder = new StringBuilder();
        this.serverLogSize = 0L;
    }

    public String getConsoleText() {
        if (this.buildURL.startsWith("file:") || this.buildURL.contains("mirrors")) {
            try {
                return JenkinsResultsParserUtil.toString(this.buildURL + "/consoleText");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        this.update();
        return this.logStringBuilder.toString();
    }

    public int getLineCount() {
        String consoleLog = this.logStringBuilder.toString();
        String[] consoleLogLines = consoleLog.split("\n");
        return consoleLogLines.length;
    }

    public boolean hasMoreData() {
        return this.hasMoreData;
    }

    protected void update() {
        StringBuilder sb = new StringBuilder();
        boolean behindLatest = true;
        while (behindLatest) {
            String url = this.buildURL + "/logText/progressiveHtml?start=" + this.serverLogSize;
            try {
                URL urlObject = new URL(JenkinsResultsParserUtil.getLocalURL(url));
                HttpURLConnection httpURLConnection = (HttpURLConnection)urlObject.openConnection();
                long latestServerLogSize = httpURLConnection.getHeaderFieldLong("X-Text-Size", this.serverLogSize);
                if (latestServerLogSize > this.serverLogSize) {
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                        String line = bufferedReader.readLine();
                        while (line != null) {
                            Matcher matcher = _anchorPattern.matcher(line);
                            line = matcher.replaceAll("$1");
                            sb.append(line);
                            sb.append("\n");
                            line = bufferedReader.readLine();
                        }
                    }
                }
                this.hasMoreData = Boolean.parseBoolean(httpURLConnection.getHeaderField("X-More-Data"));
                if (latestServerLogSize - this.serverLogSize < 5000L || !this.hasMoreData) {
                    behindLatest = false;
                }
                this.serverLogSize = latestServerLogSize;
            }
            catch (MalformedURLException murle) {
                throw new IllegalArgumentException("Invalid buildURL " + this.buildURL, murle);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to update console log", ioe);
            }
        }
        if (sb.length() > 0) {
            this.logStringBuilder.append((CharSequence)sb);
        }
    }
}

