/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.jcraft.jsch.Session;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CleanCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.json.JSONObject;

public class GitWorkingDirectory {
    private static final List<RepositoryState> _rebaseRepositoryStates = Arrays.asList(RepositoryState.REBASING, RepositoryState.REBASING_INTERACTIVE, RepositoryState.REBASING_MERGE, RepositoryState.REBASING_REBASING);
    private final Git _git;
    private File _gitDirectory;
    private List<RemoteConfig> _remoteConfigs;
    private final Repository _repository;
    private final String _repositoryName;
    private final String _repositoryUsername;
    private final String _upstreamBranchName;
    private File _workingDirectory;

    public static String getGitHubUserName(RemoteConfig remoteConfig) throws GitAPIException {
        String remoteURL = GitWorkingDirectory.getRemoteURL(remoteConfig);
        if (!remoteURL.contains("github.com")) {
            throw new IllegalArgumentException(JenkinsResultsParserUtil.combine(remoteConfig.getName(), " does not point to a GitHub repository"));
        }
        String userName = null;
        userName = remoteURL.startsWith("https://github.com/") ? remoteURL.substring("https://github.com/".length()) : remoteURL.substring("git@github.com:".length());
        return userName.substring(0, userName.indexOf("/"));
    }

    public GitWorkingDirectory(String upstreamBranchName, String workingDirectory) throws GitAPIException, IOException {
        this._upstreamBranchName = upstreamBranchName;
        this.setWorkingDirectory(workingDirectory);
        this.waitForIndexLock();
        FileRepositoryBuilder fileRepositoryBuilder = new FileRepositoryBuilder();
        fileRepositoryBuilder.setGitDir(this._gitDirectory);
        fileRepositoryBuilder.setWorkTree(this._workingDirectory);
        this._repository = fileRepositoryBuilder.build();
        this._git = new Git(this._repository);
        this._repositoryName = this.loadRepositoryName();
        this._repositoryUsername = this.loadRepositoryUsername();
    }

    public RemoteConfig addRemote(boolean force, String remoteName, String remoteURL) throws GitAPIException {
        System.out.println(JenkinsResultsParserUtil.combine("Adding remote ", remoteName, " with url: ", remoteURL));
        RemoteConfig remoteConfig = this.getRemoteConfig(remoteName);
        if (remoteConfig != null) {
            if (force) {
                this.removeRemote(remoteConfig);
            } else {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Remote ", remoteName, " already exists"));
            }
        }
        Process process = null;
        try {
            process = JenkinsResultsParserUtil.executeBashCommands(true, this._workingDirectory, 10000L, JenkinsResultsParserUtil.combine("git remote add ", remoteName, " ", remoteURL));
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to add remote " + remoteName, e);
        }
        if (process != null && process.exitValue() != 0) {
            try {
                System.out.println(JenkinsResultsParserUtil.readInputStream(process.getErrorStream()));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to add remote ", remoteName));
        }
        this._remoteConfigs = null;
        return this.getRemoteConfig(remoteName);
    }

    public boolean branchExists(String branchName, RemoteConfig remoteConfig) throws GitAPIException {
        List<String> branchNames = null;
        branchNames = remoteConfig == null ? this.getLocalBranchNames() : this.getRemoteBranchNames(remoteConfig);
        return branchNames.contains(branchName);
    }

    public void checkoutBranch(String branchName) throws GitAPIException {
        this.checkoutBranch(branchName, "-f");
    }

    public void checkoutBranch(String branchName, String options) throws GitAPIException {
        String currentBranchName = this.getCurrentBranch();
        List<String> localBranchNames = this.getLocalBranchNames();
        if (!branchName.contains("/") && !localBranchNames.contains(branchName)) {
            throw new IllegalArgumentException(JenkinsResultsParserUtil.combine("Unable to checkout ", branchName, " because it does not exist"));
        }
        if (currentBranchName.equals(branchName)) {
            System.out.println(branchName + " is already checked out");
            return;
        }
        System.out.println(JenkinsResultsParserUtil.combine("The current branch is ", currentBranchName, ". Checking out branch ", branchName, "."));
        this.waitForIndexLock();
        StringBuilder sb = new StringBuilder();
        sb.append("git checkout ");
        if (options != null) {
            sb.append(options);
            sb.append(" ");
        }
        sb.append(branchName);
        Process process = null;
        try {
            process = JenkinsResultsParserUtil.executeBashCommands(true, this._workingDirectory, 600000L, sb.toString());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to checkout branch " + branchName, e);
        }
        if (process != null && process.exitValue() != 0) {
            try {
                System.out.println(JenkinsResultsParserUtil.readInputStream(process.getErrorStream()));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to checkout branch ", branchName));
        }
        int timeout = 0;
        File headFile = new File(this._gitDirectory, "HEAD");
        String expectedContent = null;
        if (!branchName.contains("/")) {
            expectedContent = JenkinsResultsParserUtil.combine("ref: refs/heads/", branchName);
        } else {
            int i = branchName.indexOf("/");
            String remoteBranchName = branchName.substring(i + 1);
            String remoteName = branchName.substring(0, i);
            expectedContent = this.getBranchSHA(remoteBranchName, this.getRemoteConfig(remoteName));
        }
        do {
            String headContent = null;
            try {
                headContent = JenkinsResultsParserUtil.read(headFile);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to read file " + headFile.getPath(), ioe);
            }
            headContent = headContent.trim();
            if (headContent.equals(expectedContent)) {
                return;
            }
            System.out.println(JenkinsResultsParserUtil.combine("HEAD file content is currently: ", headContent, ". Waiting for branch to be updated."));
            JenkinsResultsParserUtil.sleep(5000L);
        } while (++timeout < 59);
        if (branchName.equals(this.getCurrentBranch())) {
            return;
        }
        throw new RuntimeException("Unable to checkout branch " + branchName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() throws GitAPIException {
        StoredConfig storedConfig = this._repository.getConfig();
        boolean requireForce = storedConfig.getBoolean("clean", "requireForce", true);
        if (requireForce) {
            this.updateConfig("clean", null, "requireForce", false);
        }
        try {
            CleanCommand cleanCommand = this._git.clean();
            cleanCommand.setCleanDirectories(true);
            cleanCommand.setIgnore(true);
            System.out.println("Cleaning repository");
            cleanCommand.call();
        }
        finally {
            if (requireForce) {
                this.updateConfig("clean", null, "requireForce", null);
            }
        }
    }

    public void commitFileToCurrentBranch(String fileName, String message) throws GitAPIException {
        System.out.println("Committing file to current branch " + fileName);
        this.stageFileInCurrentBranch(fileName);
        this.commitStagedFilesToCurrentBranch(message);
    }

    public void commitStagedFilesToCurrentBranch(String message) throws GitAPIException {
        System.out.println("Committing staged files to current branch");
        CommitCommand commitCommand = this._git.commit();
        commitCommand.setMessage(message);
        commitCommand.call();
    }

    public void createLocalBranch(String branchName) throws GitAPIException {
        this.createLocalBranch(branchName, false, null);
    }

    public void createLocalBranch(String branchName, boolean force, String startPoint) throws GitAPIException {
        System.out.println(JenkinsResultsParserUtil.combine("Creating branch ", branchName, " at starting point ", startPoint));
        CreateBranchCommand createBranchCommand = this._git.branchCreate();
        createBranchCommand.setForce(force);
        createBranchCommand.setName(branchName);
        if (startPoint != null) {
            createBranchCommand.setStartPoint(startPoint);
        }
        createBranchCommand.call();
    }

    public String createPullRequest(String body, String pullRequestBranchName, String receiverUserName, String title) throws IOException {
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("base", (Object)this._upstreamBranchName);
        requestJSONObject.put("body", (Object)body);
        requestJSONObject.put("head", (Object)(receiverUserName + ":" + pullRequestBranchName));
        requestJSONObject.put("title", (Object)title);
        String url = JenkinsResultsParserUtil.combine("https://api.github.com/repos/", receiverUserName, "/", this._repositoryName, "/pulls");
        JSONObject responseJSONObject = JenkinsResultsParserUtil.toJSONObject(url, requestJSONObject.toString());
        String pullRequestURL = responseJSONObject.getString("html_url");
        System.out.println("Created a pull request at " + pullRequestURL);
        return pullRequestURL;
    }

    public void deleteLocalBranch(String localBranchName) throws GitAPIException {
        System.out.println("Deleting local branch " + localBranchName);
        DeleteBranchCommand deleteBranchCommand = this._git.branchDelete();
        deleteBranchCommand.setBranchNames(new String[]{localBranchName});
        deleteBranchCommand.setForce(true);
        deleteBranchCommand.call();
    }

    public void fetch(RefSpec refSpec, RemoteConfig remoteConfig) throws GitAPIException {
        StringBuilder sb = new StringBuilder();
        sb.append("git fetch --progress -v -f ");
        sb.append(GitWorkingDirectory.getRemoteURL(remoteConfig));
        if (refSpec == null) {
            System.out.println(JenkinsResultsParserUtil.combine("Fetching from ", GitWorkingDirectory.getRemoteURL(remoteConfig)));
            List fetchRefSpecs = remoteConfig.getFetchRefSpecs();
            for (RefSpec fetchRefSpec : fetchRefSpecs) {
                sb.append(" ");
                sb.append(fetchRefSpec.toString());
            }
        } else {
            System.out.println(JenkinsResultsParserUtil.combine("Fetching from ", GitWorkingDirectory.getRemoteURL(remoteConfig), " ", refSpec.toString()));
            sb.append(" ");
            sb.append(refSpec.toString());
        }
        int retries = 0;
        long start = System.currentTimeMillis();
        try {
            Process process = JenkinsResultsParserUtil.executeBashCommands(true, this.getWorkingDirectory(), 1800000L, sb.toString());
            if (process != null && process.exitValue() != 0) {
                try {
                    System.out.println(JenkinsResultsParserUtil.readInputStream(process.getErrorStream()));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                throw new RuntimeException("Unable to fetch");
            }
            if (process == null) {
                throw new RuntimeException("Process failed to run");
            }
            System.out.println(JenkinsResultsParserUtil.readInputStream(process.getInputStream()));
        }
        catch (Exception e) {
            if (retries < 3) {
                System.out.println(JenkinsResultsParserUtil.combine("Fetch attempt ", Integer.toString(retries), " failed with an exception. ", e.getMessage(), "\nRetrying."));
                ++retries;
                JenkinsResultsParserUtil.sleep(30000L);
            }
            throw new RuntimeException(e);
        }
        System.out.println("Fetch completed in " + JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start));
    }

    public void fetch(String localBranchName, String remoteBranchName, RemoteConfig remoteConfig) throws GitAPIException {
        RefSpec refSpec = new RefSpec(JenkinsResultsParserUtil.combine("refs/heads/", remoteBranchName, ":", "refs/heads/", localBranchName));
        this.fetch(refSpec, remoteConfig);
    }

    public List<String> getBranchNamesContainingSHA(String sha) {
        String command = "git branch --contains " + sha;
        try {
            Process process = JenkinsResultsParserUtil.executeBashCommands(true, this.getWorkingDirectory(), 120000L, command);
            String output = JenkinsResultsParserUtil.readInputStream(process.getInputStream());
            if (output.contains("no such commit")) {
                return Collections.emptyList();
            }
            System.out.println(output);
            String[] outputLines = output.split("\n");
            ArrayList<String> branchNamesList = new ArrayList<String>(outputLines.length - 1);
            for (String outputLine : outputLines) {
                if (branchNamesList.size() == outputLines.length - 1) break;
                String branchName = outputLine.trim();
                if (branchName.startsWith("* ")) {
                    branchName = branchName.substring(2);
                }
                branchNamesList.add(branchName);
            }
            return branchNamesList;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to find branches with SHA " + sha, e);
        }
    }

    public List<Ref> getBranchRefs() throws GitAPIException {
        ListBranchCommand listBranchCommand = this._git.branchList();
        listBranchCommand.setListMode(ListBranchCommand.ListMode.ALL);
        return listBranchCommand.call();
    }

    public String getBranchSHA(String branchName) throws GitAPIException {
        String command = "git rev-parse " + branchName;
        try {
            Process process = JenkinsResultsParserUtil.executeBashCommands(true, this.getWorkingDirectory(), 120000L, command);
            String output = JenkinsResultsParserUtil.readInputStream(process.getInputStream());
            String firstLine = output.substring(0, output.indexOf("\n"));
            return firstLine.trim();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to get SHA of branch " + branchName);
        }
    }

    public String getBranchSHA(String branchName, RemoteConfig remoteConfig) throws GitAPIException {
        if (remoteConfig == null) {
            return this.getBranchSHA(branchName);
        }
        String remoteURL = GitWorkingDirectory.getRemoteURL(remoteConfig);
        if (remoteURL.contains("git@github.com")) {
            return this.getGitHubBranchSHA(branchName, remoteConfig);
        }
        LsRemoteCommand lsRemoteCommand = Git.lsRemoteRepository();
        lsRemoteCommand.setHeads(true);
        lsRemoteCommand.setRemote(remoteURL);
        lsRemoteCommand.setTags(false);
        Collection remoteRefs = lsRemoteCommand.call();
        for (Ref remoteRef : remoteRefs) {
            String completeBranchName = "refs/heads/" + branchName;
            if (!completeBranchName.equals(remoteRef.getName())) continue;
            return remoteRef.getObjectId().getName();
        }
        return null;
    }

    public String getCurrentBranch() {
        this.waitForIndexLock();
        try {
            return this._repository.getBranch();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get current branch name from repository", ioe);
        }
    }

    public Git getGit() {
        return this._git;
    }

    public File getGitDirectory() {
        return this._gitDirectory;
    }

    public String getGitHubBranchSHA(String branchName, RemoteConfig remoteConfig) {
        String command = JenkinsResultsParserUtil.combine("git ls-remote ", GitWorkingDirectory.getRemoteURL(remoteConfig), " ", branchName);
        try {
            Process process = JenkinsResultsParserUtil.executeBashCommands(command);
            if (process.exitValue() != 0) {
                System.out.println(JenkinsResultsParserUtil.readInputStream(process.getErrorStream()));
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get branch sha for ", branchName, " on ", GitWorkingDirectory.getRemoteURL(remoteConfig)));
            }
            String output = JenkinsResultsParserUtil.readInputStream(process.getInputStream());
            for (String line : output.split("\n")) {
                if (!line.endsWith("refs/heads/" + branchName)) continue;
                return line.substring(0, line.indexOf("\t"));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public List<String> getLocalBranchNames() throws GitAPIException {
        ArrayList<Ref> allLocalBranchRefs = new ArrayList<Ref>();
        for (Ref branchRef : this.getBranchRefs()) {
            String branchName = branchRef.getName();
            if (!branchName.startsWith("refs/heads")) continue;
            allLocalBranchRefs.add(branchRef);
        }
        return this.toShortNameList(allLocalBranchRefs);
    }

    public List<String> getRemoteBranchNames(RemoteConfig remoteConfig) throws GitAPIException {
        LsRemoteCommand lsRemoteCommand = Git.lsRemoteRepository();
        lsRemoteCommand.setHeads(true);
        lsRemoteCommand.setRemote(GitWorkingDirectory.getRemoteURL(remoteConfig));
        lsRemoteCommand.setTags(false);
        List<String> remoteBranchNames = this.toShortNameList(lsRemoteCommand.call());
        Collections.sort(remoteBranchNames);
        return remoteBranchNames;
    }

    public RemoteConfig getRemoteConfig(String remoteName) throws GitAPIException {
        if (remoteName.equals("upstream")) {
            return this._getUpstreamRemoteConfig();
        }
        return this._getRemoteConfig(remoteName);
    }

    public List<RemoteConfig> getRemoteConfigs() throws GitAPIException {
        if (this._remoteConfigs != null) {
            return this._remoteConfigs;
        }
        try {
            this._remoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this._repository.getConfig());
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException(urise);
        }
        return this._remoteConfigs;
    }

    public Set<String> getRemoteNames() throws GitAPIException {
        List<RemoteConfig> remoteConfigs = this.getRemoteConfigs();
        HashSet<String> remoteNames = new HashSet<String>(remoteConfigs.size());
        for (RemoteConfig remoteConfig : remoteConfigs) {
            remoteNames.add(remoteConfig.getName());
        }
        return remoteNames;
    }

    public String getRepositoryName() {
        return this._repositoryName;
    }

    public String getRepositoryUsername() {
        return this._repositoryUsername;
    }

    public String getUpstreamBranchName() {
        return this._upstreamBranchName;
    }

    public File getWorkingDirectory() {
        return this._workingDirectory;
    }

    public boolean pushToRemote(boolean force, RemoteConfig remoteConfig) throws GitAPIException {
        return this.pushToRemote(force, this.getCurrentBranch(), remoteConfig);
    }

    public boolean pushToRemote(boolean force, String remoteBranchName, RemoteConfig remoteConfig) throws GitAPIException {
        return this.pushToRemote(force, this.getCurrentBranch(), remoteBranchName, remoteConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushToRemote(boolean force, String remoteBranchName, String remoteURL) throws GitAPIException {
        RemoteConfig remoteConfig = null;
        try {
            remoteConfig = this.addRemote(true, "temp", remoteURL);
            boolean bl = this.pushToRemote(force, remoteBranchName, remoteConfig);
            this.removeRemote(remoteConfig);
            return bl;
        }
        catch (Throwable throwable) {
            this.removeRemote(remoteConfig);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushToRemote(boolean force, String localBranchName, String remoteBranchName, RemoteConfig remoteConfig) throws GitAPIException {
        String remoteURL = GitWorkingDirectory.getRemoteURL(remoteConfig);
        System.out.println(JenkinsResultsParserUtil.combine("Pushing ", localBranchName, " to ", remoteURL, " ", remoteBranchName));
        PushCommand pushCommand = null;
        Git git = this._git;
        synchronized (git) {
            pushCommand = this._git.push();
        }
        String remoteRefName = "refs/heads/" + remoteBranchName;
        RefSpec refSpec = new RefSpec(JenkinsResultsParserUtil.combine(localBranchName, ":", remoteRefName));
        PushCommand pushCommand2 = pushCommand;
        synchronized (pushCommand2) {
            pushCommand.setForce(force);
            pushCommand.setRefSpecs(new RefSpec[]{refSpec});
            pushCommand.setRemote(remoteURL);
            for (PushResult pushResult : pushCommand.call()) {
                for (RemoteRefUpdate remoteRefUpdate : pushResult.getRemoteUpdates()) {
                    if (remoteRefUpdate == null || remoteRefUpdate.getStatus() == RemoteRefUpdate.Status.OK) continue;
                    System.out.println(JenkinsResultsParserUtil.combine("Unable to push ", localBranchName, " to ", GitWorkingDirectory.getRemoteURL(remoteConfig), ".\nPush response: ", remoteRefUpdate.toString()));
                    return false;
                }
            }
            return true;
        }
    }

    public void rebase(boolean abortOnFail, String sourceBranchName, String targetBranchName) throws GitAPIException {
        String rebaseCommand = JenkinsResultsParserUtil.combine("git rebase ", sourceBranchName, " ", targetBranchName);
        String sourceBranchSHA = this.getBranchSHA(sourceBranchName);
        System.out.println(JenkinsResultsParserUtil.combine("Rebasing ", sourceBranchName, "(", sourceBranchSHA, ") to ", targetBranchName));
        try {
            List<String> branchNamesContainingSourceBranchSHA;
            Process process = JenkinsResultsParserUtil.executeBashCommands(true, this.getWorkingDirectory(), 600000L, rebaseCommand);
            if (process != null && process.exitValue() != 0) {
                try {
                    System.out.println(JenkinsResultsParserUtil.readInputStream(process.getErrorStream()));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                throw new RuntimeException("Unable to rebase");
            }
            if (process != null) {
                System.out.println(JenkinsResultsParserUtil.readInputStream(process.getInputStream()));
            }
            for (int i = 0; i < 10 && !(branchNamesContainingSourceBranchSHA = this.getBranchNamesContainingSHA(sourceBranchSHA)).contains(targetBranchName); ++i) {
                JenkinsResultsParserUtil.sleep(30000L);
            }
        }
        catch (Exception e) {
            RepositoryState repositoryState = this._repository.getRepositoryState();
            try {
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to rebase ", targetBranchName, " to ", sourceBranchName, ". Repository is in the ", repositoryState.toString(), " state."), e);
            }
            catch (Throwable throwable) {
                if (abortOnFail) {
                    this.rebaseAbort();
                }
                throw throwable;
            }
        }
    }

    public void rebaseAbort() throws GitAPIException {
        if (!_rebaseRepositoryStates.contains(this._repository.getRepositoryState())) {
            return;
        }
        RebaseCommand rebaseCommand = this._git.rebase();
        rebaseCommand.setOperation(RebaseCommand.Operation.ABORT);
        System.out.println("Aborting rebase " + RebaseCommand.Operation.ABORT.toString());
        rebaseCommand.call();
    }

    public boolean remoteExists(String remoteName) throws GitAPIException {
        Set<String> remoteNames = this.getRemoteNames();
        return remoteNames.contains(remoteName);
    }

    public void removeRemote(RemoteConfig remoteConfig) {
        try {
            if (!this.remoteExists(remoteConfig.getName())) {
                return;
            }
            System.out.println("Removing remote " + remoteConfig.getName());
            Process process = null;
            try {
                process = JenkinsResultsParserUtil.executeBashCommands(true, this._workingDirectory, 60000L, "git remote rm " + remoteConfig.getName());
            }
            catch (IOException | InterruptedException | RuntimeException e) {
                throw new RuntimeException("Unable to remove remote " + remoteConfig.getName(), e);
            }
            if (process != null && process.exitValue() != 0) {
                try {
                    System.out.println(JenkinsResultsParserUtil.readInputStream(process.getErrorStream()));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to remove remote", remoteConfig.getName()));
            }
            if (this._remoteConfigs.contains(remoteConfig)) {
                this._remoteConfigs.remove(remoteConfig);
            } else {
                this._remoteConfigs = null;
            }
        }
        catch (GitAPIException gapie) {
            gapie.printStackTrace();
        }
    }

    public void removeRemotes(List<RemoteConfig> remoteConfigs) {
        for (RemoteConfig remoteConfig : remoteConfigs) {
            this.removeRemote(remoteConfig);
        }
    }

    public void reset(String ref, ResetCommand.ResetType resetType) throws GitAPIException {
        if (ref != null && (ref.equals("head") || ref.equals("HEAD"))) {
            ref = null;
        }
        ResetCommand resetCommand = this._git.reset();
        resetCommand.setMode(resetType);
        if (ref != null) {
            resetCommand.setRef(ref);
        } else {
            ref = "HEAD";
        }
        System.out.println(JenkinsResultsParserUtil.combine("Resetting ", resetType.toString(), " to ", ref));
        resetCommand.call();
    }

    public void stageFileInCurrentBranch(String fileName) throws GitAPIException {
        AddCommand addCommand = this._git.add();
        addCommand.addFilepattern(fileName);
        System.out.println("Staging file in current branch " + fileName);
        addCommand.call();
    }

    public void updateConfig(String section, String subsection, String name, Object value) {
        StoredConfig storedConfig = this._repository.getConfig();
        if (value == null) {
            storedConfig.unset(section, subsection, name);
        }
        if (value instanceof Boolean) {
            storedConfig.setBoolean(section, subsection, name, ((Boolean)value).booleanValue());
        }
        if (value instanceof String) {
            storedConfig.setString(section, subsection, name, (String)value);
        }
        try {
            storedConfig.save();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to save configuration change");
        }
    }

    protected static String getRemoteURL(RemoteConfig remoteConfig) {
        List uris = remoteConfig.getURIs();
        URIish uri = (URIish)uris.get(0);
        return uri.toString();
    }

    protected String loadRepositoryName() throws GitAPIException {
        int y;
        int x;
        String remoteURL = GitWorkingDirectory.getRemoteURL(this._getRemoteConfig("upstream"));
        String repositoryName = remoteURL.substring(x = remoteURL.lastIndexOf("/") + 1, y = remoteURL.indexOf(".git"));
        if (repositoryName.equals("liferay-jenkins-tools-private")) {
            return repositoryName;
        }
        if ((repositoryName.equals("liferay-plugins-ee") || repositoryName.equals("liferay-portal-ee")) && !this._upstreamBranchName.contains("ee-") && !this._upstreamBranchName.contains("-private")) {
            repositoryName = repositoryName.replace("-ee", "");
        }
        if (repositoryName.contains("-private") && !this._upstreamBranchName.contains("-private")) {
            repositoryName = repositoryName.replace("-private", "");
        }
        return repositoryName;
    }

    protected String loadRepositoryUsername() throws GitAPIException {
        String remoteURL = GitWorkingDirectory.getRemoteURL(this._getRemoteConfig("upstream"));
        int x = remoteURL.indexOf(":") + 1;
        int y = remoteURL.indexOf("/");
        return remoteURL.substring(x, y);
    }

    protected void setWorkingDirectory(String workingDirectory) throws GitAPIException, IOException {
        this._workingDirectory = new File(workingDirectory);
        if (!this._workingDirectory.exists()) {
            throw new FileNotFoundException(this._workingDirectory.getPath() + " is unavailable");
        }
        this._gitDirectory = new File(workingDirectory, ".git");
        if (!this._gitDirectory.exists()) {
            throw new FileNotFoundException(this._gitDirectory.getPath() + " is unavailable");
        }
    }

    protected List<String> toShortNameList(Collection<Ref> refs) {
        ArrayList<String> shortNames = new ArrayList<String>(refs.size());
        for (Ref ref : refs) {
            String refName = ref.getName();
            shortNames.add(refName.substring(refName.lastIndexOf("/") + 1));
        }
        return shortNames;
    }

    protected void waitForIndexLock() {
        int retries = 0;
        File file = new File(this._gitDirectory, "index.lock");
        while (file.exists()) {
            System.out.println("Waiting for index.lock to be cleared.");
            JenkinsResultsParserUtil.sleep(5000L);
            if (++retries < 24) continue;
            file.delete();
        }
    }

    private RemoteConfig _getRemoteConfig(String remoteName) throws GitAPIException {
        List<RemoteConfig> remoteConfigs = this.getRemoteConfigs();
        for (RemoteConfig remoteConfig : remoteConfigs) {
            if (!remoteName.equals(remoteConfig.getName())) continue;
            return remoteConfig;
        }
        return null;
    }

    private RemoteConfig _getUpstreamPublicRemoteConfig() throws GitAPIException {
        RemoteConfig upstreamPublicRemoteConfig = this._getRemoteConfig("upstream-public");
        if (upstreamPublicRemoteConfig != null) {
            return upstreamPublicRemoteConfig;
        }
        String upstreamRemoteURL = GitWorkingDirectory.getRemoteURL(this._getRemoteConfig("upstream"));
        upstreamRemoteURL = upstreamRemoteURL.replace("-ee", "");
        upstreamRemoteURL = upstreamRemoteURL.replace("-private", "");
        return this.addRemote(true, "upstream-public", upstreamRemoteURL);
    }

    private RemoteConfig _getUpstreamRemoteConfig() throws GitAPIException {
        RemoteConfig upstreamRemoteConfig = this._getRemoteConfig("upstream");
        String upstreamRemoteURL = GitWorkingDirectory.getRemoteURL(upstreamRemoteConfig);
        if (upstreamRemoteURL.contains(this._repositoryName + ".git")) {
            return upstreamRemoteConfig;
        }
        return this._getUpstreamPublicRemoteConfig();
    }

    static {
        JschConfigSessionFactory jschConfigSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setConfig("StrictHostKeyChecking", "no");
            }
        };
        SshSessionFactory.setInstance((SshSessionFactory)jschConfigSessionFactory);
    }
}

