/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayS3Object;
import com.liferay.jenkins.results.parser.testray.TestrayS3ObjectFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class TestrayS3Bucket {
    private static final Pattern _fileNamePattern = Pattern.compile(".*\\.(?!gz)(?<fileExtension>([^\\.]+))(?<gzipFileExtension>\\.gz)?");
    private static final TestrayS3Bucket _testrayS3Bucket = new TestrayS3Bucket();

    public static TestrayS3Bucket getInstance() {
        return _testrayS3Bucket;
    }

    public static boolean googleCredentialsAvailable() {
        String googleApplicationCredentials = System.getenv("GOOGLE_APPLICATION_CREDENTIALS");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(googleApplicationCredentials)) {
            try {
                _testrayS3Bucket._getBucket();
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    public TestrayS3Object createTestrayS3Object(String key, File file) {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        BlobId blobId = BlobId.of((String)this.getName(), (String)key);
        String fileName = file.getName();
        Matcher matcher = _fileNamePattern.matcher(fileName);
        BlobInfo.Builder blobInfoBuilder = BlobInfo.newBuilder((BlobId)blobId);
        if (matcher.find()) {
            String fileExtension = matcher.group("fileExtension");
            if (fileExtension.equals("html")) {
                blobInfoBuilder.setContentType("text/html");
            } else if (fileExtension.equals("jpg")) {
                blobInfoBuilder.setContentType("image/jpeg");
            } else if (fileExtension.equals("json") || fileExtension.equals("txt")) {
                blobInfoBuilder.setContentType("text/plain");
            } else if (fileExtension.equals("xml")) {
                blobInfoBuilder.setContentType("text/xml");
            }
            String gzipFileExtension = matcher.group("gzipFileExtension");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(gzipFileExtension)) {
                blobInfoBuilder.setContentEncoding("gzip");
            }
        }
        BlobInfo blobInfo = blobInfoBuilder.build();
        try {
            Storage storage = this._getStorage();
            Blob blob = storage.create(blobInfo, FileUtils.readFileToByteArray((File)file), new Storage.BlobTargetOption[0]);
            TestrayS3Object testrayS3Object = TestrayS3ObjectFactory.newTestrayS3Object(this, blob);
            System.out.println(JenkinsResultsParserUtil.combine("Created S3 Object ", testrayS3Object.getURLString(), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
            return testrayS3Object;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayS3Object createTestrayS3Object(String key, String value) {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        BlobId blobId = BlobId.of((String)this.getName(), (String)key);
        BlobInfo.Builder blobInfoBuilder = BlobInfo.newBuilder((BlobId)blobId);
        BlobInfo blobInfo = blobInfoBuilder.build();
        Storage storage = this._getStorage();
        Blob blob = storage.create(blobInfo, value.getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        TestrayS3Object testrayS3Object = TestrayS3ObjectFactory.newTestrayS3Object(this, blob);
        System.out.println(JenkinsResultsParserUtil.combine("Created S3 Object ", testrayS3Object.getURLString(), " in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start)));
        return testrayS3Object;
    }

    public List<TestrayS3Object> createTestrayS3Objects(File dir) {
        ArrayList<TestrayS3Object> testrayS3Objects = new ArrayList<TestrayS3Object>();
        if (dir == null || !dir.isDirectory()) {
            return testrayS3Objects;
        }
        for (File file : JenkinsResultsParserUtil.findFiles(dir, ".*")) {
            TestrayS3Object testrayS3Object = this.createTestrayS3Object(JenkinsResultsParserUtil.getPathRelativeTo(file, dir), file);
            testrayS3Objects.add(testrayS3Object);
        }
        return testrayS3Objects;
    }

    public void deleteTestrayS3Object(String key) {
        this.deleteTestrayS3Object(this.getTestrayS3Object(key));
    }

    public void deleteTestrayS3Object(TestrayS3Object testrayS3Object) {
        testrayS3Object.delete();
    }

    public void deleteTestrayS3Objects(List<TestrayS3Object> testrayS3Objects) {
        for (TestrayS3Object testrayS3Object : testrayS3Objects) {
            this.deleteTestrayS3Object(testrayS3Object);
        }
    }

    public String getName() {
        try {
            return JenkinsResultsParserUtil.getBuildProperty("testray.s3.bucket");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public String getTestrayS3BaseURL() {
        return JenkinsResultsParserUtil.combine("https://storage.cloud.google.com/", this.getName());
    }

    public TestrayS3Object getTestrayS3Object(String key) {
        Bucket bucket = this._getBucket();
        Blob blob = bucket.get(key, new Storage.BlobGetOption[0]);
        if (blob == null) {
            return null;
        }
        return TestrayS3ObjectFactory.newTestrayS3Object(this, blob);
    }

    public List<TestrayS3Object> getTestrayS3Objects() {
        ArrayList<TestrayS3Object> testrayS3Objects = new ArrayList<TestrayS3Object>();
        Storage storage = this._getStorage();
        Page blobPage = storage.list(this.getName(), new Storage.BlobListOption[0]);
        for (Blob blob : blobPage.iterateAll()) {
            testrayS3Objects.add(TestrayS3ObjectFactory.newTestrayS3Object(this, blob));
        }
        return testrayS3Objects;
    }

    public URL getURL() {
        try {
            return new URL(JenkinsResultsParserUtil.combine("https://console.cloud.google.com/storage/browser/", this.getName(), "?authuser=0"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private Bucket _getBucket() {
        Storage storage = this._getStorage();
        return storage.get(this.getName(), new Storage.BucketGetOption[0]);
    }

    private Storage _getStorage() {
        StorageOptions storageOptions = StorageOptions.getDefaultInstance();
        return (Storage)storageOptions.getService();
    }
}

