/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayProductVersion;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class TestrayProject {
    private static final int _DELTA = 25;
    private final JSONObject _jsonObject;
    private Map<Integer, TestrayProductVersion> _testrayProductVersionsByID;
    private Map<String, TestrayProductVersion> _testrayProductVersionsByName;
    private Map<Integer, TestrayRoutine> _testrayRoutinesByID;
    private Map<String, TestrayRoutine> _testrayRoutinesByName;
    private final TestrayServer _testrayServer;
    private final URL _url;

    public TestrayProject(TestrayServer testrayServer, JSONObject jsonObject) {
        this._testrayServer = testrayServer;
        this._jsonObject = jsonObject;
        String urlString = JenkinsResultsParserUtil.combine(String.valueOf(testrayServer.getURL()), "/home/-/testray/routines?testrayProjectId=", String.valueOf(this.getID()));
        try {
            this._url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Invalid Testray Project URL " + urlString, malformedURLException);
        }
    }

    public TestrayProductVersion createTestrayProductVersion(String testrayProductVersionName) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(testrayProductVersionName)) {
            throw new RuntimeException("Please set a Testray product version name");
        }
        TestrayProductVersion testrayProductVersion = this.getTestrayProductVersionByName(testrayProductVersionName);
        if (testrayProductVersion != null) {
            return testrayProductVersion;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("name=");
        sb.append(testrayProductVersionName);
        sb.append("&testrayProjectId=");
        sb.append(this.getID());
        String productVersionAddURL = JenkinsResultsParserUtil.combine(String.valueOf(this._testrayServer.getURL()), "/home/-/testray/product_versions/add.json");
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(productVersionAddURL, sb.toString());
            if (jsonObject.has("data")) {
                return new TestrayProductVersion(this, jsonObject.getJSONObject("data"));
            }
            throw new RuntimeException("Failed to create a product version");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public TestrayRoutine createTestrayRoutine(String testrayRoutineName) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(testrayRoutineName)) {
            throw new RuntimeException("Please set a Testray routine name");
        }
        TestrayRoutine testrayRoutine = this.getTestrayRoutineByName(testrayRoutineName);
        if (testrayRoutine != null) {
            return testrayRoutine;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("name=");
        sb.append(testrayRoutineName);
        sb.append("&testrayProjectId=");
        sb.append(this.getID());
        String routineAddURL = JenkinsResultsParserUtil.combine(String.valueOf(this._testrayServer.getURL()), "/home/-/testray/routines/add.json");
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(routineAddURL, sb.toString());
            if (jsonObject.has("data")) {
                return new TestrayRoutine(this, jsonObject.getJSONObject("data"));
            }
            throw new RuntimeException("Failed to create a routine");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public String getDescription() {
        return this._jsonObject.getString("description");
    }

    public int getID() {
        return this._jsonObject.getInt("testrayProjectId");
    }

    public String getName() {
        return this._jsonObject.getString("name");
    }

    public TestrayProductVersion getTestrayProductVersionByID(int productVersionID) {
        this._initTestrayProductVersions();
        return this._testrayProductVersionsByID.get(productVersionID);
    }

    public TestrayProductVersion getTestrayProductVersionByName(String productVersionName) {
        this._initTestrayProductVersions();
        return this._testrayProductVersionsByName.get(productVersionName);
    }

    public TestrayRoutine getTestrayRoutineByID(int routineID) {
        this._initTestrayRoutines();
        return this._testrayRoutinesByID.get(routineID);
    }

    public TestrayRoutine getTestrayRoutineByName(String routineName) {
        this._initTestrayRoutines();
        return this._testrayRoutinesByName.get(routineName);
    }

    public TestrayServer getTestrayServer() {
        return this._testrayServer;
    }

    public URL getURL() {
        return this._url;
    }

    private synchronized void _initTestrayProductVersions() {
        if (this._testrayProductVersionsByID != null && this._testrayProductVersionsByName != null) {
            return;
        }
        this._testrayProductVersionsByID = new HashMap<Integer, TestrayProductVersion>();
        this._testrayProductVersionsByName = new HashMap<String, TestrayProductVersion>();
        TestrayServer testrayServer = this.getTestrayServer();
        int current = 1;
        block6: while (true) {
            try {
                String productVersionAPIURL = JenkinsResultsParserUtil.combine(String.valueOf(testrayServer.getURL()), "/home/-/testray/product_versions/index.json?cur=", String.valueOf(current), "&delta=", String.valueOf(25), "&testrayProjectId=", String.valueOf(this.getID()));
                JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(productVersionAPIURL, true);
                JSONArray dataJSONArray = jsonObject.getJSONArray("data");
                if (dataJSONArray.length() == 0) break;
                int i = 0;
                while (true) {
                    if (i >= dataJSONArray.length()) continue block6;
                    JSONObject dataJSONObject = dataJSONArray.getJSONObject(i);
                    TestrayProductVersion testrayProductVersion = new TestrayProductVersion(this, dataJSONObject);
                    this._testrayProductVersionsByID.put(testrayProductVersion.getID(), testrayProductVersion);
                    this._testrayProductVersionsByName.put(testrayProductVersion.getName(), testrayProductVersion);
                    ++i;
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            finally {
                ++current;
                continue;
            }
            break;
        }
    }

    private synchronized void _initTestrayRoutines() {
        if (this._testrayRoutinesByID != null && this._testrayRoutinesByName != null) {
            return;
        }
        this._testrayRoutinesByID = new HashMap<Integer, TestrayRoutine>();
        this._testrayRoutinesByName = new HashMap<String, TestrayRoutine>();
        int current = 1;
        TestrayServer testrayServer = this.getTestrayServer();
        block6: while (true) {
            try {
                String routineAPIURL = JenkinsResultsParserUtil.combine(String.valueOf(testrayServer.getURL()), "/home/-/testray/routines.json?cur=", String.valueOf(current), "&delta=", String.valueOf(25), "&orderByCol=testrayRoutineId&testrayProjectId=", String.valueOf(this.getID()));
                JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(routineAPIURL, true);
                JSONArray dataJSONArray = jsonObject.getJSONArray("data");
                if (dataJSONArray.length() == 0) break;
                int i = 0;
                while (true) {
                    if (i >= dataJSONArray.length()) continue block6;
                    JSONObject dataJSONObject = dataJSONArray.getJSONObject(i);
                    TestrayRoutine testrayRoutine = new TestrayRoutine(this, dataJSONObject);
                    this._testrayRoutinesByID.put(testrayRoutine.getID(), testrayRoutine);
                    this._testrayRoutinesByName.put(testrayRoutine.getName(), testrayRoutine);
                    ++i;
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            finally {
                ++current;
                continue;
            }
            break;
        }
    }
}

