/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONObject;

public class TestrayProductVersion {
    private final JSONObject _jsonObject;
    private final TestrayProject _testrayProject;
    private final TestrayServer _testrayServer;
    private final URL _url;

    public TestrayProductVersion(TestrayProject testrayProject, JSONObject jsonObject) {
        this._testrayProject = testrayProject;
        this._jsonObject = jsonObject;
        this._testrayServer = this._testrayProject.getTestrayServer();
        String urlString = JenkinsResultsParserUtil.combine(String.valueOf(this._testrayServer.getURL()), "/home/-/testray/product_versions?testrayProjectId=", String.valueOf(this._testrayProject.getID()));
        try {
            this._url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public int getID() {
        return this._jsonObject.getInt("testrayProductVersionId");
    }

    public String getName() {
        return this._jsonObject.getString("name");
    }

    public TestrayProject getTestrayProject() {
        return this._testrayProject;
    }

    public TestrayServer getTestrayServer() {
        return this._testrayServer;
    }

    public URL getURL() {
        return this._url;
    }
}

