/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.SourceFormatBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalAxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitAxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BatchTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.DefaultTestrayAttachment;
import com.liferay.jenkins.results.parser.testray.DefaultTestrayServer;
import com.liferay.jenkins.results.parser.testray.FunctionalBatchTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.JUnitBatchTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.RsyncTestrayAttachmentUploader;
import com.liferay.jenkins.results.parser.testray.S3TestrayAttachmentUploader;
import com.liferay.jenkins.results.parser.testray.SFBatchTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayAttachmentRecorder;
import com.liferay.jenkins.results.parser.testray.TestrayAttachmentUploader;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class TestrayFactory {
    private static final Map<Build, TestrayAttachmentRecorder> _testrayAttachmentRecorders = new HashMap<Build, TestrayAttachmentRecorder>();
    private static final Map<String, TestrayAttachmentUploader> _testrayAttachmentUploaders = new HashMap<String, TestrayAttachmentUploader>();
    private static final Map<String, TestrayServer> _testrayServers = new HashMap<String, TestrayServer>();

    public static TestrayAttachment newTestrayAttachment(TestrayCaseResult testrayCaseResult, String name, String key) {
        return new DefaultTestrayAttachment(testrayCaseResult, name, key);
    }

    public static TestrayAttachmentRecorder newTestrayAttachmentRecorder(Build build) {
        TestrayAttachmentRecorder testrayAttachmentRecorder = _testrayAttachmentRecorders.get(build);
        if (testrayAttachmentRecorder != null) {
            return testrayAttachmentRecorder;
        }
        testrayAttachmentRecorder = new TestrayAttachmentRecorder(build);
        _testrayAttachmentRecorders.put(build, testrayAttachmentRecorder);
        return testrayAttachmentRecorder;
    }

    public static TestrayAttachmentUploader newTestrayAttachmentUploader(Build build, URL testrayServerURL, TestrayAttachmentUploader.Type type) {
        String key;
        TestrayAttachmentUploader testrayAttachmentUploader;
        String testrayServerURLString = "";
        if (testrayServerURL != null) {
            testrayServerURLString = String.valueOf(testrayServerURL);
        }
        if ((testrayAttachmentUploader = _testrayAttachmentUploaders.get(key = JenkinsResultsParserUtil.combine(build.getBuildURL(), "_", testrayServerURLString, "_", type.toString()))) != null) {
            return testrayAttachmentUploader;
        }
        testrayAttachmentUploader = type == TestrayAttachmentUploader.Type.RSYNC ? new RsyncTestrayAttachmentUploader(build, testrayServerURL) : new S3TestrayAttachmentUploader(build, testrayServerURL);
        _testrayAttachmentUploaders.put(key, testrayAttachmentUploader);
        return testrayAttachmentUploader;
    }

    public static TestrayCaseResult newTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup, TestClass testClass) {
        if (testrayBuild == null) {
            throw new RuntimeException("Please set a Testray build");
        }
        if (topLevelBuild == null) {
            throw new RuntimeException("Please set a top level build");
        }
        if (axisTestClassGroup == null) {
            throw new RuntimeException("Please set an axis test class group");
        }
        if (testClass != null) {
            if (axisTestClassGroup instanceof FunctionalAxisTestClassGroup) {
                return new FunctionalBatchTestrayCaseResult(testrayBuild, topLevelBuild, axisTestClassGroup, testClass);
            }
            if (axisTestClassGroup instanceof JUnitAxisTestClassGroup) {
                return new JUnitBatchTestrayCaseResult(testrayBuild, topLevelBuild, axisTestClassGroup, testClass);
            }
        }
        if (topLevelBuild instanceof SourceFormatBuild) {
            return new SFBatchTestrayCaseResult(testrayBuild, topLevelBuild, axisTestClassGroup);
        }
        return new BatchTestrayCaseResult(testrayBuild, topLevelBuild, axisTestClassGroup);
    }

    public static TestrayServer newTestrayServer(String testrayServerURL) {
        TestrayServer testrayServer = _testrayServers.get(testrayServerURL);
        if (testrayServer != null) {
            return testrayServer;
        }
        testrayServer = new DefaultTestrayServer(testrayServerURL);
        _testrayServers.put(testrayServerURL, testrayServer);
        return testrayServer;
    }
}

