/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.StopWatchRecord;
import com.liferay.jenkins.results.parser.StopWatchRecordsGroup;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayProductVersion;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class TestrayBuild {
    private boolean _buildResultDataPopulated;
    private JSONObject _buildResultJSONObject;
    private URL _buildResultURL;
    private List<Long> _downstreamBuildDurations;
    private final JSONObject _jsonObject;
    private String _result;
    private int _startTimestamp;
    private final TestrayProductVersion _testrayProductVersion;
    private final TestrayProject _testrayProject;
    private final TestrayRoutine _testrayRoutine;
    private final TestrayServer _testrayServer;
    private Long _topLevelActiveBuildDuration;
    private Long _topLevelBuildDuration;

    public TestrayBuild(TestrayRoutine testrayRoutine, JSONObject jsonObject) {
        this._testrayRoutine = testrayRoutine;
        this._jsonObject = jsonObject;
        this._testrayProject = this._testrayRoutine.getTestrayProject();
        this._testrayServer = this._testrayRoutine.getTestrayServer();
        this._testrayProductVersion = this._testrayProject.getTestrayProductVersionByID(this._jsonObject.getInt("testrayProductVersionId"));
    }

    public String getDescription() {
        return this._jsonObject.getString("description");
    }

    public List<Long> getDownstreamBuildDurations() {
        this._initBuildResultData();
        return this._downstreamBuildDurations;
    }

    public int getID() {
        return this._jsonObject.getInt("testrayBuildId");
    }

    public String getName() {
        return this._jsonObject.getString("name");
    }

    public String getResult() {
        this._initBuildResultData();
        return this._result;
    }

    public List<TestrayCaseResult> getTestrayCaseResults() {
        ArrayList<TestrayCaseResult> testrayCaseResults = new ArrayList<TestrayCaseResult>();
        String urlString = String.valueOf(this.getURL());
        String caseResultsAPIURLString = urlString.replace("runs", "case_results.json");
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(caseResultsAPIURLString);
            JSONArray dataJSONArray = jsonObject.getJSONArray("data");
            for (int i = 0; i < dataJSONArray.length(); ++i) {
                JSONObject dataJSONObject = dataJSONArray.getJSONObject(i);
                TestrayCaseResult testrayCaseResult = new TestrayCaseResult(this, dataJSONObject);
                testrayCaseResults.add(testrayCaseResult);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return testrayCaseResults;
    }

    public TestrayProductVersion getTestrayProductVersion() {
        return this._testrayProductVersion;
    }

    public TestrayProject getTestrayProject() {
        return this._testrayProject;
    }

    public TestrayRoutine getTestrayRoutine() {
        return this._testrayRoutine;
    }

    public TestrayServer getTestrayServer() {
        return this._testrayServer;
    }

    public Long getTopLevelActiveBuildDuration() {
        this._initBuildResultData();
        return this._topLevelActiveBuildDuration;
    }

    public Long getTopLevelBuildDuration() {
        this._initBuildResultData();
        return this._topLevelBuildDuration;
    }

    public URL getURL() {
        try {
            return new URL(this._jsonObject.getString("htmlURL"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private void _addChildStopWatchRecords(StopWatchRecordsGroup stopWatchRecordsGroup, StopWatchRecord stopWatchRecord, JSONObject stopWatchRecordJSONObject) {
        if (!stopWatchRecordJSONObject.has("childStopWatchRecords")) {
            return;
        }
        JSONArray childStopWatchRecordsJSONArray = stopWatchRecordJSONObject.getJSONArray("childStopWatchRecords");
        for (int i = 0; i < childStopWatchRecordsJSONArray.length(); ++i) {
            JSONObject childStopWatchRecordJSONObject = childStopWatchRecordsJSONArray.getJSONObject(i);
            childStopWatchRecordJSONObject.put("startTimestamp", this._startTimestamp);
            ++this._startTimestamp;
            StopWatchRecord childStopWatchRecord = new StopWatchRecord(childStopWatchRecordJSONObject);
            stopWatchRecordsGroup.add(childStopWatchRecord);
            stopWatchRecord.addChildStopWatchRecord(childStopWatchRecord);
            this._addChildStopWatchRecords(stopWatchRecordsGroup, childStopWatchRecord, childStopWatchRecordJSONObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject _getBuildResultJSONObject() {
        if (this._buildResultJSONObject != null) {
            return this._buildResultJSONObject;
        }
        URL buildResultURL = this._getBuildResultURL();
        if (buildResultURL == null) {
            return null;
        }
        File jsonFile = new File(this.getID() + ".json");
        File jsonGzFile = new File(this.getID() + ".json.gz");
        try {
            JenkinsResultsParserUtil.toFile(buildResultURL, jsonGzFile);
            JenkinsResultsParserUtil.unGzip(jsonGzFile, jsonFile);
            this._buildResultJSONObject = JenkinsResultsParserUtil.createJSONObject(JenkinsResultsParserUtil.read(jsonFile));
            this._buildResultJSONObject.put("name", (Object)this.getName());
            JSONObject jSONObject = this._buildResultJSONObject;
            return jSONObject;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (jsonFile.exists()) {
                JenkinsResultsParserUtil.delete(jsonFile);
            }
            if (jsonGzFile.exists()) {
                JenkinsResultsParserUtil.delete(jsonGzFile);
            }
        }
        return null;
    }

    private URL _getBuildResultURL() {
        if (this._buildResultURL != null) {
            return this._buildResultURL;
        }
        List<TestrayCaseResult> testrayCaseResults = this.getTestrayCaseResults();
        if (testrayCaseResults.isEmpty()) {
            return null;
        }
        TestrayCaseResult testrayCaseResult = testrayCaseResults.get(0);
        TestrayAttachment buildResultTestrayAttachment = testrayCaseResult.getBuildResultTestrayAttachment();
        if (buildResultTestrayAttachment == null) {
            return null;
        }
        this._buildResultURL = buildResultTestrayAttachment.getURL();
        return this._buildResultURL;
    }

    private List<Long> _getDownstreamBuildDurations(JSONObject buildResultJSONObject) {
        if (buildResultJSONObject == null || !buildResultJSONObject.has("batchResults")) {
            return new ArrayList<Long>();
        }
        JSONArray batchResultsJSONArray = buildResultJSONObject.getJSONArray("batchResults");
        ArrayList<Long> downstreamBuildDurations = new ArrayList<Long>();
        for (int i = 0; i < batchResultsJSONArray.length(); ++i) {
            JSONObject batchResultJSONObject = batchResultsJSONArray.getJSONObject(i);
            JSONArray buildResultsJSONArray = batchResultJSONObject.getJSONArray("buildResults");
            for (int j = 0; j < buildResultsJSONArray.length(); ++j) {
                JSONObject buildResultsJSONObject = buildResultsJSONArray.getJSONObject(j);
                if (!buildResultsJSONObject.has("duration")) continue;
                downstreamBuildDurations.add(buildResultsJSONObject.getLong("duration"));
            }
        }
        return downstreamBuildDurations;
    }

    private String _getResult(JSONObject buildResultJSONObject) {
        if (buildResultJSONObject != null && buildResultJSONObject.has("result")) {
            return buildResultJSONObject.getString("result");
        }
        StringBuilder sb = new StringBuilder();
        String urlString = String.valueOf(this.getURL());
        sb.append(urlString.replace("runs", "case_results.json"));
        sb.append("&statuses=");
        for (TestrayCaseResult.Status failedStatus : TestrayCaseResult.Status.getFailedStatuses()) {
            sb.append(failedStatus.getID());
            sb.append(",");
        }
        try {
            JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(sb.toString());
            JSONArray dataJSONArray = jsonObject.getJSONArray("data");
            if (dataJSONArray != null && dataJSONArray.length() > 0) {
                return "FAILURE";
            }
        }
        catch (Exception exception) {
            return "FAILURE";
        }
        return "SUCCESS";
    }

    private StopWatchRecordsGroup _getStopWatchRecordsGroup(JSONObject buildResultJSONObject) {
        Long topLevelBuildDuration = this._getTopLevelBuildDuration(buildResultJSONObject);
        if (topLevelBuildDuration == null) {
            return null;
        }
        StopWatchRecordsGroup stopWatchRecordsGroup = new StopWatchRecordsGroup();
        StopWatchRecord stopWatchRecord = new StopWatchRecord("top.level.build", this._startTimestamp);
        ++this._startTimestamp;
        stopWatchRecord.setDuration(topLevelBuildDuration);
        stopWatchRecordsGroup.add(stopWatchRecord);
        if (buildResultJSONObject == null || !buildResultJSONObject.has("stopWatchRecords")) {
            return stopWatchRecordsGroup;
        }
        JSONArray stopWatchRecordsJSONArray = buildResultJSONObject.getJSONArray("stopWatchRecords");
        for (int i = 0; i < stopWatchRecordsJSONArray.length(); ++i) {
            JSONObject childStopWatchRecordJSONObject = stopWatchRecordsJSONArray.getJSONObject(i);
            childStopWatchRecordJSONObject.put("startTimestamp", this._startTimestamp);
            if (!childStopWatchRecordJSONObject.has("duration") || !childStopWatchRecordJSONObject.has("name")) continue;
            ++this._startTimestamp;
            StopWatchRecord childStopWatchRecord = new StopWatchRecord(childStopWatchRecordJSONObject);
            stopWatchRecord.addChildStopWatchRecord(childStopWatchRecord);
            stopWatchRecordsGroup.add(childStopWatchRecord);
            this._addChildStopWatchRecords(stopWatchRecordsGroup, childStopWatchRecord, childStopWatchRecordJSONObject);
        }
        return stopWatchRecordsGroup;
    }

    private Long _getTopLevelActiveBuildDuration(JSONObject buildResultJSONObject) {
        Long topLevelBuildDuration = this._getTopLevelBuildDuration(buildResultJSONObject);
        Long topLevelPassiveBuildDuration = this._getTopLevelPassiveBuildDuration(buildResultJSONObject);
        if (topLevelBuildDuration == null || topLevelPassiveBuildDuration == null) {
            return null;
        }
        return topLevelBuildDuration - topLevelPassiveBuildDuration;
    }

    private Long _getTopLevelBuildDuration(JSONObject buildResultJSONObject) {
        if (buildResultJSONObject == null || !buildResultJSONObject.has("duration")) {
            return null;
        }
        return buildResultJSONObject.getLong("duration");
    }

    private Long _getTopLevelPassiveBuildDuration(JSONObject buildResultJSONObject) {
        StopWatchRecordsGroup stopWatchRecordsGroup = this._getStopWatchRecordsGroup(buildResultJSONObject);
        if (stopWatchRecordsGroup == null) {
            return null;
        }
        StopWatchRecord waitForInvokedJobsStopWatchRecord = stopWatchRecordsGroup.get("wait.for.invoked.jobs");
        StopWatchRecord waitForInvokedSmokeJobsStopWatchRecord = stopWatchRecordsGroup.get("wait.for.invoked.smoke.jobs");
        if (waitForInvokedJobsStopWatchRecord != null || waitForInvokedSmokeJobsStopWatchRecord != null) {
            long topLevelPassiveBuildDuration = 0L;
            if (waitForInvokedJobsStopWatchRecord != null) {
                topLevelPassiveBuildDuration += waitForInvokedJobsStopWatchRecord.getDuration().longValue();
            }
            if (waitForInvokedSmokeJobsStopWatchRecord != null) {
                topLevelPassiveBuildDuration += waitForInvokedSmokeJobsStopWatchRecord.getDuration().longValue();
            }
            return topLevelPassiveBuildDuration;
        }
        StopWatchRecord invokeDownstreamBuildsStopWatchRecord = stopWatchRecordsGroup.get("invoke.downstream.builds");
        if (invokeDownstreamBuildsStopWatchRecord != null) {
            return invokeDownstreamBuildsStopWatchRecord.getDuration();
        }
        return null;
    }

    private synchronized void _initBuildResultData() {
        if (this._buildResultDataPopulated) {
            return;
        }
        this._buildResultDataPopulated = true;
        JSONObject buildResultJSONObject = this._getBuildResultJSONObject();
        this._downstreamBuildDurations = this._getDownstreamBuildDurations(buildResultJSONObject);
        this._result = this._getResult(buildResultJSONObject);
        this._topLevelActiveBuildDuration = this._getTopLevelActiveBuildDuration(buildResultJSONObject);
        this._topLevelBuildDuration = this._getTopLevelBuildDuration(buildResultJSONObject);
    }
}

