/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.BaseTestrayAttachmentUploader;
import com.liferay.jenkins.results.parser.testray.TestrayS3Bucket;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class S3TestrayAttachmentUploader
extends BaseTestrayAttachmentUploader {
    private boolean _uploaded;

    @Override
    public File getPreparedFilesBaseDir() {
        String workspace = System.getenv("WORKSPACE");
        if (JenkinsResultsParserUtil.isNullOrEmpty(workspace)) {
            throw new RuntimeException("Please set WORKSPACE");
        }
        return new File(workspace, "testray/prepared_s3_logs");
    }

    @Override
    public URL getTestrayServerLogsURL() {
        try {
            return new URL(JenkinsResultsParserUtil.combine(String.valueOf(this.getTestrayServerURL()), "/reports_test/production/logs"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    @Override
    public void upload() {
        if (this._uploaded) {
            return;
        }
        this.prepareFiles();
        TestrayS3Bucket testrayS3Bucket = TestrayS3Bucket.getInstance();
        testrayS3Bucket.createTestrayS3Objects(this.getPreparedFilesBaseDir());
        this._uploaded = true;
    }

    protected S3TestrayAttachmentUploader(Build build, URL testrayServerURL) {
        super(build, testrayServerURL);
    }
}

