/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestClassResult;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.FunctionalTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.BatchTestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class FunctionalBatchTestrayCaseResult
extends BatchTestrayCaseResult {
    private final FunctionalTestClass _functionalTestClass;

    public FunctionalBatchTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup, TestClass testClass) {
        super(testrayBuild, topLevelBuild, axisTestClassGroup);
        if (!(testClass instanceof FunctionalTestClass)) {
            throw new RuntimeException("Test class is not a functional test class");
        }
        this._functionalTestClass = (FunctionalTestClass)testClass;
    }

    @Override
    public String getComponentName() {
        return JenkinsResultsParserUtil.getProperty(this._functionalTestClass.getPoshiProperties(), "testray.main.component.name");
    }

    @Override
    public String getErrors() {
        TestResult testResult = this.getTestResult();
        if (testResult == null) {
            Build build = this.getBuild();
            if (build == null) {
                return "Failed to run build on CI";
            }
            String result = build.getResult();
            if (result == null) {
                return "Failed to finish build on CI";
            }
            if (result.equals("ABORTED")) {
                return "Aborted prior to running test";
            }
            if (result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                return "Failed to run test on CI";
            }
            return "Failed prior to running test";
        }
        if (!testResult.isFailing()) {
            return null;
        }
        String errorMessage = testResult.getErrorDetails();
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
            return "Failed for unknown reason";
        }
        if (errorMessage.contains("\n")) {
            errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n"));
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage = errorMessage.trim())) {
            return "Failed for unknown reason";
        }
        return errorMessage;
    }

    @Override
    public String getName() {
        return this._functionalTestClass.getTestClassMethodName();
    }

    @Override
    public int getPriority() {
        String priority = JenkinsResultsParserUtil.getProperty(this._functionalTestClass.getPoshiProperties(), "priority");
        if (priority != null && priority.matches("\\d+")) {
            return Integer.parseInt(priority);
        }
        return 5;
    }

    @Override
    public TestrayCaseResult.Status getStatus() {
        Build build = this.getBuild();
        if (build == null) {
            return TestrayCaseResult.Status.UNTESTED;
        }
        TestResult testResult = this.getTestResult();
        if (testResult == null) {
            String result = build.getResult();
            if (result == null || result.equals("SUCCESS") || result.equals("UNSTABLE")) {
                return TestrayCaseResult.Status.UNTESTED;
            }
            return TestrayCaseResult.Status.FAILED;
        }
        if (testResult.isFailing()) {
            return TestrayCaseResult.Status.FAILED;
        }
        return TestrayCaseResult.Status.PASSED;
    }

    @Override
    public String getSubcomponentNames() {
        return JenkinsResultsParserUtil.getProperty(this._functionalTestClass.getPoshiProperties(), "testray.component.names");
    }

    @Override
    public List<TestrayAttachment> getTestrayAttachments() {
        List<TestrayAttachment> testrayAttachments = super.getTestrayAttachments();
        testrayAttachments.addAll(this._getLiferayLogTestrayAttachments());
        testrayAttachments.addAll(this._getLiferayOSGiLogTestrayAttachments());
        testrayAttachments.add(this._getPoshiReportTestrayAttachment());
        testrayAttachments.add(this._getPoshiSummaryTestrayAttachment());
        testrayAttachments.removeAll(Collections.singleton(null));
        return testrayAttachments;
    }

    public TestResult getTestResult() {
        Build build = this.getBuild();
        if (build == null) {
            return null;
        }
        TestClassResult testClassResult = build.getTestClassResult("com.liferay.poshi.runner.PoshiRunner");
        if (testClassResult == null) {
            return null;
        }
        return testClassResult.getTestResult("test[" + this.getName() + "]");
    }

    @Override
    public String[] getWarnings() {
        TestrayAttachment testrayAttachment = this.getTestrayAttachment(this.getAxisBuild(), "Poshi Warnings", this.getAxisBuildURLPath() + "/poshi-warnings.xml.gz");
        if (testrayAttachment == null) {
            return null;
        }
        String testrayAttachmentValue = testrayAttachment.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(testrayAttachmentValue)) {
            return null;
        }
        try {
            Document document = Dom4JUtil.parse(testrayAttachmentValue);
            Element rootElement = document.getRootElement();
            ArrayList<String> warnings = new ArrayList<String>();
            for (Element valueElement : rootElement.elements()) {
                String warning = valueElement.getText();
                if (JenkinsResultsParserUtil.isNullOrEmpty(warning = warning.trim())) continue;
                warnings.add(warning);
            }
            if (!warnings.isEmpty()) {
                return warnings.toArray(new String[0]);
            }
        }
        catch (DocumentException documentException) {
            return null;
        }
        return null;
    }

    private List<TestrayAttachment> _getLiferayLogTestrayAttachments() {
        TestrayAttachment liferayLogTestrayAttachment;
        ArrayList<TestrayAttachment> testrayAttachments = new ArrayList<TestrayAttachment>();
        if (this.getTestResult() == null) {
            return testrayAttachments;
        }
        TestrayAttachment testrayAttachment = this.getTestrayAttachment(this.getAxisBuild(), "Liferay Log", this.getAxisBuildURLPath() + "/liferay-log.txt.gz");
        if (testrayAttachment == null) {
            return testrayAttachments;
        }
        testrayAttachments.add(testrayAttachment);
        for (int i = 1; i <= 5 && (liferayLogTestrayAttachment = this.getTestrayAttachment(this.getAxisBuild(), "Liferay Log (" + i + ")", JenkinsResultsParserUtil.combine(this.getAxisBuildURLPath(), "/liferay-log-", String.valueOf(i), ".txt.gz"))) != null; ++i) {
            testrayAttachments.add(liferayLogTestrayAttachment);
        }
        return testrayAttachments;
    }

    private List<TestrayAttachment> _getLiferayOSGiLogTestrayAttachments() {
        TestrayAttachment liferayOSGiLogTestrayAttachment;
        ArrayList<TestrayAttachment> testrayAttachments = new ArrayList<TestrayAttachment>();
        if (this.getTestResult() == null) {
            return testrayAttachments;
        }
        TestrayAttachment testrayAttachment = this.getTestrayAttachment(this.getAxisBuild(), "Liferay OSGi Log", this.getAxisBuildURLPath() + "/liferay-osgi-log.txt.gz");
        if (testrayAttachment == null) {
            return testrayAttachments;
        }
        testrayAttachments.add(testrayAttachment);
        for (int i = 1; i <= 5 && (liferayOSGiLogTestrayAttachment = this.getTestrayAttachment(this.getAxisBuild(), "Liferay OSGi Log (" + i + ")", JenkinsResultsParserUtil.combine(this.getAxisBuildURLPath(), "/liferay-log-osgi-", String.valueOf(i), ".txt.gz"))) != null; ++i) {
            testrayAttachments.add(liferayOSGiLogTestrayAttachment);
        }
        return testrayAttachments;
    }

    private TestrayAttachment _getPoshiReportTestrayAttachment() {
        if (this.getTestResult() == null) {
            return null;
        }
        String name = this.getName();
        name = name.replace("#", "_");
        return this.getTestrayAttachment(this.getAxisBuild(), "Poshi Report", JenkinsResultsParserUtil.combine(this.getAxisBuildURLPath(), "/", JenkinsResultsParserUtil.fixURL(name), "/index.html.gz"));
    }

    private TestrayAttachment _getPoshiSummaryTestrayAttachment() {
        if (this.getTestResult() == null) {
            return null;
        }
        String name = this.getName();
        name = name.replace("#", "_");
        return this.getTestrayAttachment(this.getAxisBuild(), "Poshi Summary", JenkinsResultsParserUtil.combine(this.getAxisBuildURLPath(), "/", JenkinsResultsParserUtil.fixURL(name), "/summary.html.gz"));
    }
}

