/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayProductVersion;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import com.liferay.jenkins.results.parser.testray.TestrayS3Bucket;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class DXPCloudClientTestrayImporter {
    private static final long _START_TIME = System.currentTimeMillis();
    private static String _environmentBrowserName = "Google Chrome 86";
    private static String _environmentOperatingSystemName = "Cent OS 7";
    private static final LocalDate _localDate = LocalDate.now();
    private static final Pattern _pattern = Pattern.compile("test\\[(?<testName>[^\\]]{1,150})[^\\]]*\\]");
    private static File _projectDir = new File(".");
    private static String _relativeURLPath;
    private static TestrayBuild _testrayBuild;
    private static String _testrayBuildName;
    private static Integer _testrayCasePriority;
    private static String _testrayComponentName;
    private static String _testrayProductVersion;
    private static String _testrayProjectName;
    private static String _testrayReleaseName;
    private static String _testrayRoutineName;
    private static String _testrayServerURL;
    private static String _testrayTeamName;
    private static String _testrayUserName;
    private static String _testrayUserPassword;

    public static void main(String[] args) throws Exception {
        DXPCloudClientTestrayImporter._initEnvironmentVariables();
        Element rootElement = Dom4JUtil.getNewElement("testsuite");
        rootElement.add(DXPCloudClientTestrayImporter._getTestSuiteEnvironmentsElement());
        rootElement.add(DXPCloudClientTestrayImporter._getTestSuitePropertiesElement());
        for (Element testCaseResultElement : DXPCloudClientTestrayImporter._getTestCaseResultElements()) {
            Element testCaseElement = rootElement.addElement("testcase");
            testCaseElement.add(DXPCloudClientTestrayImporter._getTestCaseAttachmentsElement(testCaseResultElement));
            testCaseElement.add(DXPCloudClientTestrayImporter._getTestCasePropertiesElement(testCaseResultElement));
        }
        if (!TestrayS3Bucket.googleCredentialsAvailable()) {
            JenkinsResultsParserUtil.BasicHTTPAuthorization httpAuthorization = null;
            if (!JenkinsResultsParserUtil.isNullOrEmpty(_testrayUserName) && !JenkinsResultsParserUtil.isNullOrEmpty(_testrayUserPassword)) {
                httpAuthorization = new JenkinsResultsParserUtil.BasicHTTPAuthorization(_testrayUserPassword, _testrayUserName);
            }
            JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.combine(_testrayServerURL, "/web/guest/home/-/testray/case_results", "/importResults.json"), JenkinsResultsParserUtil.combine("results=", URLEncoder.encode(Dom4JUtil.format(rootElement), "UTF-8"), "&type=poshi"), httpAuthorization);
            return;
        }
        TestrayBuild testrayBuild = DXPCloudClientTestrayImporter._getTestrayBuild();
        File testrayResultsDir = new File("testray-results");
        JenkinsResultsParserUtil.delete(testrayResultsDir);
        testrayResultsDir.mkdirs();
        File resultsFile = new File(testrayResultsDir, JenkinsResultsParserUtil.combine("TESTS-dxp-cloud-client-", String.valueOf(testrayBuild.getID()), ".xml"));
        JenkinsResultsParserUtil.write(resultsFile, Dom4JUtil.format(rootElement));
        File resultsTarGzFile = new File(JenkinsResultsParserUtil.combine(String.valueOf(JenkinsResultsParserUtil.getCurrentTimeMillis()), "-", String.valueOf(testrayBuild.getID()), "-results.tar.gz"));
        JenkinsResultsParserUtil.tarGzip(testrayResultsDir, resultsTarGzFile);
        TestrayS3Bucket testrayS3Bucket = TestrayS3Bucket.getInstance();
        testrayS3Bucket.createTestrayS3Object("inbox/" + resultsTarGzFile.getName(), resultsTarGzFile);
        JenkinsResultsParserUtil.delete(testrayResultsDir);
        JenkinsResultsParserUtil.delete(resultsTarGzFile);
    }

    private static void _fixImageURLs(File htmlFile) {
        try {
            String htmlFileContent = JenkinsResultsParserUtil.read(htmlFile);
            File parentFile = htmlFile.getParentFile();
            JenkinsResultsParserUtil.write(htmlFile, htmlFileContent.replaceAll("(screenshots/(?:after|before|screenshot)\\d+)\\.jpg", JenkinsResultsParserUtil.combine(_testrayServerURL, "/reports/", _testrayReleaseName, "/logs/", DXPCloudClientTestrayImporter._getRelativeURLPath(), "/", parentFile.getName(), "/$1.jpg.gz")));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static String _getEnvVarValue(String varName) {
        String varValue = System.getenv(varName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(varValue)) {
            varValue = System.getProperty(varName);
        }
        return varValue;
    }

    private static Element _getPropertiesElement(Properties properties) {
        Element element = Dom4JUtil.getNewElement("properties");
        for (String propertyName : properties.stringPropertyNames()) {
            Element propertyElement = element.addElement("property");
            String propertyValue = JenkinsResultsParserUtil.getProperty(properties, propertyName);
            if (JenkinsResultsParserUtil.isNullOrEmpty(propertyName) || JenkinsResultsParserUtil.isNullOrEmpty(propertyValue)) continue;
            propertyElement.addAttribute("name", propertyName);
            propertyElement.addAttribute("value", propertyValue);
        }
        return element;
    }

    private static String _getRelativeURLPath() {
        if (_relativeURLPath != null) {
            return _relativeURLPath;
        }
        TestrayBuild testrayBuild = DXPCloudClientTestrayImporter._getTestrayBuild();
        _relativeURLPath = JenkinsResultsParserUtil.combine(_localDate.format(DateTimeFormatter.ofPattern("yyyy-MM")), "/dxp-cloud/", String.valueOf(testrayBuild.getID()));
        return _relativeURLPath;
    }

    private static Element _getTestCaseAttachmentsElement(Element testCaseResultElement) {
        Element attachmentsElement = Dom4JUtil.getNewElement("attachments");
        if (!TestrayS3Bucket.googleCredentialsAvailable()) {
            return attachmentsElement;
        }
        Matcher matcher = _pattern.matcher(testCaseResultElement.attributeValue("name"));
        if (!matcher.find()) {
            return attachmentsElement;
        }
        String testName = matcher.group("testName");
        File testDir = new File(_projectDir, "test-results/" + testName.replace("#", "_"));
        if (!testDir.exists()) {
            return attachmentsElement;
        }
        for (File htmlFile : JenkinsResultsParserUtil.findFiles(testDir, ".*\\.html")) {
            DXPCloudClientTestrayImporter._fixImageURLs(htmlFile);
        }
        DXPCloudClientTestrayImporter._removeUnreferencedImages(new File(testDir, "index.html"));
        TestrayS3Bucket testrayS3Bucket = TestrayS3Bucket.getInstance();
        for (File file : JenkinsResultsParserUtil.findFiles(testDir, ".*")) {
            String attachmentName;
            String fileName = file.getName();
            if (!fileName.endsWith(".gz")) {
                File gzipFile = new File(file.getParent(), file.getName() + ".gz");
                JenkinsResultsParserUtil.gzip(file, gzipFile);
                JenkinsResultsParserUtil.delete(file);
                file = gzipFile;
            }
            fileName = file.getName();
            String key = JenkinsResultsParserUtil.combine(DXPCloudClientTestrayImporter._getRelativeURLPath(), "/", JenkinsResultsParserUtil.getPathRelativeTo(file, testDir.getParentFile()));
            testrayS3Bucket.createTestrayS3Object(key, file);
            if (fileName.equals("index.html.gz")) {
                attachmentName = "Poshi Report";
            } else {
                if (!fileName.equals("summary.html.gz")) continue;
                attachmentName = "Poshi Summary";
            }
            Element attachmentElement = attachmentsElement.addElement("file");
            attachmentElement.addAttribute("name", attachmentName);
            attachmentElement.addAttribute("url", JenkinsResultsParserUtil.combine(_testrayServerURL, "/reports/", _testrayReleaseName, "/logs/", key, "?authuser=0"));
            attachmentElement.addAttribute("value", key + "?authuser=0");
        }
        return attachmentsElement;
    }

    private static Element _getTestCasePropertiesElement(Element testCaseResultElement) {
        Properties properties = new Properties();
        Matcher matcher = _pattern.matcher(testCaseResultElement.attributeValue("name"));
        if (!matcher.find()) {
            return DXPCloudClientTestrayImporter._getPropertiesElement(properties);
        }
        TestrayCaseResult.Status status = TestrayCaseResult.Status.PASSED;
        Element failureElement = testCaseResultElement.element("failure");
        if (failureElement != null) {
            status = TestrayCaseResult.Status.FAILED;
        }
        properties.setProperty("testray.case.type.name", "Automated Functional Test");
        properties.setProperty("testray.component.names", _testrayComponentName);
        properties.setProperty("testray.main.component.name", _testrayComponentName);
        properties.setProperty("testray.team.name", _testrayTeamName);
        properties.setProperty("testray.testcase.name", matcher.group("testName"));
        properties.setProperty("testray.testcase.priority", String.valueOf(_testrayCasePriority));
        properties.setProperty("testray.testcase.status", status.getName());
        return DXPCloudClientTestrayImporter._getPropertiesElement(properties);
    }

    private static List<Element> _getTestCaseResultElements() {
        try {
            String content = JenkinsResultsParserUtil.read(new File(_projectDir, "test-results/TEST-com.liferay.poshi.runner.PoshiRunner.xml"));
            int x = content.indexOf("<system-out>");
            int y = content.indexOf("</system-err>") + 13;
            content = content.substring(0, x) + content.substring(y);
            Document document = Dom4JUtil.parse(content);
            Element rootElement = document.getRootElement();
            return rootElement.elements("testcase");
        }
        catch (IOException | DocumentException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static TestrayBuild _getTestrayBuild() {
        if (_testrayBuild != null) {
            return _testrayBuild;
        }
        TestrayServer testrayServer = TestrayFactory.newTestrayServer(_testrayServerURL);
        TestrayProject testrayProject = testrayServer.getTestrayProjectByName(_testrayProjectName);
        TestrayRoutine testrayRoutine = testrayProject.createTestrayRoutine(_testrayRoutineName);
        TestrayProductVersion testrayProductVersion = testrayProject.createTestrayProductVersion(_testrayProductVersion);
        _testrayBuild = testrayRoutine.createTestrayBuild(testrayProductVersion, DXPCloudClientTestrayImporter._getTestrayBuildName());
        return _testrayBuild;
    }

    private static String _getTestrayBuildName() {
        return _testrayBuildName.replace("$(start.time)", JenkinsResultsParserUtil.toDateString(new Date(_START_TIME), "yyyy-MM-dd[HH:mm:ss]", "America/Los_Angeles"));
    }

    private static Element _getTestSuiteEnvironmentsElement() {
        Element environmentsElement = Dom4JUtil.getNewElement("environments");
        Element browserEnvironmentElement = environmentsElement.addElement("environment");
        browserEnvironmentElement.addAttribute("option", _environmentBrowserName);
        browserEnvironmentElement.addAttribute("type", "Browser");
        Element operatingSystemEnvironmentElement = environmentsElement.addElement("environment");
        operatingSystemEnvironmentElement.addAttribute("option", _environmentOperatingSystemName);
        operatingSystemEnvironmentElement.addAttribute("type", "Operating System");
        return environmentsElement;
    }

    private static Element _getTestSuitePropertiesElement() {
        TestrayBuild testrayBuild = DXPCloudClientTestrayImporter._getTestrayBuild();
        TestrayProductVersion testrayProductVersion = testrayBuild.getTestrayProductVersion();
        TestrayProject testrayProject = testrayBuild.getTestrayProject();
        TestrayRoutine testrayRoutine = testrayBuild.getTestrayRoutine();
        Properties properties = new Properties();
        properties.setProperty("testray.build.name", testrayBuild.getName());
        properties.setProperty("testray.build.type", testrayRoutine.getName());
        properties.setProperty("testray.product.version", testrayProductVersion.getName());
        properties.setProperty("testray.project.name", testrayProject.getName());
        properties.setProperty("testray.run.id", JenkinsResultsParserUtil.join("|", _environmentBrowserName, _environmentOperatingSystemName));
        return DXPCloudClientTestrayImporter._getPropertiesElement(properties);
    }

    private static void _initEnvironmentVariables() {
        String testrayUserPassword;
        String testrayUserName;
        String testrayTeamName;
        String testrayServerURL;
        String testrayRoutineName;
        String testrayReleaseName;
        String testrayProjectName;
        String testrayProductVersion;
        String testrayComponentName;
        String testrayCasePriority;
        String testrayBuildName;
        String environmentOperatingSystemName;
        String projectDirPath = DXPCloudClientTestrayImporter._getEnvVarValue("projectDir");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(projectDirPath)) {
            _projectDir = new File(projectDirPath);
        }
        if (!_projectDir.exists()) {
            throw new RuntimeException("Could not find '" + projectDirPath + "'");
        }
        String environmentBrowserName = DXPCloudClientTestrayImporter._getEnvVarValue("environmentBrowserName");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(environmentBrowserName)) {
            _environmentBrowserName = environmentBrowserName;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(environmentOperatingSystemName = DXPCloudClientTestrayImporter._getEnvVarValue("environmentOperatingSystemName"))) {
            _environmentOperatingSystemName = environmentOperatingSystemName;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testrayBuildName = DXPCloudClientTestrayImporter._getEnvVarValue("testrayBuildName"))) {
            _testrayBuildName = testrayBuildName;
        }
        if ((testrayCasePriority = DXPCloudClientTestrayImporter._getEnvVarValue("testrayCasePriority")) != null && testrayCasePriority.matches("\\d+")) {
            _testrayCasePriority = Integer.valueOf(testrayCasePriority);
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testrayComponentName = DXPCloudClientTestrayImporter._getEnvVarValue("testrayComponentName"))) {
            _testrayComponentName = testrayComponentName;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testrayProductVersion = DXPCloudClientTestrayImporter._getEnvVarValue("testrayProductVersion"))) {
            _testrayProductVersion = testrayProductVersion;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testrayProjectName = DXPCloudClientTestrayImporter._getEnvVarValue("testrayProjectName"))) {
            _testrayProjectName = testrayProjectName;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testrayReleaseName = DXPCloudClientTestrayImporter._getEnvVarValue("testrayReleaseName"))) {
            _testrayReleaseName = testrayReleaseName;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testrayRoutineName = DXPCloudClientTestrayImporter._getEnvVarValue("testrayRoutineName"))) {
            _testrayRoutineName = testrayRoutineName;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testrayServerURL = DXPCloudClientTestrayImporter._getEnvVarValue("testrayServerURL"))) {
            _testrayServerURL = testrayServerURL;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testrayTeamName = DXPCloudClientTestrayImporter._getEnvVarValue("testrayTeamName"))) {
            _testrayTeamName = testrayTeamName;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testrayUserName = DXPCloudClientTestrayImporter._getEnvVarValue("testrayUserName"))) {
            _testrayUserName = testrayUserName;
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testrayUserPassword = DXPCloudClientTestrayImporter._getEnvVarValue("testrayUserPassword"))) {
            _testrayUserPassword = testrayUserPassword;
        }
    }

    private static void _removeUnreferencedImages(File htmlFile) {
        if (!htmlFile.exists()) {
            return;
        }
        try {
            String htmlFileContent = JenkinsResultsParserUtil.read(htmlFile);
            List<File> jpgFiles = JenkinsResultsParserUtil.findFiles(htmlFile.getParentFile(), ".*\\.jpg");
            for (File jpgFile : jpgFiles) {
                String jpgFileName = jpgFile.getName();
                if (htmlFileContent.contains("/" + jpgFileName)) continue;
                System.out.println("Removing unreferenced file " + jpgFile);
                JenkinsResultsParserUtil.delete(jpgFile);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    static {
        _testrayBuildName = "DXP Cloud Client Build - $(start.time)";
        _testrayCasePriority = 1;
        _testrayComponentName = "DXP Cloud Client Component";
        _testrayProductVersion = "1.x";
        _testrayProjectName = "DXP Cloud Client";
        _testrayReleaseName = "production";
        _testrayRoutineName = "DXP Cloud Client Routine";
        _testrayServerURL = "https://testray.liferay.com";
        _testrayTeamName = "DXP Cloud Client Team";
    }
}

