/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.QAWebsitesGitRepositoryJob;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.JobPropertyFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.DefaultTestrayAttachment;
import com.liferay.jenkins.results.parser.testray.S3TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayS3Bucket;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.WordUtils;

public class BatchTestrayCaseResult
extends TestrayCaseResult {
    private final AxisTestClassGroup _axisTestClassGroup;

    public BatchTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup) {
        super(testrayBuild, topLevelBuild);
        this._axisTestClassGroup = axisTestClassGroup;
    }

    public AxisBuild getAxisBuild() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        return topLevelBuild.getDownstreamAxisBuild(this._axisTestClassGroup.getAxisName());
    }

    public String getAxisName() {
        return this._axisTestClassGroup.getAxisName();
    }

    public String getBatchName() {
        return this._axisTestClassGroup.getBatchName();
    }

    public Build getBuild() {
        return this.getAxisBuild();
    }

    @Override
    public String getComponentName() {
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.component", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getErrors() {
        Build build = this.getBuild();
        if (build == null) {
            return "Failed to run on CI";
        }
        if (!build.isFailing()) {
            return null;
        }
        String result = build.getResult();
        if (result == null) {
            return "Failed to finish build on CI";
        }
        if (result.equals("ABORTED")) {
            return "Aborted prior to running test";
        }
        String errorMessage = build.getFailureMessage();
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
            return "Failed for unknown reason";
        }
        if (errorMessage.contains("\n")) {
            errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n"));
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage = errorMessage.trim())) {
            return "Failed for unknown reason";
        }
        return errorMessage;
    }

    @Override
    public String getName() {
        return this.getAxisName();
    }

    @Override
    public int getPriority() {
        try {
            String testrayCasePriority = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.priority", this.getBatchName());
            if (testrayCasePriority != null && testrayCasePriority.matches("\\d+")) {
                return Integer.parseInt(testrayCasePriority);
            }
            return 5;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public TestrayCaseResult.Status getStatus() {
        Build build = this.getBuild();
        if (build == null) {
            return TestrayCaseResult.Status.UNTESTED;
        }
        if (build.isFailing()) {
            return TestrayCaseResult.Status.FAILED;
        }
        return TestrayCaseResult.Status.PASSED;
    }

    @Override
    public String getTeamName() {
        JobProperty teamNamesJobProperty = this._getJobProperty("testray.team.names");
        String teamNames = teamNamesJobProperty.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(teamNames)) {
            try {
                return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.team", this.getBatchName());
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        String componentName = this.getComponentName();
        for (String teamName : teamNames.split(",")) {
            JobProperty teamComponentNamesJobProperty = this._getJobProperty("testray.team." + teamName + ".component.names");
            String teamComponentNames = teamComponentNamesJobProperty.getValue();
            if (JenkinsResultsParserUtil.isNullOrEmpty(teamComponentNames)) continue;
            for (String teamComponentName : teamComponentNames.split(",")) {
                if (!teamComponentName.equals(componentName)) continue;
                teamName = teamName.replace("-", " ");
                return WordUtils.capitalize((String)teamName);
            }
        }
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.team", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public List<TestrayAttachment> getTestrayAttachments() {
        ArrayList<TestrayAttachment> testrayAttachments = new ArrayList<TestrayAttachment>();
        testrayAttachments.add(this._getBuildResultTopLevelTestrayAttachment());
        testrayAttachments.add(this._getJobSummaryTestrayAttachment());
        testrayAttachments.add(this._getJenkinsConsoleTestrayAttachment());
        testrayAttachments.add(this._getJenkinsConsoleTopLevelTestrayAttachment());
        testrayAttachments.add(this._getJenkinsReportTestrayAttachment());
        testrayAttachments.removeAll(Collections.singleton(null));
        return testrayAttachments;
    }

    @Override
    public String getType() {
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.type", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String[] getWarnings() {
        return null;
    }

    protected String getAxisBuildURLPath() {
        AxisBuild axisBuild = this.getAxisBuild();
        if (axisBuild == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._getTopLevelBuildURLPath());
        sb.append("/");
        sb.append(axisBuild.getAxisName());
        return sb.toString();
    }

    protected AxisTestClassGroup getAxisTestClassGroup() {
        return this._axisTestClassGroup;
    }

    protected TestrayAttachment getTestrayAttachment(Build build, String name, String key) {
        if (build == null || JenkinsResultsParserUtil.isNullOrEmpty(key) || JenkinsResultsParserUtil.isNullOrEmpty(name)) {
            return null;
        }
        for (URL testrayAttachmentURL : build.getTestrayAttachmentURLs()) {
            String testrayAttachmentURLString = String.valueOf(testrayAttachmentURL);
            if (!testrayAttachmentURLString.contains(key)) continue;
            return new DefaultTestrayAttachment(this, name, key, testrayAttachmentURL);
        }
        if (TestrayS3Bucket.googleCredentialsAvailable()) {
            for (URL testrayS3AttachmentURL : build.getTestrayS3AttachmentURLs()) {
                String testrayS3AttachmentURLString = String.valueOf(testrayS3AttachmentURL);
                if (!testrayS3AttachmentURLString.contains(key)) continue;
                return new S3TestrayAttachment(this, name, key);
            }
        }
        return null;
    }

    private TestrayAttachment _getBuildResultTopLevelTestrayAttachment() {
        return this.getTestrayAttachment(this.getTopLevelBuild(), "Build Result (Top Level)", this._getTopLevelBuildURLPath() + "/build-result.json.gz");
    }

    private TestrayAttachment _getJenkinsConsoleTestrayAttachment() {
        return this.getTestrayAttachment(this.getAxisBuild(), "Jenkins Console", this.getAxisBuildURLPath() + "/jenkins-console.txt.gz");
    }

    private TestrayAttachment _getJenkinsConsoleTopLevelTestrayAttachment() {
        return this.getTestrayAttachment(this.getTopLevelBuild(), "Jenkins Console (Top Level)", this._getTopLevelBuildURLPath() + "/jenkins-console.txt.gz");
    }

    private TestrayAttachment _getJenkinsReportTestrayAttachment() {
        return this.getTestrayAttachment(this.getTopLevelBuild(), "Jenkins Report (Top Level)", this._getTopLevelBuildURLPath() + "/jenkins-report.html.gz");
    }

    private JobProperty _getJobProperty(String basePropertyName) {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        Job job = topLevelBuild.getJob();
        if (job instanceof QAWebsitesGitRepositoryJob) {
            AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup();
            return JobPropertyFactory.newJobProperty(basePropertyName, job, axisTestClassGroup.getTestBaseDir(), JobProperty.Type.QA_WEBSITES_TEST_DIR);
        }
        return JobPropertyFactory.newJobProperty(basePropertyName, job);
    }

    private TestrayAttachment _getJobSummaryTestrayAttachment() {
        return this.getTestrayAttachment(this.getTopLevelBuild(), "Job Summary (Top Level)", this._getTopLevelBuildURLPath() + "/job-summary/index.html.gz");
    }

    private String _getTopLevelBuildURLPath() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Date date = new Date(topLevelBuild.getStartTime());
        sb.append(JenkinsResultsParserUtil.toDateString(date, "yyyy-MM", "America/Los_Angeles"));
        sb.append("/");
        JenkinsMaster jenkinsMaster = topLevelBuild.getJenkinsMaster();
        sb.append(jenkinsMaster.getName());
        sb.append("/");
        sb.append(topLevelBuild.getJobName());
        sb.append("/");
        sb.append(topLevelBuild.getBuildNumber());
        return sb.toString();
    }
}

