/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesBatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class SemVerModulesBatchTestClassGroup
extends ModulesBatchTestClassGroup {
    @Override
    public int getAxisCount() {
        if (!this.isStableTestSuiteBatch() && this.testRelevantIntegrationUnitOnly) {
            return 0;
        }
        return super.getAxisCount();
    }

    protected SemVerModulesBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
    }

    protected SemVerModulesBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected void setTestClasses() throws IOException {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        File portalModulesBaseDir = new File(portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        List<PathMatcher> excludesPathMatchers = this.getPathMatchers(this.getExcludesJobProperties());
        List<PathMatcher> includesPathMatchers = this.getPathMatchers(this.getIncludesJobProperties());
        if (!(!this.testRelevantChanges || this.includeStableTestSuite && this.isStableTestSuiteBatch())) {
            this.moduleDirsList.addAll(portalGitWorkingDirectory.getModifiedModuleDirsList(excludesPathMatchers, includesPathMatchers));
        } else {
            this.moduleDirsList.addAll(portalGitWorkingDirectory.getModuleDirsList(excludesPathMatchers, includesPathMatchers));
            List<File> semVerMarkerFiles = JenkinsResultsParserUtil.findFiles(portalModulesBaseDir, "\\.lfrbuild-semantic-versioning");
            for (File semVerMarkerFile : semVerMarkerFiles) {
                this.moduleDirsList.add(semVerMarkerFile.getParentFile());
            }
        }
        for (File moduleDir : this.moduleDirsList) {
            TestClass testClass = TestClassFactory.newTestClass((BatchTestClassGroup)this, moduleDir);
            if (!testClass.hasTestClassMethods()) continue;
            this.testClasses.add(testClass);
        }
        Collections.sort(this.testClasses);
    }
}

