/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SegmentTestClassGroup
extends BaseTestClassGroup {
    private final List<AxisTestClassGroup> _axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
    private final BatchTestClassGroup _batchTestClassGroup;

    public void addAxisTestClassGroup(AxisTestClassGroup axisTestClassGroup) {
        this._axisTestClassGroups.add(axisTestClassGroup);
        axisTestClassGroup.setSegmentTestClassGroup(this);
    }

    public int getAxisCount() {
        return this._axisTestClassGroups.size();
    }

    public AxisTestClassGroup getAxisTestClassGroup(int segmentIndex) {
        return this._axisTestClassGroups.get(segmentIndex);
    }

    public List<AxisTestClassGroup> getAxisTestClassGroups() {
        return new ArrayList<AxisTestClassGroup>(this._axisTestClassGroups);
    }

    public int getBatchIndex() {
        List<SegmentTestClassGroup> segmentTestClassGroups = this._batchTestClassGroup.getSegmentTestClassGroups();
        return segmentTestClassGroups.indexOf(this);
    }

    public String getBatchJobName() {
        return this._batchTestClassGroup.getBatchJobName();
    }

    public String getBatchName() {
        return this._batchTestClassGroup.getBatchName();
    }

    public BatchTestClassGroup getBatchTestClassGroup() {
        return this._batchTestClassGroup;
    }

    public String getCohortName() {
        return this._batchTestClassGroup.getCohortName();
    }

    @Override
    public Job getJob() {
        return this._batchTestClassGroup.getJob();
    }

    public JSONObject getJSONObject() {
        JSONObject jsonObject = new JSONObject();
        JSONArray axesJSONArray = new JSONArray();
        for (AxisTestClassGroup axisTestClassGroup : this.getAxisTestClassGroups()) {
            axesJSONArray.put((Object)axisTestClassGroup.getJSONObject());
        }
        jsonObject.put("axes", (Object)axesJSONArray);
        jsonObject.put("segment_name", (Object)this.getSegmentName());
        return jsonObject;
    }

    public Integer getMaximumSlavesPerHost() {
        return this._batchTestClassGroup.getMaximumSlavesPerHost();
    }

    public Integer getMinimumSlaveRAM() {
        return this._batchTestClassGroup.getMinimumSlaveRAM();
    }

    public String getSegmentName() {
        return JenkinsResultsParserUtil.combine(this.getBatchName(), "/", String.valueOf(this.getBatchIndex()));
    }

    public String getSlaveLabel() {
        BatchTestClassGroup batchTestClassGroup = this.getBatchTestClassGroup();
        return batchTestClassGroup.getSlaveLabel();
    }

    public File getTestBaseDir() {
        List<AxisTestClassGroup> axisTestClassGroups = this.getAxisTestClassGroups();
        if (axisTestClassGroups == null || axisTestClassGroups.isEmpty()) {
            return null;
        }
        AxisTestClassGroup axisTestClassGroup = axisTestClassGroups.get(0);
        return axisTestClassGroup.getTestBaseDir();
    }

    public String getTestCasePropertiesContent() {
        StringBuilder sb = new StringBuilder();
        File testBaseDir = this.getTestBaseDir();
        if (testBaseDir != null && testBaseDir.exists()) {
            sb.append("TEST_BASE_DIR_NAME=");
            sb.append(JenkinsResultsParserUtil.getCanonicalPath(testBaseDir));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public List<TestClass> getTestClasses() {
        ArrayList<TestClass> testClasses = new ArrayList<TestClass>();
        for (AxisTestClassGroup axisTestClassGroup : this.getAxisTestClassGroups()) {
            testClasses.addAll(axisTestClassGroup.getTestClasses());
        }
        return testClasses;
    }

    protected SegmentTestClassGroup(BatchTestClassGroup parentBatchTestClassGroup) {
        this._batchTestClassGroup = parentBatchTestClassGroup;
    }

    protected SegmentTestClassGroup(BatchTestClassGroup parentBatchTestClassGroup, JSONObject jsonObject) {
        this._batchTestClassGroup = parentBatchTestClassGroup;
        JSONArray axesJSONArray = jsonObject.getJSONArray("axes");
        if (axesJSONArray == null || axesJSONArray.isEmpty()) {
            return;
        }
        for (int i = 0; i < axesJSONArray.length(); ++i) {
            JSONObject axisJSONObject = axesJSONArray.getJSONObject(i);
            if (axisJSONObject == null) continue;
            AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(axisJSONObject, this);
            this._axisTestClassGroups.add(axisTestClassGroup);
            this._batchTestClassGroup.addAxisTestClassGroup(axisTestClassGroup);
        }
    }
}

