/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class JUnitSegmentTestClassGroup
extends SegmentTestClassGroup {
    private static final Pattern _pattern = Pattern.compile(".*/(?<classFileName>com/.*)");

    @Override
    public String getTestCasePropertiesContent() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getTestCasePropertiesContent());
        ArrayList<String> axisIndexes = new ArrayList<String>();
        for (int axisIndex = 0; axisIndex < this.getAxisCount(); ++axisIndex) {
            axisIndexes.add(String.valueOf(axisIndex));
            AxisTestClassGroup axisTestClassGroup = this.getAxisTestClassGroup(axisIndex);
            List<File> testClassFiles = axisTestClassGroup.getTestClassFiles();
            sb.append("TEST_CLASS_GROUP_");
            sb.append(axisIndex);
            sb.append("=");
            for (File testClassFile : testClassFiles) {
                Matcher matcher = _pattern.matcher(testClassFile.toString());
                if (!matcher.find()) continue;
                String classFileName = matcher.group("classFileName");
                sb.append(classFileName.replace(".java", ".class"));
                sb.append(",");
            }
            if (!testClassFiles.isEmpty()) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("\n");
        }
        sb.append("TEST_CLASS_GROUPS=");
        sb.append(JenkinsResultsParserUtil.join(" ", axisIndexes));
        sb.append("\n");
        return sb.toString();
    }

    protected JUnitSegmentTestClassGroup(BatchTestClassGroup batchTestClassGroup) {
        super(batchTestClassGroup);
    }

    protected JUnitSegmentTestClassGroup(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        super(batchTestClassGroup, jsonObject);
    }
}

